/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zdsmaterial.erp.api.IZDSBrandApi;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdsmaterial.material.api.IZDSMaterialCategoryApi;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierBankEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeMaterialInfoService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="matSupplierChange")
public class MatSupplierChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String sourceBillType = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u53d8\u66f4.getCode();
    private static final String targetBillType = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u6863\u6848.getCode();
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IMatSupplierChangeService service;
    @Autowired
    private IMatSupplierService supplierService;
    @Autowired
    private IZDSMatSupManagerApi izdsMatSupManagerApi;
    @Autowired
    private IMatSupplierChangeMaterialInfoService matSupplierChangeMaterialInfoService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBankService bankService;
    @Autowired
    private IBankCategoryService bankCategoryService;
    @Autowired
    private IZDSMaterialCategoryApi materialCategoryApi;
    @Autowired
    private IZDSBrandApi brandApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)this.service.selectById(billId));
        JSONArray resp = this.service.getApprUserList(billId);
        if (resp.size() == 0) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8054\u7cfb\u4eba\u6240\u5c5e\u4f9b\u5e94\u5546\u4e0b\u4f9b\u8d27\u5185\u5bb9\u7684\u7269\u8d44\u5206\u7c7b\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        Date invokeDate = entity.getInvokeDate();
        if (null == invokeDate || DateUtil.compareDate(DateUtil.addDays(invokeDate, 15), new Date()) < 0) {
            return CommonResponse.error((String)"\u8ddd\u79bb\u4e0a\u4e00\u6b21\u8c03\u7528\u5929\u773c\u67e5\u65f6\u95f4\u5df2\u8d85\u8fc715\u5929\uff0c\u8bf7\u66f4\u65b0\u540e\u64cd\u4f5c\uff01");
        }
        this.validate(entity);
        return CommonResponse.success();
    }

    private void validate(MatSupplierChangeEntity entity) {
        this.supplierService.validateUnique(entity.getName(), entity.getSocialCreditCode(), entity.getSupplierId(), "\u53d8\u66f4");
        this.service.validateRunning(entity.getSupplierId(), entity.getId());
        if (CollectionUtils.isEmpty(entity.getBankList())) {
            throw new BusinessException("\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u6761\u94f6\u884c\u4fe1\u606f\uff01");
        }
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)this.service.selectById(billId));
        MatSupplierChangeVO vo = new MatSupplierChangeVO();
        vo.setId(entity.getId());
        vo.setSourceType(entity.getSourceType());
        vo.setStatus("3");
        this.service.updateBillStatus(vo);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)this.service.selectById(billId));
        MatSupplierChangeVO vo = new MatSupplierChangeVO();
        vo.setId(entity.getId());
        vo.setSourceType(entity.getSourceType());
        vo.setStatus("2");
        vo.setFlowType("7");
        this.service.updateBillStatus(vo);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)this.service.selectById(billId));
        this.validate(entity);
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)this.service.selectById(billId));
        this.pushToArchive(entity);
        UserContext user = this.sessionManager.getUserContext();
        String msg = this.supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(entity.getSupplierId(), null, "supChange", billId, true, user.getUserId(), user.getUserName()));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new BusinessException(msg);
        }
        MatSupplierChangeVO vo = new MatSupplierChangeVO();
        vo.setId(entity.getId());
        vo.setSourceType(entity.getSourceType());
        vo.setStatus("6");
        this.service.updateBillStatus(vo);
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean pushToArchive(MatSupplierChangeEntity entity) {
        Map<Long, MatSupplierAttachesEntity> attachMap;
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()));
        MatSupplierEntity saveEntity = EntityUtil.transformFileds(supplier, entity);
        saveEntity.setSourceType("3");
        saveEntity.setCode(supplier.getCode());
        saveEntity.setBillState(supplier.getBillState());
        saveEntity.setThirdSourceId(supplier.getThirdSourceId());
        saveEntity.setTenant(supplier.getTenant());
        saveEntity.setTenantName(supplier.getTenantName());
        saveEntity.setCoordination(supplier.getCoordination());
        if (StringUtil.isNotBlank((CharSequence)supplier.getErpType())) {
            saveEntity.setErpType(supplier.getErpType());
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getCorpErpName())) {
            saveEntity.setCorpErpName(supplier.getCorpErpName());
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getErpCreatorSid())) {
            saveEntity.setErpCreatorSid(supplier.getErpCreatorSid());
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getSysLastUpd())) {
            saveEntity.setSysLastUpd(supplier.getSysLastUpd());
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getErpRegisterName())) {
            saveEntity.setErpRegisterName(supplier.getErpRegisterName());
        }
        if (PlanConstant.SOURCE_TYPE_SUPPLIER.toString().equals(entity.getSourceType())) {
            saveEntity.setPoState(supplier.getPoState());
            saveEntity.setRestrictDate(supplier.getRestrictDate());
            saveEntity.setTypeLabel(supplier.getTypeLabel());
            saveEntity.setCompanyCharacter(supplier.getCompanyCharacter());
        }
        saveEntity.setLinkerList(supplier.getLinkerList());
        if (CollectionUtils.isNotEmpty(supplier.getBankList())) {
            Map<Long, MatSupplierBankEntity> bankMap = supplier.getBankList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            if (CollectionUtils.isNotEmpty(saveEntity.getBankList())) {
                Map<String, BankEntity> bankNameMap = this.bankService.getAllMapByNames(saveEntity.getBankList().stream().map(item -> item.getOpenBank()).collect(Collectors.toList()));
                Map<String, BankCategoryEntity> bankCategoryNameMap = this.bankCategoryService.getAllMapByNames(saveEntity.getBankList().stream().map(item -> item.getBankName()).collect(Collectors.toList()));
                saveEntity.getBankList().forEach(bank -> {
                    if (bankMap.containsKey(bank.getSourceDetailId())) {
                        bank.setBankThirdSourceId(((MatSupplierBankEntity)((Object)((Object)bankMap.get(bank.getSourceDetailId())))).getBankThirdSourceId());
                        bank.setBankSid(((MatSupplierBankEntity)((Object)((Object)bankMap.get(bank.getSourceDetailId())))).getBankSid());
                        bank.setBankCategorySid(((MatSupplierBankEntity)((Object)((Object)bankMap.get(bank.getSourceDetailId())))).getBankCategorySid());
                    }
                    if (StringUtils.isNotBlank((CharSequence)bank.getOpenBank()) && bankNameMap.containsKey(bank.getOpenBank())) {
                        bank.setBankSid(((BankEntity)((Object)((Object)bankNameMap.get(bank.getOpenBank())))).getSourceId());
                    }
                    if (StringUtils.isNotBlank((CharSequence)bank.getBankName()) && bankCategoryNameMap.containsKey(bank.getBankName())) {
                        bank.setBankCategorySid(((BankCategoryEntity)((Object)((Object)bankCategoryNameMap.get(bank.getBankName())))).getSourceId());
                    }
                });
            }
        }
        if (CollectionUtils.isNotEmpty(supplier.getAttachesList())) {
            attachMap = supplier.getAttachesList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            if (CollectionUtils.isNotEmpty(saveEntity.getAttachesList())) {
                saveEntity.getAttachesList().forEach(attach -> {
                    if (attachMap.containsKey(attach.getSourceDetailId())) {
                        attach.setThirdSourceId(((MatSupplierAttachesEntity)((Object)((Object)attachMap.get(attach.getSourceDetailId())))).getThirdSourceId());
                    }
                });
            }
        }
        if (CollectionUtils.isNotEmpty(supplier.getMaterialInfoList())) {
            Map<Long, MatSupplierMaterialInfoEntity> materialMap = supplier.getMaterialInfoList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            if (CollectionUtils.isNotEmpty(saveEntity.getMaterialInfoList())) {
                ArrayList brandIds = new ArrayList();
                ArrayList materialIds = new ArrayList();
                HashMap<String, BrandVO> brandIdMap = new HashMap<String, BrandVO>();
                HashMap<Long, MaterialCategoryVO> materialCategoryIdMap = new HashMap<Long, MaterialCategoryVO>();
                saveEntity.getMaterialInfoList().forEach(material -> {
                    if (materialMap.containsKey(material.getSourceDetailId())) {
                        material.setInfoThirdSourceId(((MatSupplierMaterialInfoEntity)((Object)((Object)materialMap.get(material.getSourceDetailId())))).getInfoThirdSourceId());
                        material.setMaterialSid(((MatSupplierMaterialInfoEntity)((Object)((Object)materialMap.get(material.getSourceDetailId())))).getMaterialSid());
                        material.setBrandSid(((MatSupplierMaterialInfoEntity)((Object)((Object)materialMap.get(material.getSourceDetailId())))).getBrandSid());
                    }
                    if (StringUtils.isNotBlank((CharSequence)material.getBrandId()) && !brandIds.contains(material.getBrandId())) {
                        brandIds.add(Long.valueOf(material.getBrandId()));
                    }
                    if (null != material.getMaterialId() && !materialIds.contains(material.getMaterialId())) {
                        materialIds.add(material.getMaterialId());
                    }
                });
                if (CollectionUtils.isEmpty(materialIds)) {
                    CommonResponse materialResp = this.materialCategoryApi.getAllByIds(materialIds);
                    if (!materialResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)materialResp.getData()))) {
                        this.logger.error("\u6839\u636e\u7269\u8d44\u5206\u7c7bid-{}\u67e5\u8be2\u7269\u8d44\u5206\u7c7b\u4fe1\u606f\u5931\u8d25: {}", (Object)JSONObject.toJSONString(brandIds), (Object)JSONObject.toJSONString((Object)materialResp));
                        throw new BusinessException("\u83b7\u53d6\u4f9b\u8d27\u5185\u5bb9\u7269\u8d44\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    materialCategoryIdMap.putAll(((List)materialResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
                    for (MatSupplierMaterialInfoEntity info : saveEntity.getMaterialInfoList()) {
                        if (!materialCategoryIdMap.containsKey(info.getMaterialId())) continue;
                        info.setMaterialSid(((MaterialCategoryVO)materialCategoryIdMap.get(info.getMaterialId())).getSourceId());
                    }
                }
                if (CollectionUtils.isEmpty(brandIds)) {
                    CommonResponse brandResp = this.brandApi.getAllByIds(brandIds);
                    if (!brandResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)brandResp.getData()))) {
                        this.logger.error("\u6839\u636e\u54c1\u724cid-{}\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25: {}", (Object)JSONObject.toJSONString(brandIds), (Object)JSONObject.toJSONString((Object)brandResp));
                        throw new BusinessException("\u83b7\u53d6\u4f9b\u8d27\u5185\u5bb9\u54c1\u724c\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    brandIdMap.putAll(((List)brandResp.getData()).stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item)));
                    for (MatSupplierMaterialInfoEntity info : saveEntity.getMaterialInfoList()) {
                        if (!brandIdMap.containsKey(info.getBrandId())) continue;
                        info.setBrandSid(((BrandVO)brandIdMap.get(info.getBrandId())).getSourceId());
                    }
                }
            }
        }
        this.supplierService.saveOrUpdate((Object)saveEntity, false);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, "attachMgr", String.valueOf(supplier.getId()), targetBillType, "attachMgr");
        attachMap = supplier.getAttachesList().stream().collect(Collectors.toMap(x -> null != x.getSourceDetailId() ? x.getSourceDetailId() : x.getId(), x -> x));
        for (MatSupplierChangeAttachesEntity source : entity.getAttachesList()) {
            if (!attachMap.containsKey(source.getId())) continue;
            MatSupplierAttachesEntity target = attachMap.get(source.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(source.getId()), sourceBillType, "file", String.valueOf(target.getId()), targetBillType, "file");
        }
        return true;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray resp = this.service.getApprUserList(billId);
        if (resp.size() == 0) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u4e0b\u4f9b\u8d27\u5185\u5bb9\u7684\u7269\u8d44\u5206\u7c7b\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        return CommonResponse.success((Object)resp);
    }
}

