/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAccessEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierAccessService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierInviteFlowService;
import com.ejianc.business.zdssupplier.sub.service.impl.SupplierAccessBpmServiceImpl;
import com.ejianc.business.zdssupplier.sub.vo.SupplierAccessVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierInviteFlowVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jdk.nashorn.internal.ir.annotations.Ignore;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"supplierAccess"})
public class SupplierAccessController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER_ACCESS";
    @Autowired
    private ISupplierAccessService service;
    @Autowired
    private ISupplierInviteFlowService flowService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SupplierAccessBpmServiceImpl bpmService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierAccessVO> saveOrUpdate(@RequestBody SupplierAccessVO saveOrUpdateVO) {
        SupplierAccessVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierAccessVO> queryDetail(Long id) {
        SupplierAccessEntity entity = (SupplierAccessEntity)((Object)this.service.selectById(id));
        SupplierAccessVO vo = (SupplierAccessVO)BeanMapper.map((Object)((Object)entity), SupplierAccessVO.class);
        if (entity.getInviteId() != null) {
            QueryParam param = new QueryParam();
            param.getParams().put("inviteId", new Parameter("eq", (Object)entity.getInviteId()));
            List flowList = this.flowService.queryList(param);
            vo.setFlowList(BeanMapper.mapList((Iterable)flowList, SupplierInviteFlowVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierAccessVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SupplierAccessVO supplierAccessVO : vos) {
            }
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierAccessVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("inviterName");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("inviterId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierAccessVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("inviterName");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SupplierAccess-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSupplierAccessData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierAccessVO>> refSupplierAccessData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierAccessVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveSyncBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Long> saveSyncBill(HttpServletRequest request) {
        return CommonResponse.success((String)"\u63a5\u6536\u6210\u529f\uff01", (Object)this.service.saveSyncBill(request));
    }

    @RequestMapping(value={"/TYCDetail"}, method={RequestMethod.GET})
    @ResponseBody
    @Ignore
    public CommonResponse<SupplierAccessVO> TYCDetail(@RequestParam(value="supplierName") String supplierName, @RequestParam(value="id", required=false) Long id) {
        SupplierAccessVO vo = this.service.TYCDetail(supplierName, id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/syncDetailBill"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierAccessVO> syncDetailBill(Long inviteId) {
        SupplierAccessVO vo = this.service.syncDetailBill(inviteId);
        if (vo.getInviteId() != null) {
            QueryParam param = new QueryParam();
            param.getParams().put("inviteId", new Parameter("eq", (Object)vo.getInviteId()));
            List flowList = this.flowService.queryList(param);
            vo.setFlowList(BeanMapper.mapList((Iterable)flowList, SupplierInviteFlowVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> test(@RequestParam Long id) {
        CommonResponse<String> response = this.bpmService.afterApprovalProcessor(id, null, null);
        SupplierAccessEntity entity = (SupplierAccessEntity)((Object)this.service.selectById(id));
        entity.setBillState(1);
        this.service.updateById((Object)entity);
        return response;
    }
}

