/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.LinkerAccessEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerAccessService;
import com.ejianc.business.zdssupplier.sub.service.ILinkerInviteService;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerInviteVO;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="linkerAccess")
public class LinkerAccessBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String sourceBillType = BillTypeEnum.\u5206\u5305\u8054\u7cfb\u4eba\u51c6\u5165.getCode();
    private static final String targetBillType = BillTypeEnum.\u5206\u5305\u8054\u7cfb\u4eba\u6863\u6848.getCode();
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ILinkerAccessService service;
    @Autowired
    private ILinkerInviteService inviteService;
    @Autowired
    private ILinkerService linkerService;
    @Autowired
    private ISupplierService supplierService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        Integer legalNum;
        LinkerAccessEntity entity = (LinkerAccessEntity)((Object)this.service.selectById(billId));
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()));
        if (PlanConstant.INTEGER_YES.equals(entity.getUserType()) && (legalNum = Integer.valueOf((int)supplier.getLinkerList().stream().filter(x -> PlanConstant.INTEGER_YES.equals(x.getUserType())).count())) > 0) {
            return CommonResponse.error((String)"\u8054\u7cfb\u4eba\u7c7b\u578b\u4e3a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u6700\u591a\u53ea\u80fd\u6709\u4e00\u6761\uff01");
        }
        this.linkerService.validateUnique(entity.getName(), entity.getMobileLinkPhone());
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        LinkerAccessEntity entity = (LinkerAccessEntity)((Object)this.service.selectById(billId));
        LinkerInviteVO inviteVO = new LinkerInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("3");
        this.inviteService.updateBillStatus(inviteVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        LinkerAccessEntity entity = (LinkerAccessEntity)((Object)this.service.selectById(billId));
        LinkerInviteVO inviteVO = new LinkerInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("2");
        inviteVO.setFlowType("7");
        this.inviteService.updateBillStatus(inviteVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SupplierEntity supplier;
        Integer legalNum;
        LinkerAccessEntity entity = (LinkerAccessEntity)((Object)this.service.selectById(billId));
        if (PlanConstant.INTEGER_YES.equals(entity.getUserType()) && (legalNum = Integer.valueOf((int)(supplier = (SupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()))).getLinkerList().stream().filter(x -> PlanConstant.INTEGER_YES.equals(x.getUserType())).count())) > 0) {
            return CommonResponse.error((String)"\u8054\u7cfb\u4eba\u7c7b\u578b\u4e3a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u6700\u591a\u53ea\u80fd\u6709\u4e00\u6761\uff01");
        }
        this.linkerService.validateUnique(entity.getName(), entity.getMobileLinkPhone());
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        LinkerAccessEntity entity = (LinkerAccessEntity)((Object)this.service.selectById(billId));
        Long linkerId = this.pushToArchive(entity);
        String msg = this.supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(entity.getSupplierId(), linkerId, "linkerAdd", billId, true, entity.getInviterId(), entity.getInviterName()));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new BusinessException(msg);
        }
        try {
            this.linkerService.generateAccount(linkerId);
        }
        catch (Exception e) {
            this.logger.error("***********\u5206\u5305\u5546d-{}\uff0c\u8054\u7cfb\u4eba\u51c6\u5165\u6210\u529f\uff0c\u63a8\u9001ERP\u6210\u529f\uff0c\u8054\u7cfb\u4ebaid-{}\u751f\u6210\u534f\u540c\u8d26\u53f7\u5931\u8d25\uff01\uff01\uff01", new Object[]{entity.getSupplierId(), linkerId, e});
        }
        LinkerInviteVO inviteVO = new LinkerInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("6");
        this.inviteService.updateBillStatus(inviteVO);
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long pushToArchive(LinkerAccessEntity entity) {
        LinkerVO save = EntityUtil.clearInvalidEntity(entity, LinkerVO.class);
        save.setAccessId(entity.getId());
        save.setLinkerStatus(Integer.valueOf(0));
        save.setEnableStatus(Integer.valueOf(1));
        save.setChangeVersion(Integer.valueOf(0));
        save.setDateType(Integer.valueOf(0));
        LinkerVO linker = this.linkerService.saveOrUpdate(save, "false", false);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, "attachMgr", String.valueOf(linker.getId()), targetBillType, "attachMgr");
        String sourceType = entity.getUserType() == 2 ? "agentFile" : "legalPersonFile";
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, sourceType, String.valueOf(linker.getId()), targetBillType, sourceType);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, "certify", String.valueOf(linker.getId()), targetBillType, "certify");
        return linker.getId();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        LinkerAccessEntity entity = (LinkerAccessEntity)((Object)this.service.selectById(billId));
        JSONArray resp = this.supplierService.getSupplierApprList(entity.getSupplierId());
        if (resp.size() == 0) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u5206\u5305\u5546\u7684\u53d1\u5c55\u4e13\u4e1a\u6216\u4e3b\u5bfc\u4e13\u4e1a\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\uff01");
        }
        return CommonResponse.success((Object)resp);
    }
}

