/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.sub.bean.LinkerChangeEntity;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.mapper.LinkerMapper;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="linkerService")
public class LinkerServiceImpl
extends BaseServiceImpl<LinkerMapper, LinkerEntity>
implements ILinkerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS_SUB_LINKER";
    private static final String CHANGE_BILL_TYPE = "EJCBT202403000017";
    private static final String SOURCE_TYPE_ONE = "legalPersonFile";
    private static final String SOURCE_TYPE_TWO = "agentFile";
    private static final String LINKER_BILL_TYPE = "EJCBT202403000015";
    @Value(value="${file.openDownUrl}")
    private String openDownUrl;
    @Autowired
    private CoordinationUtil coordinationUtil;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private LinkerMapper linkerMapper;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public LinkerVO saveOrUpdate(LinkerVO saveOrUpdateVO) {
        return this.saveOrUpdate(saveOrUpdateVO, "true", true);
    }

    @Override
    public LinkerVO saveOrUpdate(LinkerVO saveOrUpdateVO, String checkFlag, boolean cooFlag) {
        LinkerEntity entity = (LinkerEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LinkerEntity.class));
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()));
        supplier.getLinkerList().add(entity);
        if (!"false".equals(checkFlag)) {
            this.validateUnique(supplier.getLinkerList());
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        if (cooFlag) {
            if (!"1".equals(supplier.getCoordination())) {
                this.supplierService.createSupTenant(supplier);
            }
            if (!"1".equals(entity.getCoordination())) {
                this.createSupAccount(entity, supplier.getTenant());
            }
        }
        return (LinkerVO)BeanMapper.map((Object)((Object)entity), LinkerVO.class);
    }

    @Override
    public void generateAccount(Long linkerId) {
        LinkerEntity linker = (LinkerEntity)((Object)super.selectById((Serializable)linkerId));
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(linker.getSupplierId()));
        if (!"1".equals(supplier.getCoordination())) {
            this.supplierService.createSupTenant(supplier);
        }
        if (!"1".equals(linker.getCoordination())) {
            if (StringUtils.isBlank((CharSequence)linker.getMobileLinkPhone())) {
                throw new BusinessException("\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a");
            }
            HashMap<String, String> reqParam = new HashMap<String, String>();
            reqParam.put("linkMobile", linker.getMobileLinkPhone());
            reqParam.put("linkName", linker.getName());
            reqParam.put("linkSupType", "sub");
            reqParam.put("supplierAccRole", "\u5206\u5305\u8054\u7cfb\u4eba");
            reqParam.put("supplierTenantId", supplier.getTenant().toString());
            reqParam.put("accRoleCheck", Boolean.TRUE.toString());
            reqParam.put("supplierId", linker.getSupplierId().toString());
            reqParam.put("billId", linker.getId().toString());
            JSONObject resp = this.coordinationUtil.createSupAccount(reqParam);
            JSONObject entity = new JSONObject();
            entity.put("linkPhone", (Object)linker.getMobileLinkPhone());
            entity.put("linkerName", (Object)linker.getName());
            entity.put("linkEmail", (Object)linker.getElectronicMail());
            entity.put("supplierName", (Object)linker.getSupplierName());
            this.coordinationUtil.sendApproveSms(entity);
            this.coordinationUtil.sendApproveEmail(entity);
            linker.setEnableStatus(PlanConstant.INTEGER_YES);
            linker.setCoordination("1");
            linker.setTenant(resp.getLong("tenantId"));
            linker.setSupUserId(resp.getLong("userId"));
            super.saveOrUpdate((Object)linker, false);
        }
    }

    @Override
    public List<LinkerVO> getBySourceIds(List<String> sourceIds) {
        List<Object> resp = new ArrayList<LinkerVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"third_source_id", sourceIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"date_type", (Object)BaseVO.DR_UNDELETE);
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = BeanMapper.mapList((Iterable)list, LinkerVO.class);
        }
        return resp;
    }

    @Override
    public LinkerVO getByMobileLinkPhone(String mobileLinkPhone) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"mobile_link_phone", (Object)mobileLinkPhone);
        query.eq((Object)"coordination", (Object)1);
        query.eq((Object)"date_type", (Object)BaseVO.DR_UNDELETE);
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (LinkerVO)BeanMapper.map(list.get(0), LinkerVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse<LinkerVO> queryDetailBill(HttpServletRequest request) {
        CommonResponse fileResp;
        Integer changeVersion;
        String transData = request.getParameter("transData");
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)transData, JSONObject.class);
        String supUserId = jsonObject.getString("supUserId");
        Long supTenant = jsonObject.getLong("supTenant");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sup_user_id", (Object)supUserId);
        queryWrapper.eq((Object)"date_type", (Object)0);
        if (null != supTenant) {
            queryWrapper.eq((Object)"tenant", (Object)supTenant);
        }
        if (jsonObject.containsKey((Object)"changeVersion") && (changeVersion = jsonObject.getInteger("changeVersion")) > 1) {
            queryWrapper.eq((Object)"change_version", (Object)(changeVersion - 1));
            List list = super.list((Wrapper)queryWrapper);
            if (list.size() == 0) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5355\u636e\uff01");
            }
            LinkerVO vo = (LinkerVO)BeanMapper.map(list.get(0), LinkerVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        List list = super.list((Wrapper)queryWrapper);
        if (list.size() == 0) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5355\u636e\uff01");
        }
        LinkerEntity supplierEntity = (LinkerEntity)((Object)list.get(0));
        LinkerVO vo = (LinkerVO)BeanMapper.map((Object)((Object)supplierEntity), LinkerVO.class);
        ArrayList<Long> fileIds = new ArrayList<Long>();
        if (vo.getUserType() == 1) {
            if (StringUtils.isNotBlank((CharSequence)vo.getLegalPersonFileId())) {
                fileIds.add(Long.valueOf(vo.getLegalPersonFileId()));
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)vo.getAgencyFileId())) {
                fileIds.add(Long.valueOf(vo.getAgencyFileId()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getCertifyFileId())) {
                fileIds.add(Long.valueOf(vo.getCertifyFileId()));
            }
        }
        if (CollectionUtils.isNotEmpty(fileIds)) {
            CommonResponse attachmentVOCommonResponse = this.attachmentApi.queryAllByIds(fileIds);
            if (!attachmentVOCommonResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u9644\u4ef6\u67e5\u8be2\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            if (attachmentVOCommonResponse.getData() == null) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u9644\u4ef6\u67e5\u8be2\u4e3a\u7a7a\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            List attachmentVos = (List)attachmentVOCommonResponse.getData();
            ArrayList<String> filePathList = new ArrayList<String>();
            ArrayList<Long> newFileIds = new ArrayList<Long>();
            for (AttachmentVO attachmentVo : attachmentVos) {
                filePathList.add(this.openDownUrl + attachmentVo.getFilePath());
                newFileIds.add(attachmentVo.getId());
            }
            vo.setFilePathList(filePathList);
            vo.setNewFileIds(newFileIds);
        }
        if ((fileResp = this.attachmentApi.queryNoAuthListBySourceId(vo.getId(), null, null, null)).isSuccess()) {
            vo.setFileList((List)fileResp.getData());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public LinkerVO createSupAccount(LinkerEntity linker, Long supTenantId) {
        if (StringUtils.isBlank((CharSequence)linker.getMobileLinkPhone())) {
            throw new BusinessException("\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a");
        }
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("linkMobile", linker.getMobileLinkPhone());
        reqParam.put("linkName", linker.getName());
        reqParam.put("linkSupType", "sub");
        reqParam.put("supplierAccRole", "\u5206\u5305\u8054\u7cfb\u4eba");
        reqParam.put("supplierTenantId", supTenantId.toString());
        reqParam.put("accRoleCheck", Boolean.TRUE.toString());
        reqParam.put("supplierId", linker.getSupplierId().toString());
        reqParam.put("billId", linker.getId().toString());
        JSONObject resp = this.coordinationUtil.createSupAccount(reqParam);
        JSONObject entity = new JSONObject();
        entity.put("linkPhone", (Object)linker.getMobileLinkPhone());
        entity.put("linkerName", (Object)linker.getName());
        entity.put("linkEmail", (Object)linker.getElectronicMail());
        entity.put("supplierName", (Object)linker.getSupplierName());
        this.coordinationUtil.sendApproveSms(entity);
        this.coordinationUtil.sendApproveEmail(entity);
        linker.setEnableStatus(PlanConstant.INTEGER_YES);
        linker.setCoordination("1");
        linker.setTenant(resp.getLong("tenantId"));
        linker.setSupUserId(resp.getLong("userId"));
        super.saveOrUpdate((Object)linker, false);
        return (LinkerVO)BeanMapper.map((Object)((Object)linker), LinkerVO.class);
    }

    @Override
    public LinkerVO getBySupUserId(Long linkerSupUserId, Long supplierId) {
        LinkerVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"sup_user_id", (Object)linkerSupUserId);
        query.eq((Object)"supplier_id", (Object)supplierId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"date_type", (Object)BaseVO.DR_UNDELETE);
        LinkerEntity e = (LinkerEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            resp = (LinkerVO)BeanMapper.map((Object)((Object)e), LinkerVO.class);
        }
        return resp;
    }

    @Override
    public LinkerVO getSupUserIdAndTenant(Long supUserId, Long tenantId) {
        LinkerVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"sup_user_id", (Object)supUserId);
        query.eq((Object)"tenant", (Object)tenantId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"date_type", (Object)BaseVO.DR_UNDELETE);
        LinkerEntity e = (LinkerEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            resp = (LinkerVO)BeanMapper.map((Object)((Object)e), LinkerVO.class);
        }
        return resp;
    }

    @Override
    public boolean linkerChangeStatus(Long linkerId, Long changeId) {
        LinkerEntity linker = (LinkerEntity)((Object)super.selectById((Serializable)linkerId));
        if (null != linker.getChangeStatus() && linker.getChangeStatus().equals(SupLinkerEnum.\u53d8\u66f4\u4e2d.getCode())) {
            return true;
        }
        linker.setChangeId(changeId);
        linker.setChangeStatus((int)SupLinkerEnum.\u53d8\u66f4\u4e2d.getCode());
        super.saveOrUpdate((Object)linker, false);
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void upLinkerChangeStatus(Long linkerId, Integer changeStatus, LinkerChangeEntity entity) {
        LinkerEntity linkerEntity = (LinkerEntity)((Object)super.selectById((Serializable)linkerId));
        Integer userType = linkerEntity.getUserType();
        linkerEntity.setChangeStatus(changeStatus);
        LinkerEntity oldEntity = null;
        if (null != entity) {
            oldEntity = (LinkerEntity)((Object)BeanMapper.map((Object)((Object)linkerEntity), LinkerEntity.class));
            oldEntity.setId(null);
            oldEntity.setDateType(1);
            oldEntity.setMainLinkerId(linkerId);
            oldEntity.setVersion(null);
            oldEntity.setCreateTime(null);
            oldEntity.setChangeVersion(entity.getChangeVersion());
            oldEntity.setAccessId(null);
            oldEntity.setSupplierId(null);
            oldEntity.setDateType(1);
            if ("1".equals(entity.getUserType())) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"user_type", (Object)1);
                query.ne((Object)"id", (Object)linkerId);
                query.eq((Object)"supplier_id", (Object)linkerEntity.getSupplierId());
                query.eq((Object)"date_type", (Object)BaseVO.DR_UNDELETE);
                int count = super.count((Wrapper)query);
                if (count > 0) {
                    throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u4e0b\u5df2\u5b58\u5728\u6cd5\u5b9a\u4ee3\u8868\u4eba\uff0c\u65e0\u6cd5\u53d8\u66f4\uff01");
                }
            }
            if (!entity.getMobileLinkPhone().equals(linkerEntity.getMobileLinkPhone())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"mobile_link_phone", (Object)entity.getMobileLinkPhone());
                queryWrapper.eq((Object)"enable_status", (Object)1);
                queryWrapper.ne((Object)"id", (Object)linkerId);
                List list = super.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    LinkerEntity matLinkerEntity = (LinkerEntity)((Object)list.get(0));
                    if (!entity.getIdCardId().equals(matLinkerEntity.getIdCardId())) {
                        throw new BusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u53d8\u66f4\uff01");
                    }
                }
            }
            linkerEntity.setMobileLinkPhone(entity.getMobileLinkPhone());
            linkerEntity.setElectronicMail(entity.getElectronicMail());
            linkerEntity.setAddress(entity.getAddress());
            boolean fileChange = true;
            if (String.valueOf(linkerEntity.getUserType()).equals(String.valueOf(entity.getUserType()))) {
                if (userType == 1) {
                    if (null != entity.getLegalPersonFileId()) {
                        fileChange = true;
                    }
                } else {
                    if (null != entity.getAgencyFileId()) {
                        fileChange = true;
                    }
                    if (null != entity.getCertifyFileId()) {
                        fileChange = true;
                    }
                }
            } else {
                fileChange = true;
            }
            if (fileChange) {
                Long fileId;
                ArrayList<Long> delFileIds = new ArrayList<Long>();
                if (Integer.valueOf(1).equals(entity.getUserType())) {
                    if (StringUtils.isNotBlank((CharSequence)linkerEntity.getLegalPersonFileId())) {
                        delFileIds.add(Long.valueOf(linkerEntity.getLegalPersonFileId()));
                    }
                    if (!String.valueOf(linkerEntity.getUserType()).equals(String.valueOf(entity.getUserType()))) {
                        if (StringUtils.isNotBlank((CharSequence)linkerEntity.getAgencyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getAgencyFileId()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)linkerEntity.getCertifyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getCertifyFileId()));
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)entity.getLegalPersonFileId())) {
                        fileId = this.pushSupUtil.uploadFileFormNet(BillTypeEnum.\u5206\u5305\u8054\u7cfb\u4eba\u6863\u6848.getCode(), linkerEntity.getId(), SOURCE_TYPE_ONE, Long.valueOf(entity.getLegalPersonFileId()), this.baseHost);
                        linkerEntity.setLegalPersonFileId(fileId.toString());
                    }
                    linkerEntity.setLegalPersonFileName(linkerEntity.getLegalPersonFileName());
                } else {
                    if (StringUtils.isNotBlank((CharSequence)entity.getAgencyFileId())) {
                        if (StringUtils.isNotBlank((CharSequence)linkerEntity.getAgencyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getAgencyFileId()));
                        }
                        fileId = this.pushSupUtil.uploadFileFormNet(BillTypeEnum.\u5206\u5305\u8054\u7cfb\u4eba\u6863\u6848.getCode(), linkerEntity.getId(), SOURCE_TYPE_TWO, Long.valueOf(entity.getAgencyFileId()), this.baseHost);
                        linkerEntity.setAgencyFileId(fileId.toString());
                        linkerEntity.setAgencyFileName(linkerEntity.getAgencyFileName());
                    }
                    if (StringUtils.isNotBlank((CharSequence)entity.getCertifyFileId())) {
                        if (StringUtils.isNotBlank((CharSequence)linkerEntity.getCertifyFileId())) {
                            delFileIds.add(Long.valueOf(linkerEntity.getCertifyFileId()));
                        }
                        fileId = this.pushSupUtil.uploadFileFormNet(BillTypeEnum.\u5206\u5305\u8054\u7cfb\u4eba\u6863\u6848.getCode(), linkerEntity.getId(), "certify", Long.valueOf(entity.getCertifyFileId()), this.baseHost);
                        linkerEntity.setCertifyFileId(fileId.toString());
                        linkerEntity.setCertifyFileName(linkerEntity.getAgencyFileName());
                    }
                    if (!String.valueOf(linkerEntity.getUserType()).equals(String.valueOf(entity.getUserType())) && StringUtils.isNotBlank((CharSequence)linkerEntity.getLegalPersonFileId())) {
                        delFileIds.add(Long.valueOf(linkerEntity.getLegalPersonFileId()));
                    }
                }
                if (CollectionUtils.isNotEmpty(delFileIds)) {
                    oldEntity.setAttachIds(delFileIds);
                }
            }
            linkerEntity.setUserType(entity.getUserType());
            if (StringUtils.isNotBlank((CharSequence)entity.getUserName())) {
                linkerEntity.setName(entity.getUserName());
                linkerEntity.setUserName(entity.getUserName());
            }
            if (null != entity.getLinkerStatus()) {
                linkerEntity.setLinkerStatus(entity.getLinkerStatus());
            }
        }
        if (null != oldEntity) {
            this.logger.info("\u8054\u7cfb\u4eba\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)((Object)oldEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            super.saveOrUpdate((Object)oldEntity);
        }
        this.logger.info("\u53d8\u66f4\u540e\u8054\u7cfb\u4eba\u6863\u6848\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)linkerEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        super.saveOrUpdate((Object)linkerEntity, false);
    }

    @Override
    public void deleteChange(List<Long> linkerId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"id", linkerId);
        updateWrapper.set((Object)"change_status", (Object)SupLinkerEnum.\u672a\u53d8\u66f4.getCode());
        updateWrapper.set((Object)"change_id", null);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public Boolean validateUnique(LinkerEntity linker, Long id) {
        List linkerList;
        QueryParam param = new QueryParam();
        param.getParams().put("mobileLinkPhone", new Parameter("eq", (Object)linker.getMobileLinkPhone()));
        param.getParams().put("enableStatus", new Parameter("eq", (Object)PlanConstant.INTEGER_YES));
        param.getParams().put("dateType", new Parameter("eq", (Object)PlanConstant.INTEGER_NO));
        if (id != null) {
            param.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty((Collection)(linkerList = super.queryList(param)))) {
            this.logger.error("\u8be5\u8054\u7cfb\u4eba\u7684\u624b\u673a\u53f7{}\u5df2\u751f\u6210\u6863\u6848\u3010{}\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\uff01", (Object)linker.getMobileLinkPhone(), (Object)((LinkerEntity)((Object)linkerList.get(0))).getId());
            throw new BusinessException("\u8054\u7cfb\u4eba[\u540d\u79f0\uff1a" + linker.getName() + "\uff0c\u624b\u673a\u53f7\uff1a" + linker.getMobileLinkPhone() + "]\u5df2\u751f\u6210\u6863\u6848\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\uff01");
        }
        return true;
    }

    @Override
    public Boolean validateUnique(List<LinkerEntity> linkerList) {
        Integer legalNum = (int)(linkerList = linkerList.stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList())).stream().filter(x -> PlanConstant.INTEGER_YES.equals(x.getUserType())).count();
        if (legalNum > 1) {
            throw new BusinessException("\u8054\u7cfb\u4eba\u7c7b\u578b\u4e3a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u6700\u591a\u53ea\u80fd\u6709\u4e00\u6761\uff01");
        }
        for (LinkerEntity linker : linkerList) {
            this.validateUnique(linker, linker.getId());
        }
        return true;
    }

    @Override
    public List<LinkerEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"date_type", (Object)0);
        query.in((Object)"supplier_id", supplierIds);
        return super.list((Wrapper)query);
    }

    @Override
    public List<Map<String, Object>> getLinkerCreatorInf(List<Long> linkerIds) {
        return this.linkerMapper.getLinkerCreatorInf(linkerIds);
    }

    @Override
    public void validateUnique(String name, String mobileLinkPhone) {
        QueryParam param = new QueryParam();
        param.getParams().put("mobileLinkPhone", new Parameter("eq", (Object)mobileLinkPhone));
        param.getParams().put("enableStatus", new Parameter("eq", (Object)PlanConstant.INTEGER_YES));
        param.getParams().put("dateType", new Parameter("eq", (Object)PlanConstant.INTEGER_NO));
        List linkerList = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)linkerList)) {
            this.logger.error("\u8be5\u8054\u7cfb\u4eba\u7684\u624b\u673a\u53f7{}\u5df2\u751f\u6210\u6863\u6848\u3010{}\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\uff01", (Object)mobileLinkPhone, (Object)((LinkerEntity)((Object)linkerList.get(0))).getId());
            throw new BusinessException("\u8054\u7cfb\u4eba[\u540d\u79f0\uff1a" + name + "\uff0c\u624b\u673a\u53f7\uff1a" + mobileLinkPhone + "]\u5df2\u751f\u6210\u6863\u6848\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\uff01");
        }
    }
}

