/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.sub.bean.SupplierCertificateEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierCertificateMapper;
import com.ejianc.business.zdssupplier.sub.service.ISupplierCertificateService;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplierCertificateService")
public class SupplierCertificateServiceImpl
extends BaseServiceImpl<SupplierCertificateMapper, SupplierCertificateEntity>
implements ISupplierCertificateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String CERT_TYPE_DEF_CODE = "zds-certi-category";
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public List<SupplierCertificateEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"supplier_id", supplierIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    @Override
    public Map<String, DefdocDetailVO> getAllCertTypeByCertTypeSid(List<String> certTypeSid) {
        HashMap<String, DefdocDetailVO> resp = new HashMap<String, DefdocDetailVO>();
        if (CollectionUtils.isNotEmpty(certTypeSid)) {
            CommonResponse certTypeResp = this.defdocApi.queryDetailListByDefdocCodeList(new ArrayList<String>(certTypeSid));
            if (!certTypeResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)certTypeResp.getData()))) {
                this.logger.error("\u6839\u636e\u8d44\u8d28\u7c7b\u522bSId-{}\u67e5\u8be2\u5931\u8d25", (Object)JSONObject.toJSONString(certTypeSid), (Object)JSONObject.toJSONString((Object)certTypeResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else {
                resp.putAll(((List)certTypeResp.getData()).stream().collect(Collectors.toMap(item -> item.getCode(), item -> item)));
            }
        }
        return resp;
    }

    @Override
    public Map<String, DefdocDetailVO> getAllCertTypeByCertTypeName(List<String> certTypeName) {
        HashMap<String, DefdocDetailVO> resp = new HashMap<String, DefdocDetailVO>();
        if (CollectionUtils.isNotEmpty(certTypeName)) {
            CommonResponse certTypeResp = this.defdocApi.noAuthDetailListByDetailNamesAndDocCode(new ArrayList<String>(certTypeName), "zds-certi-category");
            if (!certTypeResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)certTypeResp.getData()))) {
                this.logger.error("\u6839\u636e\u8d44\u8d28\u7c7b\u522b\u540d\u79f0-{}\u67e5\u8be2\u5931\u8d25", (Object)JSONObject.toJSONString(certTypeName), (Object)JSONObject.toJSONString((Object)certTypeResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else {
                resp.putAll(((List)certTypeResp.getData()).stream().collect(Collectors.toMap(item -> item.getName(), item -> item)));
            }
        }
        return resp;
    }
}

