/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.sub.bean.SupplierManagerEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierManagerMapper;
import com.ejianc.business.zdssupplier.sub.service.ISupplierManagerService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierManagerVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplierManagerService")
public class SupplierManagerServiceImpl
extends BaseServiceImpl<SupplierManagerMapper, SupplierManagerEntity>
implements ISupplierManagerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CoordinationUtil coordinationUtil;

    @Override
    public SupplierManagerVO createSupAccount(SupplierManagerEntity entity, Long supTenantId) {
        this.logger.info("\u9879\u76ee\u7ecf\u7406id-{}\u751f\u6210\u4f9b\u65b9supTenant-{}\u534f\u540c\u8d26\u6237-------start", (Object)entity.getId(), (Object)supTenantId);
        if (StringUtils.isBlank((CharSequence)entity.getMobileLinkPhone())) {
            throw new BusinessException("\u9879\u76ee\u7ecf\u7406\u7535\u8bdd\u4e3a\u7a7a");
        }
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("linkMobile", entity.getMobileLinkPhone());
        reqParam.put("linkName", entity.getProjectManagerName());
        reqParam.put("linkSupType", "sub");
        reqParam.put("supplierAccRole", "\u5206\u5305\u9879\u76ee\u7ecf\u7406");
        reqParam.put("supplierTenantId", supTenantId.toString());
        reqParam.put("accRoleCheck", Boolean.TRUE.toString());
        reqParam.put("supplierId", entity.getSupplierId().toString());
        reqParam.put("billId", entity.getId().toString());
        JSONObject resp = this.coordinationUtil.createSupAccount(reqParam);
        entity.setCoordination("1");
        entity.setSynergyAccountStatus(PlanConstant.INTEGER_YES);
        entity.setTenant(resp.getLong("tenantId"));
        entity.setSupUserId(resp.getLong("userId"));
        super.saveOrUpdate((Object)entity, false);
        return (SupplierManagerVO)BeanMapper.map((Object)((Object)entity), SupplierManagerVO.class);
    }

    @Override
    public List<SupplierManagerEntity> getAllBySupplierIds(List<Long> supplierIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"supplier_id", supplierIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }
}

