package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.bean.AdministrativeAreaEntity;
import com.ejianc.business.zds.archive.service.IAdministrativeAreaService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.AdministrativeAreaVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 行政地区实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("administrativeArea")
public class AdministrativeAreaController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAdministrativeAreaService service;

    private final String AREA_ERP_REQ_URL = "/cefoc/yql/getAreaList";

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AdministrativeAreaVO> queryDetail(Long id) {
    	AdministrativeAreaEntity entity = service.selectById(id);
    	AdministrativeAreaVO vo = BeanMapper.map(entity, AdministrativeAreaVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AdministrativeAreaVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<AdministrativeAreaEntity> page = service.queryPage(param,false);
        IPage<AdministrativeAreaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AdministrativeAreaVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refAdministrativeAreaData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refAdministrativeAreaData(@RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("longCode");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(StringUtils.isNotBlank(searchText)) {
            param.setSearchText(searchText);
        }

        param.getOrderMap().put("sequence", "asc");
        param.getOrderMap().put("longCode", "asc");

        List<AdministrativeAreaEntity> list = service.queryList(param);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);

        return ResultAsTree.createTreeData(resultMapList);
     }

    @PostMapping(value = "/zdsAreaSync")
    public CommonResponse<String> zdsAreaSync() {
        logger.info("*********************中电四-行政地区信息同步任务 开始*********************");
        Integer pageNum = 0;
        Integer pageSize = Integer.valueOf(ZdsReqUtil.getErpDataBatchSize());
        Map<String, Integer> param = new HashMap<>();
        String reqUrl = ZdsReqUtil.getErpReqHost() + AREA_ERP_REQ_URL;
        boolean hasNext = true;
        Map<String, String> headers = null;

        try {
            headers = ZdsReqUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData =null;

            param.put("PageNum", ++pageNum);
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param),
                    headers, HttpTookit.connTimeout, HttpTookit.readTimeout);

            reqJson = JSONObject.parseObject(reqResp);

            if("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                if(null != pageData && pageData.size() > 0) {
                    logger.info("中电四行政地区同步，处理第{}页, {}条数据", pageNum, pageData.size());
                    handleErpPageData(pageData);
                } else {
                    logger.info("中电四行政地区同步 处理数据完成！！！总共{}页数据！", pageNum);
                }
            } else {
                logger.error("请求中电四获取行政地区结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取中电四行政地区信息异常, 请求地址：{}, 请求参数：{}",
                    reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            return CommonResponse.error("同步中电四行政地区信息异常");
        }

        logger.info("*********************中电四-行政地区信息同步任务 结束*********************");
        return CommonResponse.success("中电四行政地区同步完成！");
    }

    private void handleErpPageData(JSONArray pageData) {
        JSONObject tmp = null;
        AdministrativeAreaEntity tmpEntity = null;
        Map<String, AdministrativeAreaEntity> sourceIdMap = new HashMap<>();
        Map<String, AdministrativeAreaEntity> dataMap = new HashMap<>();
        List<AdministrativeAreaEntity> saveList = new ArrayList<>();
        Set<String> sourceIds = new HashSet<>();

        for(Object obj : pageData) {
            tmp = (JSONObject) obj;
            tmpEntity = new AdministrativeAreaEntity();
            tmpEntity.setId(IdWorker.getId());
            tmpEntity.setName(tmp.getString("Title")); //名称
            tmpEntity.setSourceId(tmp.getString("C_SD_AreaOID")); //主键
            tmpEntity.setEnabled("True".equals(tmp.getString("IsEnable")) ? "1" : "0"); //停启用
            tmpEntity.setSequence(null != tmp.get("Sort_ID") ? tmp.getInteger("Sort_ID") : 1); //序号
            tmpEntity.setMemo(null != tmp.getString("Memo") ? tmp.getString("Memo") : null); //备注
            tmpEntity.setLongCode(tmp.getString("Long_code")); //长编码
            tmpEntity.setShortCode(tmp.getString("Short_code")); //短编码
            tmpEntity.setCode(tmp.getString("Title_ID")); //代码
            if(StringUtils.isNotBlank(tmp.getString("C_SD_Area_FK")) && !ZdsReqUtil.EMPTY.equals(tmp.getString("C_SD_Area_FK"))) {
                tmpEntity.setSourceParentId(tmp.getString("C_SD_Area_FK"));
                sourceIds.add(tmpEntity.getSourceParentId());
            }
            sourceIds.add(tmpEntity.getSourceId());

            dataMap.put(tmpEntity.getSourceId(), tmpEntity);
        }

        List<AdministrativeAreaEntity> dbListBySourceId = service.getAllBySourceIds(new ArrayList<>(sourceIds));
        if(CollectionUtils.isNotEmpty(dbListBySourceId)) {
            sourceIdMap = dbListBySourceId.stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        }


        //更新列表
        AdministrativeAreaEntity saveEntity = null;
        AdministrativeAreaEntity parent = null;
        for(AdministrativeAreaEntity item : dataMap.values()) {
            if(sourceIdMap.containsKey(item.getSourceId())) {
                saveEntity = sourceIdMap.get(item.getSourceId());
                saveEntity.setName(item.getName());
                saveEntity.setEnabled(item.getEnabled());
                saveEntity.setSequence(item.getSequence());
                saveEntity.setMemo(item.getMemo());
                saveEntity.setLongCode(item.getLongCode());
                saveEntity.setShortCode(item.getShortCode());
                saveEntity.setCode(item.getCode());
                saveEntity.setSourceParentId(item.getSourceParentId());
            } else {
                saveEntity = item;
            }

            if(StringUtils.isNotBlank(item.getSourceParentId())) {
                parent = sourceIdMap.get(item.getSourceParentId());
                if(null == parent) {
                    parent = dataMap.get(item.getSourceParentId());
                }
                if(null == parent) {
                    logger.error("地区-{}，父级地区sid-{}不存在，保存失败", item.getName(), item.getSourceParentId());
                    continue;
                }
                saveEntity.setParentId(parent.getId());
            }

            saveList.add(saveEntity);
        }

        logger.info("本次保存数据-{}条", saveList.size());
        service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }
}
