package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zds.archive.constants.EvaPendingStatusEnums;
import com.ejianc.business.zds.archive.constants.SubEvaLevelEnums;
import com.ejianc.business.zds.archive.constants.SubEvaResultEnums;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.SubEvaluationVO;
import com.ejianc.business.zdssupplier.common.constants.SupplierCommonConstants;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.google.common.base.Stopwatch;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @author CJ
 * @Description:
 * @date 2024/3/26 15:57
 */
@RestController
@RequestMapping(value = "subEvaluation")
public class SubEvaluationController {

    private final String REQ_URL = "/cefoc/yql/getEvaluationLaunchList";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMatSupplierService matSupplierService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private IMatLinkerService matLinkerService;

    @Autowired
    private ILinkerService linkerService;

    @Autowired
    private IProjectPoolApi projectPoolApi;


    @GetMapping(value = "getList")
    public CommonResponse<JSONObject> getInquiryList(@RequestParam Long supplierTenant,
                                                     @RequestParam Long linkerSupUserId,
                                                     @RequestParam String supplierType) {
        JSONObject resp = new JSONObject();

        String supplierSID = null;
        String idCardId = null;
        String linkerSid = null;
        if(SupplierCommonConstants.SUPPLIER_MATERIAL.equals(supplierType)) {
            //物资供应商
            MatSupplierVO supplier = matSupplierService.getByTenantId(supplierTenant);
            if(null == supplier) {
                return CommonResponse.error("未查询到匹配的供应商信息");
            }

            MatLinkerVO linker = matLinkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if(null == linker) {
                return CommonResponse.error("未查询到匹配的联系人信息");
            }
            supplierSID = supplier.getThirdSourceId();
            idCardId = linker.getIdCardId();
            linkerSid = linker.getThirdSourceId();
        } else {
            //分包供应商
            SupplierVO supplier = supplierService.getByTenantId(supplierTenant);
            if(null == supplier) {
                return CommonResponse.error("未查询到匹配的供应商信息");
            }
            LinkerVO linker = linkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if(null == linker) {
                return CommonResponse.error("未查询到匹配的联系人信息");
            }
            supplierSID = supplier.getThirdSourceId();
            idCardId = linker.getIdCardId();
            linkerSid = linker.getThirdSourceId();
        }

        Map<String, String> headers = null;
        Integer pageNum = 1;
        Integer pageSize = 60;
        JSONObject param = new JSONObject();
        String reqUrl = ZdsReqUtil.getErpReqHost() + REQ_URL;

        //根据供应商SID+联系人IdCard查询询价列表
        try {
            if(StringUtils.isNotBlank(supplierSID)) {
                reqUrl = reqUrl + "?CompanyOID="+supplierSID;
            }
            if(StringUtils.isNotBlank(idCardId)) {
                reqUrl = reqUrl + (reqUrl.indexOf("?") > 0 ? "&" : "?")  +"IdCard="+idCardId;
            }
            if(StringUtils.isNotBlank(linkerSid)) {
                reqUrl = reqUrl + (reqUrl.indexOf("?") > 0 ? "&" : "?") +"ContactsOID="+linkerSid;
            }

            headers = ZdsReqUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            param.put("pageNum", pageNum);
            param.put("CompanyOID", supplierSID);
            param.put("IdCard", idCardId);
            param.put("ContactsOID", linkerSid);
            JSONObject reqJson = null;
            JSONArray pageData =null;

            Stopwatch start = Stopwatch.createStarted();
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param),
                    headers, ZdsReqUtil.DEFAULT_TIME_OUT, ZdsReqUtil.DEFAULT_TIME_OUT);
            Stopwatch end = start.stop();
            logger.info("请求ERP分包评价列表，参数：{}，结束。共计耗时：「{}」秒", JSONObject.toJSONString(param, SerializerFeature.WriteNullListAsEmpty), end.elapsed(TimeUnit.SECONDS));
            reqJson = JSONObject.parseObject(reqResp);

            if("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                logger.info("请求ERP分包评价列表返回数据：{} 条", null != pageData ? pageData.size() : 0);
                resp = handlePageData(pageData);
                return CommonResponse.success("查询成功！", resp);
            } else {
                logger.error("请求ERP分包评价列表失败，参数：{}，结果：{}", JSONObject.toJSONString(param), reqResp);
                return CommonResponse.error("请求ERP获取分包评价信息失败！");
            }
        } catch (Exception e) {
            logger.error("根据供应商SID-{}，联系人SID-{}查询供应商分包评价列表异常，", supplierTenant.toString(), linkerSupUserId.toString(), e);
            return CommonResponse.error("请求ERP获取分包评价信息失败！");
        }
    }

    private JSONObject handlePageData(JSONArray pageData) {
        JSONObject resp = new JSONObject();
        resp.put("total", 0);
        resp.put("records", new ArrayList<>());
        List<SubEvaluationVO> list = new ArrayList<>();

        Set<String> projectCodes = new HashSet<>();
        if(null != pageData && pageData.size() > 0) {
            JSONObject tmp = null;
            SubEvaluationVO tmpSubEva = null;
            for(Object obj : pageData) {
                tmp = (JSONObject) obj;
                tmpSubEva = new SubEvaluationVO();

                tmpSubEva.setSupplierName(tmp.getString("Contract_PartyB")); //供应商
                tmpSubEva.setSupplierLinkerName(tmp.getString("PartBContacts"));//供应商联系人
                tmpSubEva.setProjectCode(tmp.getString("Account_Project_id")); //项目SID
                tmpSubEva.setEvaLevel(tmp.getString("EvaLevel")); //评价等级： 1-优秀，2-良好，3-可接受，4-需改进，5-不合格
                tmpSubEva.setResult(tmp.getString("PEResult")); //项目评价结果：0-单指标不合格，1-需改进，2不合格
                tmpSubEva.setPendingStatus(tmp.getString("pendingStatus"));//处理状态：0未处理，1-处理中，2-已处理，3-超时未处理
                tmpSubEva.setEvaDate(DateUtil.parseDate(tmp.getString("EvaInitiationDate"), "yyyy/MM/dd HH:mm:ss"));
                tmpSubEva.setId(tmp.getString("C_PS_EvaluationLaunchOID"));
                tmpSubEva.setUnQualifiedItem(tmp.getString("PESIUnqualifiedItem")); //不合格项

                if(!"1".equals(tmpSubEva.getPendingStatus())) {
                    //非待处理的项不做展示
                    continue;
                }

                tmpSubEva.setEvaLevelName(SubEvaLevelEnums.getNameByCode(tmpSubEva.getEvaLevel()));
                tmpSubEva.setResultName(SubEvaResultEnums.getNameByCode(tmpSubEva.getResult()));
                tmpSubEva.setPendingStatusName(EvaPendingStatusEnums.getNameByCode(tmpSubEva.getPendingStatus()));

                if(null != tmpSubEva.getProjectCode()) {
                    projectCodes.add(tmpSubEva.getProjectCode());
                }
                list.add(tmpSubEva);
            }

            if(CollectionUtils.isNotEmpty(projectCodes)) {
                CommonResponse<List<ProjectPoolSetVO>> prjResp =  projectPoolApi.getAllByCodes(new ArrayList<>(projectCodes));
                Map<String, String> prjCodeNameMap = new HashMap<>();
                if(prjResp.isSuccess()) {
                    if(CollectionUtils.isNotEmpty(prjResp.getData())) {
                        prjResp.getData().stream().forEach(item -> {
                            prjCodeNameMap.put(item.getCode(), item.getName());
                        });
                    }
                }
                list.stream().filter(item -> prjCodeNameMap.containsKey(item.getProjectCode()))
                        .forEach(item -> item.setProjectName(prjCodeNameMap.get(item.getProjectCode())));
            }

            resp.put("total", list.size());
            resp.put("records", list);
        }



        return resp;
    }
}
