package com.ejianc.business.zds.archive.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zds.archive.mapper.AdministrativeAreaMapper;
import com.ejianc.business.zds.archive.bean.AdministrativeAreaEntity;
import com.ejianc.business.zds.archive.service.IAdministrativeAreaService;

import java.util.List;

/**
 * 行政地区实体
 * 
 * @author generator
 * 
 */
@Service("administrativeAreaService")
public class AdministrativeAreaServiceImpl extends BaseServiceImpl<AdministrativeAreaMapper, AdministrativeAreaEntity> implements IAdministrativeAreaService{

    @Override
    public List<AdministrativeAreaEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper<AdministrativeAreaEntity> query = new QueryWrapper<>();
        query.in("source_id", sourceIds);
        query.in("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }

    @Override
    public List<AdministrativeAreaEntity> getAllByCodes(List<String> codes) {
        QueryWrapper<AdministrativeAreaEntity> query = new QueryWrapper<>();
        query.in("code", codes);
        query.in("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }

    @Override
    public List<AdministrativeAreaEntity> getAllByNames(List<String> names) {
        QueryWrapper<AdministrativeAreaEntity> query = new QueryWrapper<>();
        query.in("name", names);
        query.in("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }
}
