package com.ejianc.business.zds.archive.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zds.archive.bean.SubTypeManagerEntity;
import com.ejianc.business.zds.archive.mapper.SubTypeManagerMapper;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 分包类型负责人实体
 * 
 * @author generator
 * 
 */
@Service("subTypeManagerService")
public class SubTypeManagerServiceImpl extends BaseServiceImpl<SubTypeManagerMapper, SubTypeManagerEntity> implements ISubTypeManagerService {

    @Autowired
    private SubTypeManagerMapper mapper;

    @Override
    public List<SubTypeManagerEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper<SubTypeManagerEntity> query = new QueryWrapper<>();
        query.in("source_id", sourceIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<Long> getSubTypeIdsByUserId(String employeeId) {
        List<Long> resp = new ArrayList<>();
        QueryWrapper<SubTypeManagerEntity> query = new QueryWrapper<>();
        query.eq("manager_id", employeeId);
        query.eq("enabled", 1);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<SubTypeManagerEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = list.stream().filter(item -> null != item.getSubTypeId()).map(SubTypeManagerEntity::getSubTypeId).collect(Collectors.toList());
        }

        return resp;
    }

    @Override
    public List<SubTypeManagerEntity> getAllBySubTypeId(Long subTypeId) {
        QueryWrapper<SubTypeManagerEntity> query = new QueryWrapper<>();
        query.eq("sub_type_id", subTypeId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<SubTypeManagerEntity> getAllBySubTypeIds(List<Long> subTypeIds) {
        QueryWrapper<SubTypeManagerEntity> query = new QueryWrapper<>();
        query.in("sub_type_id", subTypeIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<SubTypeManagerEntity> getAllBySubTypeSids(List<String> subTypeSids) {
        QueryWrapper<SubTypeManagerEntity> query = new QueryWrapper<>();
        query.in("sub_type_sid", subTypeSids);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public void disEnableAll() {
        mapper.disEnableAll();
    }
}
