package com.ejianc.business.zdssupplier.material.controller;

import java.io.Serializable;

import com.ejianc.business.zdssupplier.material.bean.MatSupplierAccessEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierInviteFlowEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierInviteFlowService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierAccessVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierInviteFlowVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import jdk.nashorn.internal.ir.annotations.Ignore;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 物资供应商准入
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("matSupplierAccess")
public class MatSupplierAccessController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER_ACCESS";//此处需要根据实际修改

    @Autowired
    private IMatSupplierAccessService service;

    @Autowired
    private IMatSupplierInviteFlowService flowService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MatSupplierAccessVO> saveOrUpdate(@RequestBody MatSupplierAccessVO saveOrUpdateVO) {
        MatSupplierAccessVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatSupplierAccessVO> queryDetail(Long id) {
    	MatSupplierAccessEntity entity = service.selectById(id);
    	MatSupplierAccessVO vo = BeanMapper.map(entity, MatSupplierAccessVO.class);
        // 流转记录
        if(entity.getInviteId() != null){
            QueryParam param = new QueryParam();
            param.getParams().put("inviteId", new Parameter(QueryParam.EQ, entity.getInviteId()));
            List<MatSupplierInviteFlowEntity> flowList = flowService.queryList(param);
            vo.setFlowList(BeanMapper.mapList(flowList, MatSupplierInviteFlowVO.class));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatSupplierAccessVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MatSupplierAccessVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> ids = vos.stream().map(MatSupplierAccessVO::getId).collect(Collectors.toList());
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MatSupplierAccessVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("inviterName");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 根据邀请人过滤
        param.getParams().put("inviterId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));

//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<MatSupplierAccessEntity> page = service.queryPage(param,false);
        IPage<MatSupplierAccessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatSupplierAccessVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("inviterName");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MatSupplierAccessEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MatSupplierAccess-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMatSupplierAccessData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MatSupplierAccessVO>> refMatSupplierAccessData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MatSupplierAccessEntity> page = service.queryPage(param,false);
        IPage<MatSupplierAccessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatSupplierAccessVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 保存同步单据
     * @param request
     * @return
     */
    @RequestMapping(value = "/saveSyncBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> saveSyncBill(HttpServletRequest request) {
        return CommonResponse.success("接收成功！", service.saveSyncBill(request));
    }

    /**
     * 供应商名称调用天眼查
     * @param supplierName
     * @param id
     * @return
     */
    @RequestMapping(value = "/TYCDetail", method = RequestMethod.GET)
    @ResponseBody
    @Ignore
    public CommonResponse<MatSupplierAccessVO> TYCDetail(@RequestParam("supplierName") String supplierName,
            @RequestParam(value = "id", required = false) Long id) {
        MatSupplierAccessVO vo = service.TYCDetail(supplierName, id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description syncDetailBill 根据邀请链接重新拉取分供方准入信息
     * @param inviteId
     */
    @RequestMapping(value = "/syncDetailBill", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MatSupplierAccessVO> syncDetailBill(Long inviteId) {
        MatSupplierAccessVO vo = service.syncDetailBill(inviteId);
        // 流转记录
        if(vo.getInviteId() != null){
            QueryParam param = new QueryParam();
            param.getParams().put("inviteId", new Parameter(QueryParam.EQ, vo.getInviteId()));
            List<MatSupplierInviteFlowEntity> flowList = flowService.queryList(param);
            vo.setFlowList(BeanMapper.mapList(flowList, MatSupplierInviteFlowVO.class));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
}
