package com.ejianc.business.zdssupplier.material.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 物资供应商档案
 * 
 * @author generator
 * 
 */
public interface IMatSupplierService extends IBaseService<MatSupplierEntity> {

    MatSupplierVO saveOrUpdate(MatSupplierVO saveOrUpdateVO);

    /**
     * 供方查询详情
     * @param request
     * @return
     */
    CommonResponse<MatSupplierEntity> queryDetailBill(HttpServletRequest request);

    /**
     * 供应商生成协同租户
     * @param supplier
     * @return
     */
    TenantVO createSupTenant(MatSupplierEntity supplier);

    MatSupplierVO getByTenantId(Long supplierTenant);

    List<MatSupplierEntity> getAllByThirdSourceIds(List<String> thirdSourceIds);

    /**
     * 校验统一社会信用代码唯一性
     * @param socialCreditCode
     * @return
     */
    Boolean validateUnique(String name, String socialCreditCode, Long id, String operate);

    String syncSupplierChangeToErp(SupplierSyncErpParamVO supplierSyncErpParamVO);

    String sendMq(String queueName, String body);

    void syncSupplierErpSid(Long supplierId);

    JSONObject getSupErpInfo(Long supplierId);

    MatSupplierVO saveOrUpdateSupInfo(MatSupplierVO save, boolean b);

    void generateLinkerAcc(Long supplierId);

    List<Long> getSignConSupplierIds(Long projectId);

    JSONArray getApprUserList(Long supplierId);
}
