package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.*;
import com.ejianc.business.zdssupplier.material.service.*;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierAttachesVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierInviteVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

@Service("matSupplierAccess") 
public class MatSupplierAccessBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String sourceBillType = BillTypeEnum.物资供应商准入.getCode();
	private static final String targetBillType = BillTypeEnum.物资供应商档案.getCode();

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private IMatSupplierAccessService service;

	@Autowired
	private IMatSupplierInviteService inviteService;

	@Autowired
	private IMatSupplierService supplierService;

	@Autowired
	private IZDSMatSupManagerApi izdsMatSupManagerApi;

	@Autowired
	private IMatLinkerService matLinkerService;

	@Autowired
	private IMatSupplierAccessMaterialInfoService matSupplierAccessMaterialInfoService;

	@Autowired
	private IEmployeeApi employeeApi;

	@Autowired
	private IOrgApi orgApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("供应商准入提交前校验：id:{}", billId);
		MatSupplierAccessEntity entity = service.selectById(billId);
		Date invokeDate = entity.getInvokeDate();
		if(DateUtil.compareDate(DateUtil.addDays(invokeDate, 15), new Date()) < 0){
			return CommonResponse.error("距离上一次调用天眼查时间已超过15天，请更新后操作！");
		}
		// 校验
		this.validate(entity);
		return CommonResponse.success();
	}

	/**
	 * 校验
	 * @param entity
	 */
	private void validate(MatSupplierAccessEntity entity) {
		// 校验统一社会信用代码唯一性
		service.validateUnique(entity.getName(), entity.getSocialCreditCode(), entity.getId());

		if(CollectionUtils.isEmpty(entity.getLinkerList())){
			throw new BusinessException("请添加至少一条联系人！");
		}
		if(CollectionUtils.isEmpty(entity.getBankList())){
			throw new BusinessException("请添加至少一条银行信息！");
		}
		if(CollectionUtils.isEmpty(entity.getMaterialInfoList())){
			throw new BusinessException("请添加至少一条供货信息！");
		}

		//校验联系人是否存在重复身份
		matLinkerService.validateUnique(BeanMapper.mapList(entity.getLinkerList(), MatLinkerEntity.class));

		Map<String, Boolean> nameMap = PlanConstant.matCompanyAttachNameMap;
		if(PlanConstant.STRING_YES.equals(entity.getCompanyCharacter())){
			nameMap = PlanConstant.pdCompanyAttachNameMap;
		}
		// 校验附件必输性
		for(MatSupplierAccessAttachesEntity attach : entity.getAttachesList()){
			if(nameMap.containsKey(attach.getFileType()) && nameMap.get(attach.getFileType()) && null == attach.getFileId()){
				throw new BusinessException(attach.getFileType() + "未上传附件，请上传并保存后提交！");
			}
//			if(PlanConstant.matPersonAttachNameMap.containsKey(attach.getFileType()) &&
//					PlanConstant.matPersonAttachNameMap.get(attach.getFileType()) && null == attach.getFileId()){
//				throw new BusinessException(attach.getFileType() + "未上传附件，请上传并保存后提交！");
//			}
		}
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		MatSupplierAccessEntity entity = service.selectById(billId);
		// 修改邀请状态并生成流水
		MatSupplierInviteVO inviteVO = new MatSupplierInviteVO();
		inviteVO.setId(entity.getInviteId());
		inviteVO.setStatus(PlanConstant.INVITE_STATUS_COMMIT);
		inviteService.updateBillStatus(inviteVO);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		MatSupplierAccessEntity entity = service.selectById(billId);
		// 修改邀请状态并生成流水
		MatSupplierInviteVO inviteVO = new MatSupplierInviteVO();
		inviteVO.setId(entity.getInviteId());
		inviteVO.setStatus(PlanConstant.INVITE_STATUS_AFFIRM);
		inviteVO.setFlowType(PlanConstant.FLOW_TYPE_APPROVE_BACK);
		inviteService.updateBillStatus(inviteVO);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		MatSupplierAccessEntity entity = service.selectById(billId);
		// 校验
		this.validate(entity);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		MatSupplierAccessEntity entity = service.selectById(billId);
		// 生成档案
		Long supplierId = this.pushToArchive(entity);

		//推送ERP
		String msg = supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(supplierId, null,
				PlanConstant.供应商新增同步ERP, billId, true, entity.getInviterId(), entity.getInviterName()));
		if(StringUtils.isNotBlank(msg)) {
			throw new BusinessException(msg);
		}

		//推送ERP成功后生成联系人协同账号
		try {
			supplierService.generateLinkerAcc(supplierId);
		} catch (Exception e) {
			logger.error("***********供应商准入成功，推送ERP成功，供应商id-{}生成联系人账号失败",supplierId, e);
		}


		// 修改邀请状态并生成流水
		MatSupplierInviteVO inviteVO = new MatSupplierInviteVO();
		inviteVO.setId(entity.getInviteId());
		inviteVO.setStatus(PlanConstant.INVITE_STATUS_APPROVE);
		inviteService.updateBillStatus(inviteVO);
		return CommonResponse.success();
	}

	/**
	 * 生成档案
	 * @param entity
	 */
	@Transactional(rollbackFor = Exception.class)
	public Long pushToArchive(MatSupplierAccessEntity entity) {
		// 初始化数据，包含子表
		MatSupplierVO save = EntityUtil.clearInvalidEntity(entity, MatSupplierVO.class);
		save.setAccessId(entity.getId());
//		save.setThirdSourceId(UUID.randomUUID().toString());// 推送ERP
		save.setCode(EntityUtil.createBillCode(save, PlanConstant.物资供应商编码规则));
		save.getLinkerList().forEach(vo->{
			vo.setLinkerStatus(2);// 默认在职
			vo.setEnableStatus(1);// 默认启用
			vo.setChangeVersion(0);//默认0
			vo.setDateType(0);//默认 档案
			vo.setSupplierCode(save.getCode());
			vo.setSupplierName(save.getName());
			vo.setCode(EntityUtil.createBillCode(vo, PlanConstant.物资联系人编码规则));
		});
		save.setCompanyGrade("临时"); //公司等级 默认：临时
		save.setCompanyState("正常"); //公司状态 默认：正常


		save.setErpType(PlanConstant.ERP_MAT_INFO_TYPE_MAPPING.get(entity.getType()));

		//设置供应商录入人信息
		EmployeeVO creator = null;
		if("1".equals(entity.getSourceType())) {
			//代注册
			CommonResponse<EmployeeVO> empResp = employeeApi.getByEmpmloyeeCode(entity.getCreateUserCode());
			if(!empResp.isSuccess() || null == empResp.getData()) {
				throw new BusinessException("操作失败，获取代注册人员信息失败！");
			}
			creator = empResp.getData();
		} else {
			//邀请
			CommonResponse<EmployeeVO> empResp = employeeApi.getById(entity.getInviterId());
			if(!empResp.isSuccess() || null == empResp.getData()) {
				throw new BusinessException("操作失败，获取代注册人员信息失败！");
			}
			creator = empResp.getData();
		}
		save.setErpCreatorSid(creator.getSourceId());
		save.setErpRegisterName(creator.getName());


		//如果创建人所属组织和供应商归属部门不一致，则使用创建人所属组织作为归属部门
		if(null != creator.getOrgId() && (null == entity.getCorpId() ||  !creator.getOrgId().equals(entity.getCorpId()))) {
			entity.setCorpId(creator.getOrgId());
		}

		//查询归属部门信息
		if(null != entity.getCorpId()) {
			OrgVO corpInfo = null;
			CommonResponse<OrgVO> orgResp = orgApi.getOneById(entity.getCorpId());
			if(!orgResp.isSuccess()) {
				logger.error("查询供应商归属部门corpId-{}组织信息失败", entity.getCorpId());
			}
			corpInfo = orgResp.getData();
			if(null == corpInfo) {
				logger.error("查询供应商归属部门信息corpId-{}为空！", entity.getCorpId());
			} else {
				save.setCorpSid(corpInfo.getSourceId());
				save.setCorpName(corpInfo.getName());
				save.setCorpCode(corpInfo.getCode());
			}
		}

		save.setCorpErpName(entity.getCorpName());

		//保存供应商信息
		MatSupplierVO supplier = supplierService.saveOrUpdateSupInfo(save, false);

		// 附件处理
		attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(entity.getId()), sourceBillType, PlanConstant.BILL_SOURCE_TYPE,
				String.valueOf(supplier.getId()), targetBillType, PlanConstant.BILL_SOURCE_TYPE);

		Map<Long, MatLinkerVO> linkerMap = supplier.getLinkerList().stream().collect(Collectors.toMap(x->x.getSourceDetailId(), x->x));
		Map<Long, MatSupplierAttachesVO> attachMap = supplier.getAttachesList().stream().collect(Collectors.toMap(x->x.getSourceDetailId(), x->x));
		for(MatLinkerAccessEntity source : entity.getLinkerList()){
			if(linkerMap.containsKey(source.getId())){
				MatLinkerVO target = linkerMap.get(source.getId());
				String sourceType = source.getUserType() == 2 ? PlanConstant.AGENT_SOURCE_TYPE : PlanConstant.LEGAL_PERSON_SOURCE_TYPE;
				attachmentApi.copyFilesFromSourceBillToTargetBill(
						String.valueOf(source.getId()), sourceBillType, sourceType,
						String.valueOf(target.getId()), targetBillType, sourceType);
				attachmentApi.copyFilesFromSourceBillToTargetBill(
						String.valueOf(source.getId()), sourceBillType, PlanConstant.CERTIFY_SOURCE_TYPE,
						String.valueOf(target.getId()), targetBillType, PlanConstant.CERTIFY_SOURCE_TYPE);
			}
		}
		for(MatSupplierAccessAttachesEntity source : entity.getAttachesList()){
			if(attachMap.containsKey(source.getId())){
				MatSupplierAttachesVO target = attachMap.get(source.getId());
				attachmentApi.copyFilesFromSourceBillToTargetBill(
						String.valueOf(source.getId()), sourceBillType, PlanConstant.FILE_SOURCE_TYPE,
						String.valueOf(target.getId()), targetBillType, PlanConstant.FILE_SOURCE_TYPE);
			}
		}
		return supplier.getId();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不允许弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
		JSONArray resp = new JSONArray();
		//获取供应商公户信息中的物料分类Id列表
		List<MatSupplierAccessMaterialInfoEntity> msList = matSupplierAccessMaterialInfoService.getAllByAccessId(billId);
		List<Long> categoryIds = msList.stream().map(MatSupplierAccessMaterialInfoEntity::getMaterialId).collect(Collectors.toList());

		if(CollectionUtils.isEmpty(categoryIds)) {
			return CommonResponse.error("操作失败，供应商下供货内容的物资分类为空，无法获取到对应审核人信息！");
		}
		CommonResponse<List<MatSupplierManagerVO>> settingResp = izdsMatSupManagerApi.getAllByCategoryIds(categoryIds);
		if(!settingResp.isSuccess()) {
			logger.error("根据物料分类ids-{}获取对应审核人信息失败，{}", categoryIds, JSONObject.toJSONString(settingResp, SerializerFeature.PrettyFormat));
			return CommonResponse.error("获取供应商审核人信息失败！");
		}
		List<MatSupplierManagerVO> settingList = settingResp.getData();
		if(CollectionUtils.isNotEmpty(settingList)) {
			for(MatSupplierManagerVO m : settingList) {
				JSONObject obj = new JSONObject();
				obj.put("userId", m.getManagerId());
				obj.put("userName", m.getManagerName());
				resp.add(obj);
			}
		}

		if(resp.size() == 0) {
			return CommonResponse.error("操作失败，供应商下供货内容的物资分类未设置审核人信息！");
		}

		return CommonResponse.success(resp);
	}

}
