package com.ejianc.business.zdssupplier.material.service.impl;

import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeFlowEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierChangeFlowMapper;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeFlowService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeFlowVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 物资供应商变更-流水
 * 
 * @author generator
 * 
 */
@Service("matSupplierChangeFlowService")
public class MatSupplierChangeFlowServiceImpl extends BaseServiceImpl<MatSupplierChangeFlowMapper, MatSupplierChangeFlowEntity> implements IMatSupplierChangeFlowService{

    @Autowired
    private SessionManager sessionManager;

    @Override
    public MatSupplierChangeFlowVO saveOrUpdate(MatSupplierChangeFlowVO saveOrUpdateVO) {
        MatSupplierChangeFlowEntity entity = BeanMapper.map(saveOrUpdateVO, MatSupplierChangeFlowEntity.class);
        UserContext user = sessionManager.getUserContext();
        entity.setOperatorId(user.getUserId());
        entity.setOperatorCode(user.getUserCode());
        entity.setOperatorName(user.getUserName());
        entity.setOperatorPhone(user.getUserMobile());
        entity.setOperateTime(new Date());
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, MatSupplierChangeFlowVO.class);
    }

}
