package com.ejianc.business.zdssupplier.sub.controller.api;

import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/30 16:06
 */
@RestController
@RequestMapping(value = "/api/subLinkerApi")
public class SubLinkerApi {

    @Autowired
    private ILinkerService service;

    @Autowired
    private ISupplierService supplierService;

    /**
     * 同步准入数据
     *
     * @return
     */
    @PostMapping(value = "/getBySourceIds")
    public CommonResponse<List<LinkerVO>> getBySourceIds(@RequestBody List<String> sourceIds) {
        List<LinkerVO> vos = service.getBySourceIds(sourceIds);
        return CommonResponse.success("查询成功", vos);
    }

    /**
     * 根据移动电话查询人员
     * @param mobileLinkPhone
     * @return
     */
    @GetMapping(value = "/getByMobileLinkPhone")
    public CommonResponse<LinkerVO> getByMobileLinkPhone(String mobileLinkPhone) {
        LinkerVO vo = service.getByMobileLinkPhone(mobileLinkPhone);
        return CommonResponse.success("查询成功", vo);
    }

    /**
     * 分包联系人新增
     * @param linker
     * @return
     */
    @PostMapping(value = "/addLinker")
    public CommonResponse<LinkerVO> addLinker(@RequestBody LinkerVO linker) {
//        LinkerVO vo = service.addLinker(linker);
        LinkerVO vo = service.saveOrUpdate(linker);
        if (vo != null){
            return CommonResponse.success("新增成功！", vo);
        }
        return CommonResponse.error("新增失败！");
    }


    /**
     * 根据供应商联系人供方用户Id查询对用联系人信息
     * @param supUserId
     * @param tenantId
     * @return
     */
    @GetMapping(value = "/getSupUserIdAndTenant")
    public CommonResponse<LinkerVO> getSupUserIdAndTenant(@RequestParam Long supUserId, @RequestParam Long tenantId) {
        LinkerVO linker = service.getSupUserIdAndTenant(supUserId, tenantId);
        return CommonResponse.success("查询成功！", linker);
    }

    /**
     * 根据联系人Id，获取联系人信息
     * @param id
     * @return
     */
    @GetMapping(value = "/getOneById")
    CommonResponse<LinkerVO> getOneById(@RequestParam("id") Long id) {
        LinkerEntity entity = service.getById(id);
        if(null == entity) {
            return CommonResponse.success(null);
        }
        return CommonResponse.success(BeanMapper.map(entity, LinkerVO.class));
    }

    @GetMapping(value = "/getBySupUserId")
    CommonResponse<LinkerVO> getBySupUserId(@RequestParam("supUserId") Long supUserId, @RequestParam("supplierId") Long supplierId) {
        LinkerVO resp = service.getBySupUserId(supUserId, supplierId);
        return CommonResponse.success(resp);
    }

}
