package com.ejianc.business.zdssupplier.sub.service;

import com.ejianc.business.zdssupplier.sub.vo.LinkerAccessVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zdssupplier.sub.bean.LinkerAccessEntity;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 分包联系人准入
 * 
 * @author generator
 * 
 */
public interface ILinkerAccessService extends IBaseService<LinkerAccessEntity> {

    LinkerAccessVO saveOrUpdate(LinkerAccessVO saveOrUpdateVO);
    /**
     * 接收单据
     *
     * @param request 单据信息
     * @return 保存结果
     */
    Long saveSyncBill(HttpServletRequest request);

    /**
     * 校验手机号唯一性
     * @param linker
     * @return
     */
    Boolean validateUnique(LinkerAccessEntity linker, Long id);

    /**
     * 校验手机号唯一性
     * @return
     */
    Boolean validateUnique(List<LinkerAccessEntity> linkerList);

    /**
     * 根据邀请链接重新拉取分供方准入信息
     * @param inviteId
     * @return
     */
    LinkerAccessVO syncDetailBill(Long inviteId);
}
