package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.bean.PushErpRecordsEntity;
import com.ejianc.business.zds.archive.bean.SubTypeManagerEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zds.archive.service.IPushErpRecordsService;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.BankCategoryVO;
import com.ejianc.business.zds.archive.vo.BankVO;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdssupplier.common.service.ISupplierSyncErpService;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.common.utils.ParamUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpCompanyTypeEnums;
import com.ejianc.business.zdssupplier.cons.enums.ErpLinkerCardTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpTaxCreditLevelEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierBankEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.vo.SupplierSyncParam;
import com.ejianc.business.zdssupplier.sub.bean.*;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierMapper;
import com.ejianc.business.zdssupplier.sub.service.*;
import com.ejianc.business.zdssupplier.sub.vo.*;
import com.ejianc.business.zdssupplier.utils.ZDSReqUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IDeptApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IPostApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.orgcenter.vo.PostVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 分包供应商档案
 *
 * @author generator
 */
@Service("supplierService")
public class SupplierServiceImpl extends BaseServiceImpl<SupplierMapper, SupplierEntity> implements ISupplierService, ISupplierSyncErpService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER";//此处需要根据实际修改

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private CoordinationUtil coordinationUtil;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ILinkerService linkerService;

    @Autowired
    private IZDSSubTypeApi subTypeApi;

    @Autowired
    private IBankService bankService;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IPostApi postApi;

    @Autowired
    private IDeptApi deptApi;

    @Autowired
    private ISupplierChangeBankService supplierChangeBankService;

    @Autowired
    private ISupplierChangeCertificateService changeCertificateService;

    @Autowired
    private ISupplierChangeAttachesService changeAttachesService;

    @Autowired
    private ISupplierManagerChangeService managerChangeService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ISupplierAccessService supplierAccessService;

    @Autowired
    private IBankCategoryService bankCategoryService;

    @Autowired
    private ISubTypeManagerService subTypeManagerService;

    @Autowired
    private IPushErpRecordsService pushErpRecordsService;

    @Value("${spring.cloud.config.profile}")
    private String profile;

    private final static String ERP_SUB_SUPPLIER_UPDATE_URL = "/cefoc/yql/SubContractorList?OID=";

    @Override
    public SupplierVO saveOrUpdate(SupplierVO saveOrUpdateVO) {
        return saveOrUpdateSupInfo(saveOrUpdateVO, true);
    }


    @Override
    public SupplierVO saveOrUpdateSupInfo(SupplierVO saveOrUpdateVO, boolean cooFlag) {
        SupplierEntity entity = BeanMapper.map(saveOrUpdateVO, SupplierEntity.class);
        // 校验统一社会信用代码唯一性
        this.validateUnique(entity.getName(), entity.getSocialCreditCode(), entity.getId(), "生成");

        for(SupplierManagerEntity manager : entity.getManagerList()){
            if("del".equals(manager.getRowState()) && PlanConstant.STRING_YES.equals(manager.getCoordination())){
                throw new BusinessException("已生成协同账号的项目经理不能删除！");
            }
        }

        // 联系人校验
        linkerService.validateUnique(entity.getLinkerList());

        if(StringUtils.isEmpty(saveOrUpdateVO.getCode()) && (entity.getId() == null || entity.getId() == 0)){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        if(cooFlag) {
            if(!PlanConstant.STRING_YES.equals(entity.getCoordination())) {
                // 供应商未生成协同租户，则先创建协同租户
                this.createSupTenant(entity);
            }
            for(LinkerEntity linker : entity.getLinkerList()){
                if(PlanConstant.STRING_YES.equals(linker.getCoordination())) {
                    linkerService.createSupAccount(linker, entity.getTenant());
                }
            }
        }
        return BeanMapper.map(entity, SupplierVO.class);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void initCooInfo(Long supplierId) {
        SupplierEntity entity = super.selectById(supplierId);
        if(!PlanConstant.STRING_YES.equals(entity.getCoordination())) {
            // 供应商未生成协同租户，则先创建协同租户
            this.createSupTenant(entity);
        }
        for(LinkerEntity linker : entity.getLinkerList()){
            if(PlanConstant.STRING_YES.equals(linker.getCoordination())) {
                linkerService.createSupAccount(linker, entity.getTenant());
            }
        }
    }

    @Override
    public List<SupplierEntity> getAllByIds(List<Long> supplierIds) {
        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("id", supplierIds);

        return super.list(query);
    }

    @Override
    public CommonResponse<IPage<SupplierVO>> queryListBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        JSONObject jsonObject = JSONObject.parseObject(transData, JSONObject.class);
        QueryParam param = JSONObject.parseObject(jsonObject.getString("queryParam"), QueryParam.class);
        String tenantId = (String) jsonObject.get("tenantId");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        IPage<SupplierEntity> page = super.queryPage(param, false);
        IPage<SupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @Override
    public CommonResponse<SupplierEntity> queryDetailBill(HttpServletRequest request) {
        String transData = StringEscapeUtils.unescapeJava(request.getParameter("transData"));
        logger.info("接收到数据transData：{}", transData);
        JSONObject jsonObject = JSONObject.parseObject(transData, JSONObject.class);
        String tenant = jsonObject.getString("tenant");
        Long id = jsonObject.getLong("id");
        QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
        if(null != id){
            queryWrapper.eq("id", id);
        } else {
            queryWrapper.eq("tenant",tenant);
        }
        List<SupplierEntity> list = super.list(queryWrapper);
        if (list.size() == 0) {
            return CommonResponse.error("未查询到单据！");
        }
        SupplierEntity supplierEntity = list.get(0);
        SupplierEntity entity =  super.selectById(supplierEntity.getId());
//        SupplierVO vo = BeanMapper.map(entity, SupplierVO.class);
        return CommonResponse.success("查询详情数据成功！", entity);
    }

    @Override
    public TenantVO createSupTenant(SupplierEntity supplier) {
        Map<String, String> reqParam = new HashMap<>();
        reqParam.put("socialCreditCode", supplier.getSocialCreditCode());
        reqParam.put("supplierType", PlanConstant.SUB_SUPPLIER);
        reqParam.put("supplierName", supplier.getName() + "-分包");
        reqParam.put("supplierId", supplier.getId().toString());

        // 供应商生成协同租户
        TenantVO vo = coordinationUtil.createSupTenant(reqParam);

        supplier.setCoordination(PlanConstant.STRING_YES);
        supplier.setTenant(vo.getId());
        supplier.setTenantName(vo.getName());
        supplier.setSystemId(vo.getEnterpriseId().toString());
        super.saveOrUpdate(supplier, false);
        return vo;
    }

    @Override
    public SupplierVO getByTenantId(Long supplierTenant) {
        SupplierVO resp = null;

        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.eq("tenant", supplierTenant);
        query.eq("dr", BaseVO.DR_UNDELETE);
        SupplierEntity e = super.getOne(query);

        if(null != e) {
            resp = BeanMapper.map(e, SupplierVO.class);
        }

        return resp;
    }

    @Override
    public List<SupplierEntity> getAllByThirdSourceIds(ArrayList thirdSourceIds) {
        QueryWrapper<SupplierEntity> query = new QueryWrapper<>();
        query.in("third_source_id", thirdSourceIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<SupplierEntity> resp = super.list(query);

        return resp;
    }

    @Override
    public Boolean validateUnique(String name, String socialCreditCode, Long id, String operate) {
        QueryParam param = new QueryParam();
        ComplexParam complexParam = ParamUtil.getOrParam("name", "socialCreditCode", name, socialCreditCode);
        param.getComplexParams().add(complexParam);
        if(id != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<SupplierEntity> supplierList = super.queryList(param);
        if(CollectionUtils.isNotEmpty(supplierList)){
            throw new BusinessException("该供应商的统一社会信用代码已生成档案【" + supplierList.get(0).getCode() + "】，不允许重复" + operate + "！");
        }
        return true;
    }

    @Override
    public String syncSupplierChangeToErp(SupplierSyncErpParamVO syncParam) {
        logger.info("推送分包供应商-{}至ERP   start*********", JSONObject.toJSONString(syncParam));
        String pushResult = null;
        Map<String, String> headers = null;
        PushErpRecordsEntity pushEntity = new PushErpRecordsEntity();
        pushEntity.setBillType(PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ? BillTypeEnum.分包供应商准入.getCode() :
                PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType()) ? BillTypeEnum.分包供应商变更.getCode() :
                        PlanConstant.联系人新增同步ERP.equals(syncParam.getSyncType()) ? BillTypeEnum.分包联系人准入.getCode() : BillTypeEnum.分包联系人变更.getCode());
        pushEntity.setPushTypeName(syncParam.getSyncType());
        pushEntity.setOperatorId(syncParam.getOperatorId());
        pushEntity.setOperatorName(syncParam.getOperatorName());
        pushEntity.setPushDate(new Date());

        SupplierSyncParam syncSupParam = new SupplierSyncParam();

        try {
            List<SupSubDelParamVO> delList = new ArrayList<>();
            String syncUrl = PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ? PlanConstant.分包供应商新增同步ERP地址 : PlanConstant.分包供应商变更同步ERP地址;
            SupplierEntity entity =super.selectById(syncParam.getSupplierId());
            syncSupParam.setSupplierId(entity.getId());

            JSONObject supJson = null;
            if(!PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType())) {
                //查询供应商变更前 分包商ERP数据 并记录
                supJson = getSupErpInfo(syncParam.getSupplierId());
                if(null == supJson && !"ok".equals(supJson.get("status"))) {
                    logger.error("中电四 分包商id-{}推送ERP失败, 从ERP接口获取该分包商最新信息失败!", syncParam.getSupplierId());
                    pushResult = "操作失败，从ERP接口获取当前分包商最新信息失败！";
                    pushEntity.setSucFlag(PlanConstant.STRING_NO);
                    pushEntity.setPushResult("分包商【id-"+syncParam.getSupplierId().toString()+"】推送,从ERP接口获取分包商最新信息失败！");

                    //存储推送记录
                    sendMq(SupplierSyncParam.PUSH_ERP_RECORD_QUEUE+"_"+profile, JSONObject.toJSONString(pushEntity));
                    return pushResult;
                }

                //查询成功，记录当前分包商在ERP中最新信息
                pushEntity.setBeforePushSupInfo(supJson.toJSONString());
            }

            //推送ERP分包商数据组装
            JSONArray syncData = transferToErpParam(entity, syncParam, delList, supJson);

            //推送数据地址记录
            pushEntity.setUrl(ZdsReqUtil.getErpReqHost()+ syncUrl);
            //推送数据记录
            pushEntity.setData(JSONObject.toJSONString(syncData));

            headers = ZdsReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson(ZdsReqUtil.getErpReqHost()+ syncUrl, JSONObject.toJSONString(syncData),
                    headers, ZdsReqUtil.CONN_TIME_OUT, ZdsReqUtil.READ_TIME_OUT);

            logger.info("分包商推送ERP：url-{}, 参数：{}，结果：{}", ZdsReqUtil.getErpReqHost()+ syncUrl,
                    JSONObject.toJSONString(syncData, SerializerFeature.PrettyFormat), reqResp);

            JSONObject reqJson = JSONObject.parseObject(reqResp);
            pushEntity.setErpResult(reqJson.toJSONString());

            if("true".equals(reqJson.getString("status"))) {
                logger.info("中电四 分包商id-{}推送ERP成功!", syncParam.getSupplierId());
                pushEntity.setSucFlag(PlanConstant.STRING_YES);
                pushEntity.setPushResult("分包商【id-"+syncParam.getSupplierId().toString()+"】推送ERP成功！");
            } else {
                logger.error("中电四 分包商id-{}推送ERP失败!", syncParam.getSupplierId());
                pushResult = "操作失败，分包商数据推送ERP处理失败！";
                pushEntity.setSucFlag(PlanConstant.STRING_NO);
                pushEntity.setPushResult("分包商【id-"+syncParam.getSupplierId().toString()+"】推送,ERP处理失败！");
            }

        } catch (Exception e) {
            logger.error("推送分包商id-{}异常，", syncParam.getSupplierId(), e);
            pushEntity.setErpResult("推送异常");
            pushEntity.setSucFlag(PlanConstant.STRING_NO);
            pushResult = "操作失败，分包商推送ERP数据转换失败！";
            pushEntity.setPushResult("分包商【id-"+syncParam.getSupplierId().toString()+"】推送，数据转换失败！");
        }

        //记录推送数据
//        pushErpRecordsService.saveOrUpdate(pushEntity, false);
        syncSupParam.setHandleServiceName("supplierService");

        //存储推送记录
        sendMq(SupplierSyncParam.PUSH_ERP_RECORD_QUEUE+"_"+profile, JSONObject.toJSONString(pushEntity));

        //放入更新队列
        if(PlanConstant.STRING_YES.equals(pushEntity.getSucFlag())) {
            sendMq(SupplierSyncParam.ERP_SUPPLIER_UPD_QUEUE+"_"+profile, JSONObject.toJSONString(syncSupParam));
        }

        logger.info("推送分包商id-{}至ERP   end*********", syncParam.getSupplierId());
        return pushResult;
    }

    @Override
    public JSONArray getSupplierApprList(Long supplierId) {
        JSONArray resp = new JSONArray();
        SupplierEntity supplier = super.selectById(supplierId);

        if(StringUtils.isBlank(supplier.getProfessionId()) && StringUtils.isBlank(supplier.getDepProfessionId()) &&
                StringUtils.isBlank(supplier.getDepProfessionSid())) {
            throw new BusinessException("操作失败，该分包商的发展专业和主导专业都为空，无法获取到对应审核人信息！");
        }

        //根据专业类型 查询主导专业对应的审核人
        if(StringUtils.isNotBlank(supplier.getDepProfessionId())) {
            List<SubTypeManagerEntity> mangers = subTypeManagerService.getAllBySubTypeIds(Arrays.stream(supplier.getDepProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(mangers)) {
                mangers.stream().forEach(item -> {
                    JSONObject obj = new JSONObject();
                    obj.put("userId", item.getManagerId());
                    obj.put("userName", item.getManagerName());
                    resp.add(obj);
                });
            }
        } else if(StringUtils.isNotBlank(supplier.getDepProfessionSid())) {
            List<SubTypeManagerEntity> mangers = subTypeManagerService.getAllBySubTypeSids(Arrays.stream(supplier.getDepProfessionSid().split(",")).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(mangers)) {
                mangers.stream().forEach(item -> {
                    JSONObject obj = new JSONObject();
                    obj.put("userId", item.getManagerId());
                    obj.put("userName", item.getManagerName());
                    resp.add(obj);
                });
            }
        }

        //若主导专业审核人为空，则获取发展专业对应审核人
        if(resp.size() == 0 && StringUtils.isNotBlank(supplier.getProfessionId())) {
            List<SubTypeManagerEntity> mangers = subTypeManagerService.getAllBySubTypeIds(Arrays.stream(supplier.getProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(mangers)) {
                mangers.stream().forEach(item -> {
                    JSONObject obj = new JSONObject();
                    obj.put("userId", item.getManagerId());
                    obj.put("userName", item.getManagerName());
                    resp.add(obj);
                });
            }
        }
        return resp;
    }

    private JSONArray transferToErpParam(SupplierEntity entity, SupplierSyncErpParamVO syncParam,
                                         List<SupSubDelParamVO> delList, JSONObject supErpJson) {
        JSONArray resp = new JSONArray();
        JSONObject data = new JSONObject();
        resp.add(data);

        JSONObject supplierJson = new JSONObject();
        if(null != supErpJson && supErpJson.getJSONArray("SubContractorInfo").size() > 0) {
            supplierJson = (JSONObject) supErpJson.getJSONArray("SubContractorInfo").get(0);
        }

        //查询专业类型
        List<SubTypeVO> depSubTypes = new ArrayList<>();
        if(StringUtils.isNotBlank(entity.getDepProfessionId())) {
            CommonResponse<List<SubTypeVO>> subTypeResp = subTypeApi.getAllByIds(Arrays.stream(entity.getDepProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            if(!subTypeResp.isSuccess()) {
                logger.error("分包商变更信息推送ERP失败，查询主键为：{}的分包类型失败: {}", entity.getDepProfessionId(), JSONObject.toJSONString(subTypeResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("分包商变更信息推送ERP失败, 获取专业类型信息失败！");
            }
            depSubTypes = subTypeResp.getData();
            if(CollectionUtils.isEmpty(depSubTypes)) {
                logger.error("分包商变更信息推送ERP失败，不存在主键为：{}的分包类型", entity.getDepProfessionId());
                throw new BusinessException("分包商变更信息推送ERP失败, 不存在匹配的专业类型！");
            }
        }

        //查询供应商录入人信息
        EmployeeVO creator = null;
        if(StringUtils.isNotBlank(entity.getErpCreatorSid())) {
            CommonResponse<EmployeeVO> creatorRes = employeeApi.getOneBySourceId(entity.getErpCreatorSid());
            if(!creatorRes.isSuccess()) {
                logger.error("物资供应商同步ERP失败,查询供应商录入人sid-{}信息失败！", JSONObject.toJSONString(entity.getErpCreatorSid()), JSONObject.toJSONString(creatorRes));
//                throw new BusinessException("物资供应商同步ERP失败,查询供应商录入人信息失败！");
            }
            creator = creatorRes.getData();
            if(null == creator) {
                logger.error("物资供应商同步ERP失败,查询供应商录入人sid-{}信息为空！", entity.getErpCreatorSid());
//                throw new BusinessException("物资供应商同步ERP失败,查询供应商录入人信息为空！");
            }
        }


        String corpSid = entity.getCorpSid();
        if(StringUtils.isBlank(corpSid) && null != entity.getCorpId()) {
            //查询供应商所属部门细心
            CommonResponse<OrgVO> orgResp = orgApi.getOneById(entity.getCorpId());
            if(!orgResp.isSuccess()) {
                logger.error("分包商同步ERP失败,查询供应商归属部门id-{}信息失败！", entity.getCorpId(), JSONObject.toJSONString(orgResp));
            }
            if(null == orgResp.getData()) {
                logger.error("分包商同步ERP失败,查询供应商归属部门id-{}信息为空！", entity.getCorpId(), JSONObject.toJSONString(orgResp));
            } else {
                corpSid = orgResp.getData().getSourceId();
            }
        }

        data.put("YQL_SID", StringUtils.isBlank(entity.getThirdSourceId()) ? entity.getId() : entity.getThirdSourceId()); //EL平台主键
        data.put("CON_EMP_NUM", null != creator ? creator.getCode() : null);//录入人工号
        if(null != creator || StringUtils.isNotBlank(entity.getErpRegisterName())) {
            data.put("Register_Name", null != creator ? creator.getName() : entity.getErpRegisterName());//录入人工号
        }
        data.put("Company_Name", entity.getName()); //供应商名称
        data.put("Taxcreditrating", StringUtils.isNotBlank(ErpTaxCreditLevelEnum.getByName(entity.getTaxCreditLevel())) ?
                ErpTaxCreditLevelEnum.getByName(entity.getTaxCreditLevel()) : ""); //纳税信用等级
        data.put("OwnerDept", StringUtils.isNotBlank(entity.getCorpErpName()) ? entity.getCorpErpName() : StringUtils.isNotBlank(entity.getCorpName()) ?
                entity.getCorpName() : ""); //归属部门
        data.put("OwnerDeptSid", StringUtils.isNotBlank(corpSid) ? corpSid : PlanConstant.ERP空值); //归属部门SID
        data.put("CompanyStyle", ErpCompanyTypeEnums.fuzzyMatchByName(entity.getCompanyType().contains("(") ?
                entity.getCompanyType().substring(0, entity.getCompanyType().indexOf("(")) : entity.getCompanyType())); //公司类型
        data.put("Company_LegalPerson", entity.getLegalPerson()); //法人
        data.put("RegistrationCode", entity.getSocialCreditCode()); //统一社会信用代码
        data.put("regStatus", entity.getBusinessStatus()); //经营状态
        data.put("Paidincapital", handleMnyStr(entity.getPaidCapitalStr())); //实缴资本
        data.put("RegistrationCapital", handleMnyStr(entity.getRegisteredCapitalStr())); //注册资本
        data.put("Company_Address", entity.getRegisteredAddress()); //注册地址
        data.put("CompanyStatus", entity.getCompanyState()); //公司状态
        data.put("OperatingPeriodStart", null != entity.getBusinessStatus() ?
                DateFormatUtil.formatDate("yyyy-MM-dd", entity.getBusinessStartDate()) : ""); //经营开始时间
        data.put("OperatingPeriodEnd", null != entity.getBusinessEndDate() ?
                DateFormatUtil.formatDate("yyyy-MM-dd", entity.getBusinessEndDate()) : ""); //经营结束时间
        data.put("OperatingRange", entity.getBusinessScope()); //经营范围
        data.put("ServiceArea", entity.getIntentName()); //意向区域
        data.put("CompanyType", entity.getDepProfessionName()); //发展专业(产品类型）
        data.put("CompanyType_Sid", CollectionUtils.isNotEmpty(depSubTypes) ?
                depSubTypes.stream().map(SubTypeVO::getSourceId).collect(Collectors.joining(",")) : entity.getDepProfessionSid()); //发展专业(产品类型）SID
        data.put("TotalStaff", entity.getLaborServNums()); //劳务人数总量
        data.put("MaxLimitConMoney", null != entity.getMaxContractOnTimeMny() ? entity.getMaxContractOnTimeMny().toPlainString() : ""); //同时最大承接合同额(万)
        data.put("AnnualMaxVertragsbetrag", null != entity.getMaxContractOnYearMny() ? entity.getMaxContractOnYearMny().toPlainString() : ""); //年度最大承接合同额
        data.put("IsitaOneTimeUse", entity.getDisposableState()); //是否一次使用
        data.put("ReasonforOneTimeUse", entity.getDisposableReason()); //一次性使用原因
        data.put("TypeLabel", entity.getTypeLabel()); //企业类型，ERP值域：0-劳务公司，1-工程公司，11-材料公司，16-其它
        data.put("IsSupportES", entity.getSealState()); //是否支持电子签章
        data.put("Memo", entity.getMemo()); //备注
        data.put("EntryDept", StringUtils.isNotBlank(entity.getType()) ? PlanConstant.ERP_SUB_INFO_TYPE_MAPPING.get(entity.getType()) : StringUtils.isNotBlank(entity.getErpType()) ? entity.getErpType()
                 : null); //信息来源
        data.put("RelatedCompany", StringUtils.isNotBlank(entity.getAffiliatedCompanyName()) ? entity.getAffiliatedCompanyName() : "");
        data.put("RelatedCompanySid", StringUtils.isNotBlank(entity.getAffiliatedCompanySid()) ? entity.getAffiliatedCompanySid() : "");

        if(StringUtils.isNotBlank(entity.getAffiliatedCompany()) && StringUtils.isBlank(entity.getAffiliatedCompanySid())) {
            logger.error("分包商id-{}同步ERP失败,查询供应商关联公司信息为空！", entity.getId());
            throw new BusinessException("分包商同步ERP失败,查询供应商关联公司信息为空！");
        }

        data.put("RelatedCompanySid", StringUtils.isNotBlank(entity.getAffiliatedCompanySid()) ? entity.getAffiliatedCompanySid() : PlanConstant.ERP空值);
        data.put("C_PS_MESupplierInfoOID", entity.getThirdSourceId()); //ERP主键
        data.put("Ma_id", entity.getCode()); //供应商编码


        //基础信息特殊处理
        supplierInfoBaseFill(data, supplierJson);

        //供应商联系人
        JSONArray linkerArr = new JSONArray();
        data.put("ContactList", linkerArr);
        handleSubSupLinker(linkerArr, entity.getLinkerList(), syncParam,
                data.getString("C_PS_MESupplierInfoOID"), creator, supplierJson.getJSONArray("ContactList"));

        //供应商项目经理
        JSONArray projectManagerArr = new JSONArray();
        data.put("ProjectManagerList", projectManagerArr);
        handleSubSupProjectManager(projectManagerArr, entity.getManagerList(),
                syncParam, creator, entity, delList, supplierJson.getJSONArray("ProjectManagerList"));

        //供应商银行
        JSONArray bankListArr = new JSONArray();
        data.put("BankList", bankListArr);
        handleSubSupBank(bankListArr, entity.getBankList(), syncParam,
                data.getString("C_PS_MESupplierInfoOID"), entity, delList, supplierJson.getJSONArray("BankList"));

        //供应商附件
        JSONArray archiveArr = new JSONArray();
        data.put("ArchiveList", archiveArr);
        handleSubSupArchive(archiveArr, entity.getAttachesList(),
                syncParam, data.getString("C_PS_MESupplierInfoOID"), entity, delList);

        //供应商资质信息
        JSONArray certArr = new JSONArray();
        data.put("QualificationInfoList", certArr);
        handleSubSupCert(certArr, entity.getCertificateList(),
                syncParam, data.getString("C_PS_MESupplierInfoOID"), entity, delList, supplierJson.getJSONArray("QualificationInfoList"));

        return resp;
    }

    private void supplierInfoBaseFill(JSONObject data, JSONObject supplierJson) {
        if(StringUtils.isBlank(data.getString("OwnerDept")) && StringUtils.isNotBlank(supplierJson.getString("OwnerDept"))) {
            data.put("OwnerDept", supplierJson.getString("OwnerDept"));
        }
        if(StringUtils.isBlank(data.getString("OwnerDeptSid")) && StringUtils.isNotBlank(supplierJson.getString("OwnerDeptSid"))) {
            data.put("OwnerDeptSid", supplierJson.getString("OwnerDept"));
        }
        if(StringUtils.isBlank(data.getString("CompanyType")) && StringUtils.isNotBlank(supplierJson.getString("CompanyType"))) {
            data.put("CompanyType", supplierJson.getString("CompanyType")); //发展专业(产品类型）
        }
        if(StringUtils.isBlank(data.getString("CompanyType_Sid")) && StringUtils.isNotBlank(supplierJson.getString("CompanyType_Sid"))) {
            data.put("CompanyType_Sid", supplierJson.getString("CompanyType_Sid")); //发展专业(产品类型）
        }
        if(StringUtils.isBlank(data.getString("CompanyStyle")) && StringUtils.isNotBlank(supplierJson.getString("CompanyStyle"))) {
            data.put("CompanyStyle", supplierJson.getString("CompanyStyle"));
        }
        if(StringUtils.isBlank(data.getString("Taxcreditrating")) && StringUtils.isNotBlank(supplierJson.getString("Taxcreditrating"))) {
            data.put("Taxcreditrating", supplierJson.getString("Taxcreditrating"));
        }
        if(StringUtils.isBlank(data.getString("EntryDept")) && StringUtils.isNotBlank(supplierJson.getString("EntryDept"))) {
            data.put("EntryDept", supplierJson.getString("EntryDept"));
        }
        if(StringUtils.isBlank(data.getString("ServiceArea")) && StringUtils.isNotBlank(supplierJson.getString("ServiceArea"))) {
            data.put("ServiceArea", supplierJson.getString("ServiceArea"));
        }

    }

    private String handleMnyStr(String mnyStr) {
        if(StringUtils.isBlank(mnyStr)) {
            return "-";
        }
        mnyStr = mnyStr.replaceAll("亿", "00000000");
        mnyStr = mnyStr.replaceAll("千万", "0000000");
        mnyStr = mnyStr.replaceAll("万", "0000");
        mnyStr = mnyStr.replaceAll("千", "000");
        mnyStr = mnyStr.replaceAll("百", "00");
        mnyStr = mnyStr.replaceAll("十", "0");
        mnyStr = mnyStr.replaceAll("人民币", "");
        return mnyStr;
    }

    private void handleSubSupCert(JSONArray certArr, List<SupplierCertificateEntity> certificateList,
                                  SupplierSyncErpParamVO syncParam, String supplierSid, SupplierEntity supplier,
                                  List<SupSubDelParamVO> delList, JSONArray erpCertArr) {
        if(PlanConstant.联系人新增同步ERP.equals(syncParam.getSyncType()) || PlanConstant.联系人变更同步ERP.equals(syncParam.getSyncType())) {
            //联系人变更、准入不会调整供应商附件信息，故不做同步
            return;
        } else if(PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType())) {
            //查询到本次供应商变更删除的项
            List<SupplierChangeCertificateVO> changeDelList = changeCertificateService.getDeledRecord(syncParam.getChangeId());
            logger.info("删除项：{}", changeDelList);
//            if(CollectionUtils.isNotEmpty(changeDelList)) {
//                certificateList.addAll(BeanMapper.mapList(changeDelList.stream().map(item -> {
//                    item.setId(item.getSourceDetailId());
//                    return item;
//                }).collect(Collectors.toList()), SupplierCertificateEntity.class));
//            }
        }

        JSONObject certJson = null;
        Map<String, JSONObject> erpCertMap = new HashMap<>();
        if(null != erpCertArr && erpCertArr.size() > 0) {
            for(Object obj : erpCertArr) {
                certJson = (JSONObject) obj;
                erpCertMap.put(certJson.getString("C_PS_QualificationInfoOID"), certJson);
            }
        }

        if(CollectionUtils.isNotEmpty(certificateList)) {
            List<Long> docDetailIds = certificateList.stream().map(SupplierCertificateEntity::getCertificateTypeId).collect(Collectors.toList());
            CommonResponse<List<DefdocDetailVO>> docDetailResp = defdocApi.queryDetailListByDetailIds(docDetailIds);
            if(!docDetailResp.isSuccess()) {
                logger.error("分包商同步ERP失败，根据资质档案Id列表-{}获取档案详情失败，", JSONObject.toJSONString(docDetailIds, SerializerFeature.PrettyFormat),
                        JSONObject.toJSONString(docDetailResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("查询资质等级档案信息失败！");
            }
            Map<Long, DefdocDetailVO> docDetailMap = new HashMap<>();
            if(CollectionUtils.isEmpty(docDetailResp.getData())) {
                logger.error("分包商同步ERP失败，根据资质档案Id列表-{}获取档案详情为空，", JSONObject.toJSONString(docDetailIds, SerializerFeature.PrettyFormat),
                        JSONObject.toJSONString(docDetailResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("查询资质等级档案信息为空！");
            }
            docDetailMap.putAll(docDetailResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));

            DefdocDetailVO tmpDocDetail = null;
            for (SupplierCertificateEntity cert : certificateList) {
                logger.info("资质项：{}", JSONObject.toJSONString(cert, SerializerFeature.PrettyFormat));

                tmpDocDetail = docDetailMap.get(cert.getCertificateTypeId());
                if(null == tmpDocDetail) {
                    logger.error("分包商id-{}同步ERP失败，不存在资质档案Id-{}匹配的档案详情", cert.getSupplierId(), cert.getCertificateTypeId());
                    throw new BusinessException("分包商同步ERP失败，供应商资质登记信息与资质档案不匹配！");
                }
                certJson = new JSONObject();
                certJson.put("C_PS_QualificationInfoOID", cert.getThirdSourceId()); //ERP主键
                certJson.put("LQualificationcateGoryandevel", cert.getCertificateTypeName()); //资质类别及等级name
                certJson.put("CertificateNumber", cert.getCertificateNumber()); //证书编号
                certJson.put("C_PS_SubContractorInfo_FK", supplierSid); //分包商sid
                certJson.put("LQualificationcateGoryandevelsid", tmpDocDetail.getCode()); //资质等级sid
                certJson.put("Validityperiod", null != cert.getPeriodOfValidity() ?
                        DateFormatUtil.formatDate("yyyy-MM-dd", cert.getPeriodOfValidity()) : ""); //有效期
                certJson.put("YQL_SID", StringUtils.isBlank(cert.getThirdSourceId()) ? cert.getId() : cert.getThirdSourceId()); //EL主键
                certJson.put("Main_FK", supplierSid); //供应商SID
                certJson.put("Source", Integer.valueOf(2).equals(cert.getSourceType()) ? "天眼查核增" : ""); //资质信息来源：来源于天眼查的传 天眼查核增，其他的来源传空
                certJson.put("Is_Add_Del", PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ? PlanConstant.信息新增 : BaseVO.DR_DELETED.equals(cert.getDr()) ? PlanConstant.信息删除 : null != cert.getSourceDetailId() ? PlanConstant.信息修订 : PlanConstant.信息新增); //同步操作状态

                if(erpCertMap.containsKey(cert.getThirdSourceId())) {
                    fillCertInfo(certJson, erpCertMap.get(cert.getThirdSourceId()));
                }

                certArr.add(certJson);
            }
        }
    }

    private void fillCertInfo(JSONObject certJson, JSONObject erpCertJson) {
        if(StringUtils.isBlank(certJson.getString("LQualificationcateGoryandevel")) && StringUtils.isNotBlank(erpCertJson.getString("LQualificationcateGoryandevel"))) {
            certJson.put("LQualificationcateGoryandevel", erpCertJson.getString("LQualificationcateGoryandevel"));
        }
        if(StringUtils.isBlank(certJson.getString("LQualificationcateGoryandevelsid")) && StringUtils.isNotBlank(erpCertJson.getString("LQualificationcateGoryandevelsid"))) {
            certJson.put("LQualificationcateGoryandevelsid", erpCertJson.getString("LQualificationcateGoryandevelsid"));
        }
        if(StringUtils.isBlank(certJson.getString("CertificateNumber")) && StringUtils.isNotBlank(erpCertJson.getString("CertificateNumber"))) {
            certJson.put("CertificateNumber", erpCertJson.getString("CertificateNumber"));
        }
    }

    private void handleSubSupArchive(JSONArray archiveArr, List<SupplierAttachesEntity> attachesList,
                                     SupplierSyncErpParamVO syncParam, String supplierSid, SupplierEntity supplier,
                                     List<SupSubDelParamVO> delList) {

        if(PlanConstant.联系人新增同步ERP.equals(syncParam.getSyncType()) || PlanConstant.联系人变更同步ERP.equals(syncParam.getSyncType())) {
            //联系人变更、准入不会调整供应商附件信息，故不做同步
            return;
        } else if(PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType())) {
            //查询到本次供应商变更删除的项
            List<SupplierChangeAttachesVO> changeDelList = changeAttachesService.getDeledRecord(syncParam.getChangeId());
            logger.info("删除项：{}", changeDelList);
//            if(CollectionUtils.isNotEmpty(changeDelList)) {
//                attachesList.addAll(BeanMapper.mapList(changeDelList.stream().map(item -> {
//                    item.setId(item.getSourceDetailId());
//                    return item;
//                }).collect(Collectors.toList()), SupplierAttachesEntity.class));
//            }
        }
        JSONObject archiveJson = null;

        if(CollectionUtils.isNotEmpty(attachesList)) {
            //查询附件信息
            JSONObject params = new JSONObject();
            List<Long> sourceIds = attachesList.stream().map(SupplierAttachesEntity::getFileId).collect(Collectors.toList());
            CommonResponse<List<AttachmentVO>> attachResp = attachmentApi.queryAllByIds(sourceIds);
            Map<Long, AttachmentVO> attachMap = new HashMap<>();
            if(!attachResp.isSuccess()) {
                logger.error("根据Id列表-{}查询对应附件信息失败，", JSONObject.toJSONString(sourceIds),
                        JSONObject.toJSONString(attachResp, SerializerFeature.PrettyFormat));
            } else if(CollectionUtils.isNotEmpty(attachResp.getData())) {
                attachMap.putAll(attachResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }

            AttachmentVO tmpAttach = null;
            for(SupplierAttachesEntity archive : attachesList) {
                logger.info("附件项：{}", JSONObject.toJSONString(archive, SerializerFeature.PrettyFormat));
                tmpAttach = attachMap.get(archive.getFileId());
                archiveJson = new JSONObject();
                if(null != tmpAttach) {
//                    archiveJson.put("C_PS_ArchivesOID", archive.getThirdSourceId());//ERP主键
                    archiveJson.put("Attach_Name", archive.getFileName()); //附件名称
                    archiveJson.put("Attach_Extension", archive.getFileName().indexOf(".") > 0 ?
                            archive.getFileName().substring(archive.getFileName().lastIndexOf(".")) :
                            tmpAttach.getFileName().substring(tmpAttach.getFileName().lastIndexOf("."))); //附件名称
                    archiveJson.put("Attach_Type", archive.getFileType()); //附件类型
                    archiveJson.put("AttachBase64", BASE_HOST + "filepreview/"+tmpAttach.getFilePath()); //附件url
                    archiveJson.put("YQL_SID", StringUtils.isNotBlank(archive.getThirdSourceId()) ? archive.getThirdSourceId() : archive.getId()); //EL主键
                    archiveJson.put("Is_Add_Del", PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ? PlanConstant.信息新增 :
                            BaseVO.DR_DELETED.equals(archive.getDr()) ? PlanConstant.信息删除 : null != archive.getThirdSourceId() ? PlanConstant.信息修订 : PlanConstant.信息新增); //同步操作状态

                    archiveArr.add(archiveJson);
                } else if(StringUtils.isNotBlank(archive.getThirdSourceId())) {
                    //附件不存在责人为是删除态
//                    archiveJson.put("C_PS_ArchivesOID", archive.getThirdSourceId());//ERP主键
//                    archiveJson.put("Attach_Name", archive.getFileName()); //附件名称
//                    archiveJson.put("Attach_Extension", archive.getFileName().indexOf(".") > 0 ?
//                            archive.getFileName().substring(archive.getFileName().lastIndexOf(".")) : ""); //附件名称
//                    archiveJson.put("Attach_Type", archive.getFileType()); //附件类型
//                    archiveJson.put("YQL_SID", StringUtils.isNotBlank(archive.getThirdSourceId()) ? archive.getThirdSourceId() : archive.getId()); //EL主键
//                    archiveJson.put("Is_Add_Del", PlanConstant.信息删除); //同步操作状态
//                    archiveArr.add(archiveJson);
                }
            }
        }
    }

    private void handleSubSupBank(JSONArray bankListArr, List<SupplierBankEntity> bankList, SupplierSyncErpParamVO syncParam,
                                  String supplierSid, SupplierEntity supplier,
                                  List<SupSubDelParamVO> delList, JSONArray erpBankArr) {
        if(PlanConstant.联系人新增同步ERP.equals(syncParam.getSyncType()) || PlanConstant.联系人变更同步ERP.equals(syncParam.getSyncType())) {
            //联系人变更、准入不会调整供应商银行信息，故不做同步
            return;
        } else if(PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType())) {
            //查询到本次供应商变更删除的项
            List<SupplierChangeBankVO> changeDelList = supplierChangeBankService.getDeledRecord(syncParam.getChangeId());
            logger.info("删除项：{}", changeDelList);
//            if(CollectionUtils.isNotEmpty(changeDelList)) {
//                bankList.addAll(BeanMapper.mapList(changeDelList.stream().map(item -> {
//                    item.setId(item.getSourceDetailId());
//                    return item;
//                }).collect(Collectors.toList()), SupplierBankEntity.class));
//            }
        }
        JSONObject bankJson = null;
        Map<String,JSONObject> erpBankMap = new HashMap<>();
        if(null != erpBankArr && erpBankArr.size() > 0) {
            for(Object obj : erpBankArr) {
                bankJson = (JSONObject) obj;
                erpBankMap.put(bankJson.getString("C_PS_SubContractorInfo_SubBOID"), bankJson);
            }
        }

        if(CollectionUtils.isNotEmpty(bankList)) {
            List<BankVO> dbBankList= bankService.getAllByIds(bankList.stream().filter(item -> null != item.getBankId()).map(SupplierBankEntity::getBankId).collect(Collectors.toList()));
            Map<String, BankEntity> bankNameMap = bankService.getAllMapByNames(bankList.stream().map(SupplierBankEntity::getOpenBank).collect(Collectors.toList()));
            Map<Long, BankVO> bankMap = new HashMap<>();
            Map<Long, BankCategoryVO> bankCategoryMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(dbBankList)) {
                bankMap.putAll(dbBankList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
                List<BankCategoryVO> bankCategory = bankCategoryService.getAllByIds(dbBankList.stream().map(BankVO::getCategoryId).collect(Collectors.toList()));
                bankCategoryMap.putAll(bankCategory.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }

            BankVO tmpBank = null;
            BankCategoryVO tmpBankCategory = null;

            for(SupplierBankEntity bank : bankList) {
                logger.info("银行项：{}", JSONObject.toJSONString(bank, SerializerFeature.PrettyFormat));

                tmpBank = bankMap.get(bank.getBankId());
                if(null == tmpBank) {
                    tmpBank = bankNameMap.containsKey(bank.getOpenBank()) ? BeanMapper.map(bankNameMap.get(bank.getOpenBank()), BankVO.class) : null;
                }
                if(null == tmpBank) {
                    logger.error("分包商id-{}同步ERP失败，不存在主键为：{}的银行信息", bank.getSupplierId(), bank.getBankId());
                } else {
                    tmpBankCategory = bankCategoryMap.get(tmpBank.getCategoryId());
                }
                if(null == tmpBankCategory) {
                    logger.error("分包商id-{}同步ERP失败，不存在主键为：{}的银行分类信息", bank.getSupplierId(), JSONObject.toJSONString(bank, SerializerFeature.PrettyFormat));
                }
                bankJson = new JSONObject();
                bankJson.put("YQL_SID", StringUtils.isBlank(bank.getBankThirdSourceId()) ? bank.getId() : bank.getBankThirdSourceId()); //EL主键
                bankJson.put("AccountType", null != bank.getNumberType() ? (bank.getNumberType() - 1) + "" : ""); //账号类型
                bankJson.put("Contact_BankAccount", bank.getBankNumber()); //银行账号
                if(null != tmpBank) {
                    bankJson.put("SubBankName", tmpBank.getCategoryName()); //银行分类名称
                    bankJson.put("SubBankCode", tmpBank.getSubBankCode()); //银行代码
                    bankJson.put("Province", tmpBank.getProvinceName()); //省
                    bankJson.put("City", tmpBank.getCityName()); //市
                    bankJson.put("Contact_Bank", tmpBank.getName()); //开户行
                    bankJson.put("Contact_BankNumber", tmpBank.getCode()); //银行行号
                    bankJson.put("BranchSqe", tmpBank.getCode()); //具体支行序号
                    bankJson.put("Whlnam", tmpBank.getName()); //网点名称
                    bankJson.put("BankInfoOID", tmpBank.getSourceId()); //银行SID
                }
                if(null != tmpBankCategory) {
                    bankJson.put("BankType", tmpBankCategory.getCode()); //银行类型
                }
                bankJson.put("Memo", ""); //备注
                bankJson.put("C_PS_SubContractorInfo_FK", supplierSid); //供应商SID
                bankJson.put("Is_Add_Del", PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ? PlanConstant.信息新增 :
                        BaseVO.DR_DELETED.equals(bank.getDr()) ? PlanConstant.信息删除 : null != bank.getSourceDetailId() ? PlanConstant.信息修订 : PlanConstant.信息新增); //信息同步操作

                if(null == tmpBank && erpBankMap.containsKey(bank.getBankThirdSourceId())) {
                    fillBankInfo(bankJson, erpBankMap.get(bank.getBankThirdSourceId()));
                } else {
                    //数据不合法跳过
                    logger.info("分包商银行信息[{}]不合法，跳过推送ERP", JSONObject.toJSONString(bank));
                    continue;
                }

                bankListArr.add(bankJson);
            }
        }

    }

    private void fillBankInfo(JSONObject bankJson, JSONObject erpBank) {
        if(StringUtils.isBlank(bankJson.getString("SubBankName")) && StringUtils.isNotBlank(erpBank.getString("SubBankName"))) {
            bankJson.put("SubBankName", erpBank.getString("SubBankName"));
        }
        if(StringUtils.isBlank(bankJson.getString("SubBankCode")) && StringUtils.isNotBlank(erpBank.getString("SubBankCode"))) {
            bankJson.put("SubBankCode", erpBank.getString("SubBankCode"));
        }
        if(StringUtils.isBlank(bankJson.getString("Province")) && StringUtils.isNotBlank(erpBank.getString("Province"))) {
            bankJson.put("Province", erpBank.getString("Province"));
        }
        if(StringUtils.isBlank(bankJson.getString("City")) && StringUtils.isNotBlank(erpBank.getString("City"))) {
            bankJson.put("City", erpBank.getString("City"));
        }
        if(StringUtils.isBlank(bankJson.getString("Contact_Bank")) && StringUtils.isNotBlank(erpBank.getString("Contact_Bank"))) {
            bankJson.put("Contact_Bank", erpBank.getString("Contact_Bank"));
        }
        if(StringUtils.isBlank(bankJson.getString("Contact_BankNumber")) && StringUtils.isNotBlank(erpBank.getString("Contact_BankNumber"))) {
            bankJson.put("Contact_BankNumber", erpBank.getString("Contact_BankNumber"));
        }
        if(StringUtils.isBlank(bankJson.getString("BranchSqe")) && StringUtils.isNotBlank(erpBank.getString("BranchSqe"))) {
            bankJson.put("BranchSqe", erpBank.getString("BranchSqe"));
        }
        if(StringUtils.isBlank(bankJson.getString("Whlnam")) && StringUtils.isNotBlank(erpBank.getString("Whlnam"))) {
            bankJson.put("Whlnam", erpBank.getString("Whlnam"));
        }
        if(StringUtils.isNotBlank(erpBank.getString("BankInfoOID"))) {
            bankJson.put("BankInfoOID", erpBank.getString("BankInfoOID"));
        }
        if(StringUtils.isBlank(bankJson.getString("BankType")) && StringUtils.isNotBlank(erpBank.getString("BankType"))) {
            bankJson.put("BankType", erpBank.getString("BankType"));
        }
    }

    private void handleSubSupProjectManager(JSONArray projectManagerArr, List<SupplierManagerEntity> managerList,
                                            SupplierSyncErpParamVO syncParam, EmployeeVO curUser, SupplierEntity supplier,
                                            List<SupSubDelParamVO> delList, JSONArray erpManagerArr) {
//        if(!PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType())) {
//            //只有新增供应商/供应商变更时 同步，联系人准入、变更都不会调整项目经理
//            return;
//        }
        if(!PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) && !PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType()) ) {
            //只有新增供应商/供应商变更时 同步，联系人准入、变更都不会调整项目经理
            return;
        } else {
            //查询到本次供应商变更删除的项
            List<SupplierManagerChangeVO> changeDelList = managerChangeService.getDeledRecord(syncParam.getChangeId());
            logger.info("删除项：{}", changeDelList);
//            if(CollectionUtils.isNotEmpty(changeDelList)) {
//                managerList.addAll(BeanMapper.mapList(changeDelList.stream().map(item -> {
//                    item.setId(item.getSourceDetailId());
//                    return item;
//                }).collect(Collectors.toList()), SupplierManagerEntity.class));
//            }
        }
        JSONObject managerJson = null;
        Map<String, JSONObject> erpLinkerSourceMap = new HashMap<>();
        if(null != erpManagerArr && erpManagerArr.size() > 0) {
            for(Object obj : erpManagerArr) {
                managerJson = (JSONObject) obj;
                erpLinkerSourceMap.put(managerJson.getString("C_PS_ProjektleiterInfoOID"), managerJson);
            }
        }

        if(CollectionUtils.isNotEmpty(managerList)) {
            for(SupplierManagerEntity manager : managerList) {
                logger.info("项目经理项：{}", JSONObject.toJSONString(manager, SerializerFeature.PrettyFormat));

                managerJson = new JSONObject();
                managerJson.put("ContactStatus", null != manager.getProjectManagerStatus() ? manager.getProjectManagerStatus().toString() : null); //0正常、1禁用、2黑名单
                managerJson.put("IDCard", manager.getIdCardId()); //证件ID
                managerJson.put("IDType", ErpLinkerCardTypeEnum.getCodeByElCode(manager.getIdCardType()));//证件类型
                managerJson.put("ContactName", manager.getProjectManagerName()); //项目经理名称
                managerJson.put("Contact_Mobile", manager.getMobileLinkPhone()); //项目经理手机号
                managerJson.put("Contact_Telephone", manager.getLinkPhone()); //项目经理固定电话
                managerJson.put("Contact_Email", manager.getElectronicMail()); //项目经理邮箱
                managerJson.put("Contact_Address", manager.getAddress()); //项目经理通讯地址
                managerJson.put("YQL_SID", StringUtils.isBlank(manager.getThirdSourceId()) ? manager.getId() : manager.getThirdSourceId()); //EL主键
                managerJson.put("Is_Add_Del", PlanConstant.供应商新增同步ERP.equals(syncParam.getSyncType()) ? PlanConstant.信息新增 :
                        BaseVO.DR_DELETED.equals(manager.getDr()) ? PlanConstant.信息删除 : null != manager.getThirdSourceId() ? PlanConstant.信息修订 : PlanConstant.信息新增); //信息同步操作

                fillManagerInfo(managerJson, erpLinkerSourceMap.get(manager.getThirdSourceId()));

                projectManagerArr.add(managerJson);
            }
        }

    }

    private void fillManagerInfo(JSONObject managerJson, JSONObject managerErpJsono) {
        if(null != managerErpJsono) {
            if(StringUtils.isBlank(managerJson.getString("ContactStatus")) && StringUtils.isNotBlank(managerErpJsono.getString("ContactStatus"))) {
                managerJson.put("ContactStatus", managerErpJsono.getString("ContactStatus"));
            }
        }
    }

    private void handleSubSupLinker(JSONArray linkerArr, List<LinkerEntity> linkerList,
                                    SupplierSyncErpParamVO syncParam, String supplierSid, EmployeeVO curUser,
                                    JSONArray erpLinkerArr) {
        JSONObject linkerJson = null;
        List<LinkerEntity> handleData = linkerList;
        if(PlanConstant.供应商变更同步ERP.equals(syncParam.getSyncType())) {
            //供应商变更不调整联系人信息 故不同联系人
            return;
        } else if(PlanConstant.联系人新增同步ERP.equals(syncParam.getSyncType()) || PlanConstant.联系人变更同步ERP.equals(syncParam.getSyncType())) {
            //只同步本次新增/变更的联系人信息
            handleData = handleData.stream().filter(item -> item.getId().equals(syncParam.getLinkerId())).collect(Collectors.toList());
        }
        Map<String, JSONObject> erpLinkerSourceMap = new HashMap<>();
        if(null != erpLinkerArr && erpLinkerArr.size() > 0) {
            for(Object obj : erpLinkerArr) {
                linkerJson = (JSONObject) obj;
                erpLinkerSourceMap.put(linkerJson.getString("subA_oid"), linkerJson);
            }
        }

        if(CollectionUtils.isNotEmpty(handleData)) {
            for(LinkerEntity linker : handleData) {
                logger.info("联系人项：{}", JSONObject.toJSONString(linker, SerializerFeature.PrettyFormat));

                linkerJson = new JSONObject();
                linkerJson.put("YQL_SID", StringUtils.isBlank(linker.getThirdSourceId()) ? linker.getId() : linker.getThirdSourceId());//益企联数据唯一标识
                linkerJson.put("ContactState", null != linker.getLinkerStatus() ? linker.getLinkerStatus().toString() : null);//联系人任职状态,0正常、1禁用、2黑名单
                linkerJson.put("IDType", ErpLinkerCardTypeEnum.getCodeByElCode(linker.getIdCardType()));//证件类型
                linkerJson.put("IDCard", linker.getIdCardId());//证件ID
                linkerJson.put("Company_Contact", linker.getName());//联系人名称
                //ERP联系人类型: 法人为0，授权人为1  EL联系人类型：0:法定代表人、1:法定授权人
                linkerJson.put("AuthorFlag", null != linker.getUserType() ? Integer.valueOf(1).equals(linker.getUserType()) ? 0 : 1 : null);
                linkerJson.put("lable", linker.getLinkerMark());//联系人标签
                linkerJson.put("Contact_Mobile", linker.getMobileLinkPhone());//联系人手机号
                linkerJson.put("Contact_Email", linker.getElectronicMail());//联系人邮箱
                linkerJson.put("Contact_Address", linker.getAddress());//联系人通讯地址
                linkerJson.put("Contact_Telephone", linker.getLinkPhone());//联系人固定电话
                linkerJson.put("C_PS_SubContractorInfo_FK", supplierSid);//分包商SID

                fillSupLinkerInfo(linkerJson, erpLinkerSourceMap.get(linker.getThirdSourceId()));

                linkerArr.add(linkerJson);
            }
        }

    }

    private void fillSupLinkerInfo(JSONObject linkerJson, JSONObject erpLinkerJson) {
        if(null != erpLinkerJson) {
            if(StringUtils.isBlank(linkerJson.getString("ContactState")) && StringUtils.isNotBlank(erpLinkerJson.getString("ContactState"))) {
                linkerJson.put("ContactState", erpLinkerJson.getString("ContactState"));
            }
            if(StringUtils.isBlank(linkerJson.getString("AuthorFlag")) && StringUtils.isNotBlank(erpLinkerJson.getString("AuthorFlag"))) {
                linkerJson.put("AuthorFlag", erpLinkerJson.getString("AuthorFlag"));
            }
            if(StringUtils.isBlank(linkerJson.getString("lable")) && StringUtils.isNotBlank(erpLinkerJson.getString("lable"))) {
                linkerJson.put("lable", erpLinkerJson.getString("lable"));
            }
            if(StringUtils.isBlank(linkerJson.getString("ContactType")) && StringUtils.isNotBlank(erpLinkerJson.getString("ContactType"))) {
                linkerJson.put("ContactType", erpLinkerJson.getString("ContactType"));
            }
        }
    }

    @Override
    public String sendMq(String queueName, String body) {
        MqMessage mqMessage = new MqMessage();
//
        mqMessage.setBody(body);
        rabbitTemplate.convertAndSend(queueName, mqMessage);
        logger.info("MQ队列标识：{}", queueName);
        return "消息发送MQ队列成功！";
    }

    @Override
    public JSONObject getSupErpInfo(Long supplierId) {
        logger.info("查询分包商id-{}ERP信息", supplierId);
        SupplierEntity supplier = super.selectById(supplierId);
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_SUB_SUPPLIER_UPDATE_URL +
                (StringUtils.isBlank(supplier.getThirdSourceId()) ? supplier.getId() : supplier.getThirdSourceId());
        String reqResp = null;
        try {
            Map<String, Object> param = new HashMap<>();
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSReqUtil.CONN_TIME_OUT, ZDSReqUtil.READ_TIME_OUT);

            logger.error("请求中电四获取分包商结果返回成功：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param),
                    JSONObject.toJSONString(headers), reqResp);
            return JSONObject.parseObject(reqResp);
        } catch (Exception e) {
           logger.error("查询分包商ERP信息失败", e);
        }

        JSONObject resp = new JSONObject();
        resp.put("erpResult", reqResp);
        resp.put("status", "false");
        return resp;
    }

    @Override
    public void syncSupplierErpSid(Long supplierId) {
        SupplierSyncParam syncParam = new SupplierSyncParam();
        syncParam.setHandleServiceName("supplierService");
        syncParam.setSupplierId(supplierId);
        syncParam.setDelaySeconds(0);
        syncParam.setRetry(false);
        supplierSync(syncParam);
    }

    @Override
    public boolean supplierSync(SupplierSyncParam supplierSyncParam) {
        try {
            if(null != supplierSyncParam.getDelaySeconds() && supplierSyncParam.getDelaySeconds() > 0) {
                TimeUnit.SECONDS.sleep(supplierSyncParam.getDelaySeconds());
                logger.info("********************更新分包商：id-{}信息，{}s后开始执行********************", supplierSyncParam.getSupplierId(), supplierSyncParam.getDelaySeconds());
            }
        }  catch (InterruptedException e) {
            logger.error("更新分包商：id-{}信息延迟{}秒异常", supplierSyncParam.getSupplierId(), supplierSyncParam.getDelaySeconds(), e);
        }

        logger.info("********************更新分包商：id-{}信息开始********************", supplierSyncParam.getSupplierId());

        SupplierEntity supplier = super.selectById(supplierSyncParam.getSupplierId());

        Map<String, Object> param = new HashMap<>();
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_SUB_SUPPLIER_UPDATE_URL +
                (StringUtils.isBlank(supplier.getThirdSourceId()) ? supplier.getId() : supplier.getThirdSourceId());
        JSONObject reqJson = null;
        JSONArray pageData = null;

        Map<String, String> linkerMap = new HashMap<>();
        Map<String, String> bankMap = new HashMap<>();
        Map<String, String> managerMap = new HashMap<>();
        Map<String, String> attachMap = new HashMap<>();
        Map<String, String> certMap = new HashMap<>();

        SupplierSyncParam syncParam = new SupplierSyncParam();
        syncParam.setSupplierId(supplierSyncParam.getSupplierId());
        syncParam.setHandleServiceName("supplierService");
        String queueName = SupplierSyncParam.ERP_SUPPLIER_UPD_QUEUE+"_"+profile;

        try {
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSReqUtil.CONN_TIME_OUT, ZDSReqUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);

            if ("ok".equals(reqJson.getString("status"))) {
                logger.error("请求中电四获取分包商结果返回成功：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param),
                        JSONObject.toJSONString(headers), JSONObject.toJSONString(reqJson, SerializerFeature.PrettyFormat));

                boolean updateSucFlag = true;
                pageData = reqJson.getJSONArray("SubContractorInfo");
                if(pageData.size() == 0) {
                    logger.info("同步ERP分包商信息失败，根据分包商SID-{}查询ERP信息为空！");
                    if(!BooleanUtils.isFalse(supplierSyncParam.getRetry())) {
                        sendMq(queueName, JSONObject.toJSONString(supplierSyncParam));
                    }
                    return false;
                }
                JSONObject supplierJson = (JSONObject) pageData.get(0);
                String supplierSid = supplierJson.getString("C_PS_SubContractorInfoOID");
                if(StringUtil.isBlank(supplierSid)) {
                    logger.info("同步ERP分包商信息失败，ERP分包商SID为空:{}",JSONObject.toJSONString(pageData));
                    if(!BooleanUtils.isFalse(supplierSyncParam.getRetry())) {
                        sendMq(queueName, JSONObject.toJSONString(supplierSyncParam));
                    }
                    return false;
                }
                if(StringUtil.isNotBlank(supplierSid) && StringUtil.isBlank(supplier.getThirdSourceId())) {
                    supplier.setThirdSourceId(supplierSid);
                }

                //分包商联系人
                if(null != reqJson.get("ContactList") && reqJson.getJSONArray("ContactList").size() > 0) {
                    handleLinker(linkerMap, reqJson.getJSONArray("ContactList"));
                }
                if(CollectionUtils.isNotEmpty(supplier.getLinkerList())) {
                    for(LinkerEntity linker : supplier.getLinkerList()) {
                        if(StringUtil.isNotBlank(linker.getThirdSourceId())) {
                            continue;
                        }
                        if(linkerMap.containsKey(linker.getId().toString())) {
                            linker.setThirdSourceId(linkerMap.get(linker.getId().toString()));
                            logger.info("更新联系人id-{}， SID-{}",linker.getId(), linker.getThirdSourceId());
                        } else {
                            updateSucFlag = false;
                        }
                    }
                }
                if(!updateSucFlag) {
                    logger.info("分包商：id-{} 与ERP分包商联系人信息不匹配:{}",supplier.getId(),JSONObject.toJSONString(linkerMap, SerializerFeature.PrettyFormat));
                }

                updateSucFlag = true;
                //分包商附件信息
                if(null != reqJson.get("ArchivesList") && reqJson.getJSONArray("ArchivesList").size() > 0) {
                    handleArchive(attachMap, reqJson.getJSONArray("ArchivesList"));
                }
                if(CollectionUtils.isNotEmpty(supplier.getAttachesList())) {
                    for(SupplierAttachesEntity attach : supplier.getAttachesList()) {
                        if(null == attach.getFileId() || StringUtil.isNotBlank(attach.getThirdSourceId())) {
                            continue;
                        }
                        if(attachMap.containsKey(attach.getId().toString())) {
                            attach.setThirdSourceId(attachMap.get(attach.getId().toString()));
                            logger.info("更新附件id-{}， SID-{}",attach.getId(), attach.getThirdSourceId());
                        } else {
                            logger.error("*********分包商附件信息id-{}在ERP中无匹配信息*********", attach.getId());
                            updateSucFlag = false;
                        }
                    }
                }
                if(!updateSucFlag) {
                    logger.info("分包商：id-{} 与ERP分包商附件信息不匹配:{}",supplier.getId(),JSONObject.toJSONString(attachMap, SerializerFeature.PrettyFormat));
                }

                updateSucFlag = true;
                //分包商银行信息
                if(null != reqJson.get("BankList") && reqJson.getJSONArray("BankList").size() > 0) {
                    handleBank(bankMap, reqJson.getJSONArray("BankList"));
                }
                if(CollectionUtils.isNotEmpty(supplier.getBankList())) {
                    for(SupplierBankEntity bank : supplier.getBankList()) {
                        if(StringUtil.isNotBlank(bank.getBankThirdSourceId())) {
                            continue;
                        }
                        if(bankMap.containsKey(bank.getId().toString())) {
                            bank.setBankThirdSourceId(bankMap.get(bank.getId().toString()));
                            logger.info("更新银行id-{}， SID-{}",bank.getId(), bank.getBankThirdSourceId());
                        } else {
                            updateSucFlag = false;
                            logger.error("*********分包商项银行信息id-{}在ERP中无匹配信息*********", bank.getId());
                        }
                    }
                }
                if(!updateSucFlag) {
                    logger.info("****************分包商：id-{} ERP分包商银行信息不匹配:{}****************",supplier.getId(),JSONObject.toJSONString(bankMap, SerializerFeature.PrettyFormat));
                }

                updateSucFlag = true;
                //项目经理信息
                if(null != reqJson.get("ProjectManagerList") && reqJson.getJSONArray("ProjectManagerList").size() > 0) {
                    handleProjectManager(managerMap, reqJson.getJSONArray("ProjectManagerList"));
                }
                if(CollectionUtils.isNotEmpty(supplier.getManagerList())) {
                    for(SupplierManagerEntity manager : supplier.getManagerList()) {
                        if(StringUtil.isNotBlank(manager.getThirdSourceId())) {
                            continue;
                        }
                        if(managerMap.containsKey(manager.getId().toString())) {
                            manager.setThirdSourceId(managerMap.get(manager.getId().toString()));
                            logger.info("更新项目经理id-{}， SID-{}",manager.getId(), manager.getThirdSourceId());
                        } else {
                            updateSucFlag = false;
                            logger.error("*********分包商项目经理信息id-{}在ERP中无匹配信息*********", manager.getId());
                        }
                    }
                }
                if(!updateSucFlag) {
                    logger.info("****************分包商：id-{} 与ERP分包商项目经理信息不匹配:{}****************",supplier.getId(),JSONObject.toJSONString(managerMap, SerializerFeature.PrettyFormat));
                }

                updateSucFlag = true;
                //资质信息
                if(null != reqJson.get("QualificationInfoList") && reqJson.getJSONArray("QualificationInfoList").size() > 0) {
                    handleQualification(certMap, reqJson.getJSONArray("QualificationInfoList"));
                }
                if(CollectionUtils.isNotEmpty(supplier.getCertificateList())) {
                    for(SupplierCertificateEntity cert : supplier.getCertificateList()) {
                        if(StringUtil.isNotBlank(cert.getThirdSourceId())) {
                         continue;
                        }
                        if(certMap.containsKey(cert.getId().toString())) {
                            cert.setThirdSourceId(certMap.get(cert.getId().toString()));
                            logger.info("更新资质id-{}， SID-{}",cert.getId(), cert.getThirdSourceId());
                        } else {
                            updateSucFlag = false;
                            logger.error("*********分包商资质信息id-{}在ERP中无匹配信息*********", cert.getId());
                        }
                    }
                }

                if(!updateSucFlag) {
                    logger.info("****************分包商：id-{} 与ERP分包商资质信息不匹配:{}****************", supplier.getId(), JSONObject.toJSONString(certMap, SerializerFeature.PrettyFormat));
                }

                logger.info("更新分包商id-{}，name-{}ERP SID信息成功", supplier.getId(), supplier.getName());
                super.saveOrUpdate(supplier, false);

            } else {
                logger.error("请求中电四获取分包商结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                if(!BooleanUtils.isFalse(supplierSyncParam.getRetry())) {
                    sendMq(queueName, JSONObject.toJSONString(supplierSyncParam));
                }
            }

        } catch (Exception e) {
            logger.error("获取中电四分包商信息异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            if(!BooleanUtils.isFalse(supplierSyncParam.getRetry())) {
                sendMq(queueName, JSONObject.toJSONString(supplierSyncParam));
            }
        }

        logger.info("********************更新分包商信息结束********************");
        return false;
    }

    private void handleQualification(Map<String, String> certMap, JSONArray qualificationInfoList) {
        logger.info("本次待处理分包商-资质证书数据：{}条", qualificationInfoList.size());
        JSONObject tmpQuaJson = null;
        SupplierCertificateEntity tmpQua = null;

        for(Object obj : qualificationInfoList) {
            tmpQuaJson = (JSONObject) obj;
            certMap.put(StringUtil.isNotBlank(tmpQuaJson.getString("YQL_SID")) ?
                    tmpQuaJson.getString("YQL_SID") : tmpQuaJson.getString("C_PS_QualificationInfoOID"), tmpQuaJson.getString("C_PS_QualificationInfoOID"));
        }
    }

    private void handleProjectManager(Map<String, String> managerMap, JSONArray projectManagerList) {
        logger.info("本次待处理分包商-项目经理数据：{}条", projectManagerList.size());
        JSONObject tmpManagerJson = null;
        SupplierManagerEntity tmpManager = null;
        for(Object obj : projectManagerList) {
            tmpManagerJson = (JSONObject) obj;
            managerMap.put(StringUtil.isNotBlank(tmpManagerJson.getString("YQL_SID")) ?
                    tmpManagerJson.getString("YQL_SID") : tmpManagerJson.getString("C_PS_ProjektleiterInfoOID"), tmpManagerJson.getString("C_PS_ProjektleiterInfoOID"));
        }
    }

    private void handleMaterialInfo(Map<String, String> materialInfoMap, JSONArray supplyList) {
        logger.info("本次待处理分包商-供货内容数据:{}条", supplyList.size());
        JSONObject tmpJson = null;
        MatSupplierMaterialInfoEntity materialInfoEntity = null;

        for(Object obj : supplyList) {
            tmpJson = (JSONObject) obj;
            materialInfoMap.put(StringUtil.isNotBlank(tmpJson.getString("YQL_SID")) ?
                            tmpJson.getString("YQL_SID") : tmpJson.getString("C_PS_MESupplierInfo_SubDOID"),
                    tmpJson.getString("C_PS_MESupplierInfo_SubDOID"));
        }
    }

    private void handleBank(Map<String, String> bankMap, JSONArray bankList) {
        logger.info("本次待处理分包商-银行数据：{}条", bankList.size());
        JSONObject tmpBankJson = null;
        MatSupplierBankEntity bankEntity = null;

        for(Object obj : bankList) {
            tmpBankJson = (JSONObject) obj;
            bankMap.put(StringUtil.isNotBlank(tmpBankJson.getString("YQL_SID")) ?
                    tmpBankJson.getString("YQL_SID") : tmpBankJson.getString("C_PS_SubContractorInfo_SubBOID"), tmpBankJson.getString("C_PS_SubContractorInfo_SubBOID"));
        }
    }

    private void handleArchive(Map<String, String> attachMap, JSONArray archiveList) {
        logger.info("本次待处理分包商-附件数据：{}条", archiveList.size());
        JSONObject tmpAttachJson = null;
        MatSupplierAttachesEntity attach = null;

        for(Object obj : archiveList) {
            tmpAttachJson = (JSONObject) obj;
            attachMap.put(StringUtil.isNotBlank(tmpAttachJson.getString("YQL_SID")) ?
                    tmpAttachJson.getString("YQL_SID") : tmpAttachJson.getString("C_PS_ArchivesOID"),
                    tmpAttachJson.getString("C_PS_ArchivesOID"));
        }
    }

    private void handleLinker(Map<String, String> linkerMap, JSONArray contactList) {
        logger.info("本次待处理分包商-联系人数据：{}条", contactList.size());
        MatLinkerEntity tmpLinkerEntity = null;
        JSONObject tmpLinkerJson = null;

        for(Object obj : contactList) {
            tmpLinkerJson = (JSONObject) obj;
            linkerMap.put(StringUtil.isNotBlank(tmpLinkerJson.getString("YQL_SID")) ?
                    tmpLinkerJson.getString("YQL_SID") : tmpLinkerJson.getString("subA_oid"), tmpLinkerJson.getString("subA_oid"));
        }
    }
}
