/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zds.archive.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.mapper.BankCategoryMapper;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.vo.BankCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="bankCategoryService")
public class BankCategoryServiceImpl
extends BaseServiceImpl<BankCategoryMapper, BankCategoryEntity>
implements IBankCategoryService {
    @Override
    public List<BankCategoryEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", sourceIds);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public List<BankCategoryEntity> getAllBySubBankCodes(List<String> subBankCodes) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"sub_bank_code", subBankCodes);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public List<BankCategoryVO> getAllByIds(List<Long> ids) {
        List<Object> resp = new ArrayList<BankCategoryVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, BankCategoryVO.class);
        }
        return resp;
    }

    @Override
    public Map<String, BankCategoryEntity> getAllMapBySourceIds(List<String> bankCategorySid) {
        HashMap<String, BankCategoryEntity> resp = new HashMap<String, BankCategoryEntity>();
        if (CollectionUtils.isNotEmpty(bankCategorySid)) {
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"source_id", bankCategorySid);
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            List dbList = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)dbList)) {
                for (BankCategoryEntity c : dbList) {
                    resp.put(c.getSourceId(), c);
                }
            }
        }
        return resp;
    }

    @Override
    public Map<String, BankCategoryEntity> getAllMapByNames(List<String> bankCategoryName) {
        HashMap<String, BankCategoryEntity> resp = new HashMap<String, BankCategoryEntity>();
        if (CollectionUtils.isNotEmpty(bankCategoryName)) {
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"name", bankCategoryName);
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            List dbList = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)dbList)) {
                for (BankCategoryEntity c : dbList) {
                    resp.put(c.getName(), c);
                }
            }
        }
        return resp;
    }

    @Override
    public Map<String, BankCategoryEntity> getAllMapByCodes(List<String> bankCategoryCode) {
        HashMap<String, BankCategoryEntity> resp = new HashMap<String, BankCategoryEntity>();
        if (CollectionUtils.isNotEmpty(bankCategoryCode)) {
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"code", bankCategoryCode);
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            List dbList = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)dbList)) {
                for (BankCategoryEntity c : dbList) {
                    resp.put(c.getCode(), c);
                }
            }
        }
        return resp;
    }
}

