/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.utils.BillLockUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierManagerEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierManagerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;

@Component
public class CoordinationUtil<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String USER_SUP_ROLE_LIST_URL = "/ejc-idm-web/openapi/api/user/supUserRoleList";
    private static final String USER_URL = "/ejc-oms-web/openapi/enterprise/createOrUpdateUser";
    private static final String TENANT_URL = "/ejc-oms-web/openapi/enterprise/createOrUpdateTenant";
    private static final String ADD_ROLE_URL = "/ejc-idm-web/openapi/api/user/addUserAccRole";
    private static final String REMOVE_ROLE_URL = "/ejc-idm-web/openapi/api/user/removeUserAccRole";
    @Value(value="${eachLink.host}")
    private String host;
    @Value(value="${eachLink.appId}")
    private String appId;
    @Value(value="${eachLink.secret}")
    private String secret;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ILinkerService linkerService;
    @Autowired
    private IMatLinkerService matLinkerService;
    @Autowired
    private ISupplierManagerService supplierManagerService;
    @Autowired
    private IMatSupplierService matSupplierService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private PushSupUtil pushSupUtil;

    public List<RoleUserRelationVO> getUserSupRoleList(String userPhone, String supRoleName, Long supTenant) {
        this.logger.info("\u4f9b\u65b9\u89d2\u8272\u4fe1\u606f\u67e5\u8be2\uff1auserPhone-{}, supRoleName-{}, supTenant-{}", new Object[]{userPhone, supRoleName, supTenant});
        if (StringUtils.isBlank((CharSequence)userPhone)) {
            throw new BusinessException("\u67e5\u8be2\u7528\u6237\u4f9b\u65b9\u89d2\u8272\u4fe1\u606f\u5931\u8d25\uff0c\u7528\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff01");
        }
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("userPhone", userPhone);
        reqParam.put("supRoleName", supRoleName);
        reqParam.put("supTenant", null != supTenant ? supTenant.toString() : null);
        CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithUniversal(USER_SUP_ROLE_LIST_URL, RequestMethod.POST, JSONObject.toJSONString(reqParam), this.appId, this.secret, this.host);
        this.logger.error("\u4f9b\u65b9\u89d2\u8272\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)syncReqResp));
        if (!syncReqResp.isSuccess()) {
            this.logger.error("{\u4f9b\u65b9\u89d2\u8272\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(reqParam), (Object)JSONObject.toJSONString((Object)syncReqResp));
            throw new BusinessException(syncReqResp.getMsg());
        }
        CommonResponse respData = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
        return (List)respData.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject createSupAccount(Map<String, String> reqParam) {
        this.logger.info("\u751f\u6210\u534f\u540c\u8d26\u6237\u53c2\u6570reqParam\uff1a{}\uff0curl:{}", reqParam, (Object)USER_URL);
        Long supplierId = Long.valueOf(reqParam.get("supplierId"));
        Long billId = Long.valueOf(reqParam.get("billId"));
        String linkName = reqParam.get("linkName");
        String supplierType = reqParam.get("linkSupType");
        String supplierAccRole = reqParam.get("supplierAccRole");
        boolean lockRs = false;
        String lockKeyPrefix = "\u5206\u5305\u9879\u76ee\u7ecf\u7406".equals(supplierAccRole) ? "sup::linker::coo" : "sup::manager::coo";
        try {
            int retryTime;
            try {
                lockRs = BillLockUtil.getLock(lockKeyPrefix, billId);
                for (retryTime = 0; !lockRs && retryTime <= 3; ++retryTime) {
                    this.logger.info("{}\u3010id-{},name-{},type-{}\u3011\u751f\u6210\u534f\u540c\u8d26\u6237\u83b7\u53d6\u9501\u5931\u8d25\uff0c5s\u540e\u518d\u6b21\u5c1d\u8bd5\u83b7\u53d6\u9501\uff01", new Object[]{supplierAccRole, billId, linkName, supplierAccRole});
                    TimeUnit.SECONDS.sleep(5L);
                    lockRs = BillLockUtil.getLock(lockKeyPrefix, billId);
                }
            }
            catch (Exception e) {
                this.logger.error("\u4f9b\u5e94\u5546id-{},{}id-{}\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5931\u8d25,", new Object[]{supplierId, supplierAccRole, billId, e});
            }
            if (!lockRs) {
                this.logger.error("\u4f9b\u5e94\u5546id-{},{}id-{}\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5931\u8d25,", new Object[]{supplierId, supplierAccRole, billId});
                throw new BusinessException(supplierAccRole + "[" + linkName + "]\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5931\u8d25\uff01");
            }
            if (retryTime > 0) {
                String linkerCooFlag = "0";
                Long supTenant = null;
                Long supUserId = null;
                if ("\u5206\u5305\u9879\u76ee\u7ecf\u7406".equals(supplierAccRole)) {
                    SupplierManagerEntity managerEntity = (SupplierManagerEntity)((Object)this.supplierManagerService.selectById(billId));
                    linkerCooFlag = managerEntity.getCoordination();
                    supTenant = managerEntity.getTenant();
                    supUserId = managerEntity.getSupUserId();
                } else if ("sub".equals(supplierType)) {
                    LinkerEntity subLinker = (LinkerEntity)((Object)this.linkerService.selectById(billId));
                    linkerCooFlag = subLinker.getCoordination();
                    supTenant = subLinker.getTenant();
                    supUserId = subLinker.getSupUserId();
                } else {
                    MatLinkerEntity matLinkerEntity = (MatLinkerEntity)((Object)this.matLinkerService.selectById(billId));
                    linkerCooFlag = matLinkerEntity.getCoordination();
                    supTenant = matLinkerEntity.getTenant();
                    supUserId = matLinkerEntity.getSupUserId();
                }
                if ("1".equals(linkerCooFlag)) {
                    JSONObject resp = new JSONObject();
                    resp.put("tenantId", (Object)supTenant);
                    resp.put("userId", (Object)supUserId);
                    JSONObject jSONObject = resp;
                    return jSONObject;
                }
            }
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithUniversal(USER_URL, RequestMethod.POST, JSONObject.toJSONString(reqParam), this.appId, this.secret, this.host);
            this.logger.error("{}\u751f\u6210\u534f\u540c\u8d26\u6237\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)supplierAccRole, (Object)JSONObject.toJSONString((Object)syncReqResp));
            if (!syncReqResp.isSuccess()) {
                this.logger.error("{}\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{supplierAccRole, JSONObject.toJSONString(reqParam), JSONObject.toJSONString((Object)syncReqResp)});
                throw new BusinessException(syncReqResp.getMsg());
            }
            CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (!resp.isSuccess()) {
                this.logger.error("{}\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{supplierAccRole, JSONObject.toJSONString(reqParam), JSONObject.toJSONString((Object)resp)});
                throw new BusinessException(resp.getMsg());
            }
            JSONObject jSONObject = (JSONObject)resp.getData();
            return jSONObject;
        }
        finally {
            if (lockRs) {
                BillLockUtil.releaseLock(lockKeyPrefix, billId);
            }
        }
    }

    public void sendApproveSms(JSONObject entity) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", "portal");
        params.put("name", entity.getString("linkerName"));
        params.put("phone", entity.getString("linkPhone"));
        this.pushSupUtil.sendSmsNoAuth(entity.getString("linkPhone"), "SMS_465330440", "\u4e2d\u7535\u56db\u5206\u4f9b\u65b9\u5e73\u53f0", params);
    }

    public void sendApproveEmail(JSONObject entity) {
        StringBuilder content = new StringBuilder();
        content.append(entity.getString("linkerName"));
        content.append("\uff0c\u60a8\u597d\uff0c\u606d\u559c\u60a8\u5b8c\u6210\u8054\u7cfb\u4eba\u6ce8\u518c\u5165\u5e93\uff0c\u8bf7\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5");
        String url = this.pushSupUtil.getLoginUrl();
        content.append(url);
        content.append("\uff0c\u8fdb\u884c\u767b\u5f55\uff0c\u767b\u5f55\u8d26\u53f7:");
        content.append(entity.getString("linkPhone"));
        content.append("\uff0c\u9996\u6b21\u767b\u5f55\u91c7\u7528\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8fdb\u884c\u9a8c\u8bc1");
        JSONObject params = new JSONObject();
        params.put("userEmails", (Object)entity.getString("linkEmail"));
        params.put("userNames", (Object)entity.getString("supplierName"));
        this.pushSupUtil.sendEmail(null, "notice", "\u8054\u7cfb\u4eba\u6ce8\u518c\u6210\u529f\u90ae\u4ef6", content.toString(), params, url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TenantVO createSupTenant(Map<String, String> reqParam) {
        this.logger.info("\u4f9b\u5e94\u5546\u751f\u6210\u534f\u540c\u79df\u6237\u53c2\u6570reqParam\uff1a{}\uff0curl:{}", reqParam, (Object)TENANT_URL);
        Long supplierId = Long.valueOf(reqParam.get("supplierId"));
        String supplierName = reqParam.get("supplierName");
        String supplierType = reqParam.get("supplierType");
        boolean lockRs = false;
        try {
            TenantVO vo;
            CommonResponse resp;
            int retryTime;
            try {
                lockRs = BillLockUtil.getLock("sup::tenant::coo", supplierId);
                for (retryTime = 0; !lockRs && retryTime <= 3; ++retryTime) {
                    this.logger.info("\u4f9b\u5e94\u5546\u3010id-{},name-{},type-{}\u3011\u751f\u6210\u534f\u540c\u79df\u6237\u83b7\u53d6\u9501\u5931\u8d25\uff0c5s\u540e\u518d\u6b21\u5c1d\u8bd5\u83b7\u53d6\u9501\uff01", new Object[]{supplierId, supplierName, supplierType});
                    TimeUnit.SECONDS.sleep(5L);
                    lockRs = BillLockUtil.getLock("sup::tenant::coo", supplierId);
                }
            }
            catch (Exception e) {
                this.logger.error("\u4f9b\u5e94\u5546id-{},name-{},type-{}\u751f\u6210\u534f\u540c\u79df\u6237\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5931\u8d25,", new Object[]{supplierId, supplierName, supplierType, e});
            }
            if (!lockRs) {
                this.logger.error("\u4f9b\u5e94\u5546id-{},name-{},type-{}\u751f\u6210\u534f\u540c\u79df\u6237\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5931\u8d25,", new Object[]{supplierId, supplierName, supplierType});
                throw new BusinessException("\u4f9b\u5e94\u5546[" + supplierName + "]\u751f\u6210\u534f\u540c\u79df\u6237\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5931\u8d25\uff01");
            }
            if (retryTime > 0) {
                String cooFlag = "0";
                Long supTenant = null;
                Long enterprise = null;
                if ("sub".equals(supplierType)) {
                    SupplierEntity subSupplier = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
                    cooFlag = subSupplier.getCoordination();
                    supTenant = subSupplier.getTenant();
                    enterprise = Long.valueOf(subSupplier.getSystemId());
                } else {
                    MatSupplierEntity matSupplier = (MatSupplierEntity)((Object)this.matSupplierService.selectById(supplierId));
                    cooFlag = matSupplier.getCoordination();
                    supTenant = matSupplier.getTenant();
                    enterprise = Long.valueOf(matSupplier.getSystemId());
                }
                if ("1".equals(cooFlag)) {
                    TenantVO tenantVO = new TenantVO();
                    tenantVO.setEnterpriseId(enterprise);
                    tenantVO.setId(supTenant);
                    tenantVO.setName(supplierName);
                    TenantVO tenantVO2 = tenantVO;
                    return tenantVO2;
                }
            }
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            String systemId = null;
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)ejcCloudSystemCode));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25");
            }
            systemId = (String)ejcCloudSystemCode.getData();
            reqParam.put("systemId", systemId);
            this.logger.info("\u751f\u6210\u534f\u540c\u79df\u6237\u53c2\u6570reqParam\uff1a{}\uff0crul:{}", reqParam, (Object)TENANT_URL);
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithUniversal(TENANT_URL, RequestMethod.POST, JSONObject.toJSONString(reqParam), this.appId, this.secret, this.host);
            this.logger.error("\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)syncReqResp));
            if (!syncReqResp.isSuccess()) {
                this.logger.error("\u4f9b\u5e94\u5546\u751f\u6210\u534f\u540c\u79df\u6237\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(reqParam), (Object)JSONObject.toJSONString((Object)syncReqResp));
            }
            if (!(resp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class)).isSuccess()) {
                this.logger.error("\u4f9b\u5e94\u5546\u751f\u6210\u534f\u540c\u79df\u6237\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(reqParam), (Object)JSONObject.toJSONString((Object)resp));
                throw new BusinessException(resp.getMsg());
            }
            TenantVO tenantVO = vo = (TenantVO)JSONObject.parseObject((String)JSON.toJSONString((Object)resp.getData()), TenantVO.class);
            return tenantVO;
        }
        finally {
            if (lockRs) {
                BillLockUtil.releaseLock("sup::tenant::coo", supplierId);
            }
        }
    }

    public String addUserAccRole(JSONObject params) {
        CommonResponse resp;
        this.logger.info("\u542f\u7528\u53c2\u6570reqParam\uff1a{}\uff0crul:{}", (Object)params.toJSONString(), (Object)ADD_ROLE_URL);
        String supplierId = params.getString("supplierId");
        CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(ADD_ROLE_URL, RequestMethod.POST, params.toJSONString(), supplierId);
        this.logger.error("\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)syncReqResp));
        if (!syncReqResp.isSuccess()) {
            this.logger.error("\u542f\u7528\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)params.toJSONString(), (Object)JSONObject.toJSONString((Object)syncReqResp));
        }
        if (!(resp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class)).isSuccess()) {
            this.logger.error("\u542f\u7528\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)params.toJSONString(), (Object)JSONObject.toJSONString((Object)resp));
            throw new BusinessException(resp.getMsg());
        }
        return "\u64cd\u4f5c\u6210\u529f\uff01";
    }

    public String removeUserAccRole(JSONObject params) {
        CommonResponse resp;
        this.logger.info("\u505c\u7528\u53c2\u6570reqParam\uff1a{}\uff0crul:{}", (Object)params.toJSONString(), (Object)REMOVE_ROLE_URL);
        String supplierId = params.getString("supplierId");
        CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(REMOVE_ROLE_URL, RequestMethod.POST, params.toJSONString(), supplierId);
        this.logger.error("\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)syncReqResp));
        if (!syncReqResp.isSuccess()) {
            this.logger.error("\u505c\u7528\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)params.toJSONString(), (Object)JSONObject.toJSONString((Object)syncReqResp));
        }
        if (!(resp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class)).isSuccess()) {
            this.logger.error("\u505c\u7528\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)params.toJSONString(), (Object)JSONObject.toJSONString((Object)resp));
            throw new BusinessException(resp.getMsg());
        }
        return "\u64cd\u4f5c\u6210\u529f\uff01";
    }
}

