/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IAdministrativeAreaService;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zdsmaterial.erp.api.IZDSBrandApi;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.ErpCompanyTypeEnums;
import com.ejianc.business.zdssupplier.cons.enums.ErpLinkerCardTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpTaxCreditLevelEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierBankEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierAttachesService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierBankService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierMaterialInfoService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.utils.ZDSReqUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/zdsMatSupSync"})
public class ZdsMatSupSyncController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMatSupplierService service;
    @Autowired
    private IMatLinkerService matLinkerService;
    @Autowired
    private IMatSupplierAttachesService attachesService;
    @Autowired
    private IMatSupplierBankService supplierBankService;
    @Autowired
    private IBankService bankService;
    private static final String ERP_MAT_SUPPLIER_UPDATE_URL = "/cefoc/yql/MESupplierList";
    @Autowired
    private IAdministrativeAreaService areaService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IMatSupplierMaterialInfoService materialInfoService;
    @Autowired
    private IBankCategoryService bankCategoryService;
    @Autowired
    IZDSBrandApi brandApi;

    @PostMapping(value={"/syncZdsMatSupplier"})
    @ResponseBody
    public CommonResponse<String> syncZdsMatSupplier(@RequestBody JSONObject params) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u7269\u8d44\u4f9b\u5e94\u5546\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        HashMap<String, Object> param = new HashMap<String, Object>();
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_MAT_SUPPLIER_UPDATE_URL;
        JSONObject reqJson = null;
        Object pageData = null;
        String reqDateStr = null;
        if (null == params.get((Object)"beginDate") || null == params.get((Object)"endDate")) {
            if (!"all".equals(params.getString("range"))) {
                reqDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.addDays((Date)new Date(), (int)-1));
                param.put("BeginDateTime", reqDateStr + " 00:00:00");
                param.put("EndDateTime", reqDateStr + " 23:59:59");
            }
        } else {
            param.put("BeginDateTime", params.getString("beginDate"));
            param.put("EndDateTime", params.getString("endDate"));
        }
        Boolean tyqUpdateFlag = null != params.get((Object)"tyqUpdateFlag") ? params.getBoolean("tyqUpdateFlag") : false;
        param.put("PageSize", 100);
        param.put("PageNum", 1);
        if (null != params.get((Object)"supplierSid")) {
            reqUrl = reqUrl + "?OID=" + params.getString("supplierSid");
            param.remove("BeginDateTime");
            param.remove("EndDateTime");
        }
        try {
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)120000, (Integer)120000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u7269\u8d44\u4f9b\u5e94\u5546\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers)});
                if (tyqUpdateFlag.booleanValue()) {
                    this.updateTycInfo(reqJson);
                } else {
                    this.handleErpPage(reqJson);
                }
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u7269\u8d44\u4f9b\u5e94\u5546\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u7269\u8d44\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u7269\u8d44\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u7269\u8d44\u4f9b\u5e94\u5546\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01");
    }

    private void updateTycInfo(JSONObject reqJson) {
        MatSupplierEntity tmpSupEntity = null;
        JSONObject tmpSupJson = null;
        HashMap<String, MatSupplierEntity> mapSourceMap = new HashMap<String, MatSupplierEntity>();
        JSONArray supplierArr = reqJson.getJSONArray("MESupplierList");
        this.logger.info("\u672c\u6b21\u5f85\u66f4\u65b0\u5929\u773c\u67e5\u4fe1\u606f\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff1a{}\u6761", (Object)supplierArr.size());
        if (supplierArr.size() == 0) {
            this.logger.info("\u5f85\u66f4\u65b0\u5929\u773c\u67e5\u4fe1\u606f\u7684\u4f9b\u5e94\u5546\u6570\u636e\u4e3a\u7a7a\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002\u3002\u3002\u3002");
            return;
        }
        for (Object obj : supplierArr) {
            tmpSupJson = (JSONObject)obj;
            tmpSupEntity = new MatSupplierEntity();
            tmpSupEntity.setThirdSourceId(tmpSupJson.getString("C_PS_MESupplierInfoOID"));
            if (null != tmpSupJson.get((Object)"YQL_SID") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("YQL_SID"))) {
                tmpSupEntity.setId(Long.valueOf(tmpSupJson.getString("YQL_SID")));
            }
            tmpSupEntity.setMemo(tmpSupJson.getString("Memo"));
            tmpSupEntity.setName(tmpSupJson.getString("Company_Name"));
            tmpSupEntity.setLegalPerson(tmpSupJson.getString("Company_LegalPerson"));
            tmpSupEntity.setCompanyType(ErpCompanyTypeEnums.getByCode((String)tmpSupJson.getString("CompanyStyle")));
            tmpSupEntity.setRegisteredCapitalStr(tmpSupJson.getString("RegistrationCapital"));
            tmpSupEntity.setPaidCapitalStr(tmpSupJson.getString("Paidincapital"));
            tmpSupEntity.setBusinessStatus(tmpSupJson.getString("regStatus"));
            try {
                if (null != tmpSupJson.get((Object)"OperatingPeriodStart") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("OperatingPeriodStart"))) {
                    tmpSupEntity.setBusinessStartDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpSupJson.getString("OperatingPeriodStart").split("T")[0]));
                }
                if (null != tmpSupJson.get((Object)"OperatingPeriodStartEnd") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("OperatingPeriodStartEnd"))) {
                    tmpSupEntity.setBusinessEndDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpSupJson.getString("OperatingPeriodStartEnd").split("T")[0]));
                }
                if (null != tmpSupJson.get((Object)"Restricteddate") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("Restricteddate"))) {
                    tmpSupEntity.setRestrictDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpSupJson.getString("Restricteddate").split("T")[0]));
                }
            }
            catch (Exception e) {
                this.logger.error("\u4f9b\u5e94\u5546\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38\uff1a{}, ", (Object)tmpSupJson.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)e);
            }
            tmpSupEntity.setRegisteredAddress(tmpSupJson.getString("Company_Address"));
            tmpSupEntity.setSocialCreditCode(tmpSupJson.getString("RegistrationCode"));
            tmpSupEntity.setBusinessScope(tmpSupJson.getString("OperatingRange"));
            tmpSupEntity.setCode(tmpSupJson.getString("Ma_id"));
            tmpSupEntity.setTaxCreditLevel(ErpTaxCreditLevelEnum.getByCode((String)tmpSupJson.getString("Taxcreditrating")));
            tmpSupEntity.setDisposableState(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("IsitaOneTimeUse")) ? Integer.valueOf("true".equals(tmpSupJson.getString("IsitaOneTimeUse").toLowerCase()) ? 1 : 0) : null);
            tmpSupEntity.setDisposableReason(tmpSupJson.getString("ReasonforOneTimeUse"));
            tmpSupEntity.setSealState(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("IsSupportES")) ? ("true".equals(tmpSupJson.getString("IsSupportES").toLowerCase()) ? "1" : "0") : null);
            tmpSupEntity.setPoState(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("IsPoSupplier")) ? Integer.valueOf("true".equals(tmpSupJson.getString("IsPoSupplier").toLowerCase()) ? 1 : 0) : null);
            tmpSupEntity.setCompanyGrade(tmpSupJson.getString("Company_Level"));
            tmpSupEntity.setCompanyState(tmpSupJson.getString("CompanyStatus"));
            tmpSupEntity.setSysLastUpd(tmpSupJson.getString("SYS_LAST_UPD"));
            tmpSupEntity.setErpCreatorSid(tmpSupJson.getString("SYS_CreatedBy"));
            tmpSupEntity.setErpRegisterName(tmpSupJson.getString("Register_Name"));
            tmpSupEntity.setCoordination("0");
            tmpSupEntity.setCorpName(tmpSupJson.getString("OwnerDept"));
            tmpSupEntity.setCorpErpName(tmpSupJson.getString("OwnerDept"));
            tmpSupEntity.setCorpSid(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("OwnerDeptSid")) ? tmpSupJson.getString("OwnerDeptSid").toLowerCase() : null);
            tmpSupEntity.setType(PlanConstant.ERP_MAT_INFO_TYPE_TO_EL_MAPPING.containsKey(tmpSupJson.getString("EntryDept")) ? (String)PlanConstant.ERP_MAT_INFO_TYPE_TO_EL_MAPPING.get(tmpSupJson.getString("EntryDept")) : "");
            tmpSupEntity.setErpType(tmpSupJson.getString("EntryDept"));
            tmpSupEntity.setIntentId(null);
            tmpSupEntity.setIntentName(null);
            if (StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("SupplyArea"))) {
                if (tmpSupJson.getString("SupplyArea").indexOf(",") > 0) {
                    this.logger.info("\u4f9b\u5e94\u5546-[name-{},code-{},sid-{}]\u4e1a\u52a1\u533a\u57df[{}]\u683c\u5f0f\u9519\u8bef\uff0c\u4e0d\u505a\u540c\u6b65\uff01", new Object[]{tmpSupEntity.getName(), tmpSupEntity.getCode(), tmpSupEntity.getThirdSourceId(), tmpSupJson.getString("SupplyArea")});
                }
                tmpSupEntity.setIntentName(tmpSupJson.getString("SupplyArea").replaceAll("\\|", ","));
                if (tmpSupEntity.getIntentName().endsWith(",")) {
                    tmpSupEntity.setIntentName(tmpSupEntity.getIntentName().substring(0, tmpSupEntity.getIntentName().length() - 1));
                }
                if (tmpSupEntity.getIntentName().startsWith(",")) {
                    tmpSupEntity.setIntentName(tmpSupEntity.getIntentName().substring(1));
                }
            }
            tmpSupEntity.setCompanyCharacter(PlanConstant.ERP_MAT_TYPE_LABEL_TO_EL_MAPPING.containsKey(tmpSupJson.getString("TypeLabel")) ? (String)PlanConstant.ERP_MAT_TYPE_LABEL_TO_EL_MAPPING.get(tmpSupJson.getString("TypeLabel")) : null);
            if (null == tmpSupEntity.getId()) {
                tmpSupEntity.setId(IdWorker.getId());
            }
            mapSourceMap.put(tmpSupEntity.getThirdSourceId(), tmpSupEntity);
        }
        List<MatSupplierEntity> dbList = this.service.getAllByThirdSourceIds(new ArrayList<String>(mapSourceMap.keySet()));
        ArrayList<MatSupplierEntity> updateList = new ArrayList<MatSupplierEntity>();
        if (CollectionUtils.isNotEmpty(dbList)) {
            for (MatSupplierEntity dbSupplier : dbList) {
                tmpSupEntity = (MatSupplierEntity)((Object)mapSourceMap.get(dbSupplier.getThirdSourceId()));
                dbSupplier.setName(tmpSupEntity.getName());
                dbSupplier.setSocialCreditCode(tmpSupEntity.getSocialCreditCode());
                dbSupplier.setBusinessStatus(tmpSupEntity.getBusinessStatus());
                dbSupplier.setRegisteredCapitalStr(tmpSupEntity.getRegisteredCapitalStr());
                dbSupplier.setPaidCapitalStr(StringUtils.isNotEmpty((CharSequence)tmpSupEntity.getPaidCapitalStr()) ? tmpSupEntity.getPaidCapitalStr() : "-");
                dbSupplier.setBusinessScope(tmpSupEntity.getBusinessScope());
                dbSupplier.setLegalPerson(tmpSupEntity.getLegalPerson());
                dbSupplier.setRegisteredAddress(tmpSupEntity.getRegisteredAddress());
                dbSupplier.setCompanyType(PushSupUtil.clearBracket(tmpSupEntity.getCompanyType()));
                dbSupplier.setBusinessStartDate(tmpSupEntity.getBusinessStartDate());
                dbSupplier.setBusinessEndDate(tmpSupEntity.getBusinessEndDate());
                updateList.add(dbSupplier);
            }
        }
        this.logger.info("\u672c\u6b21\u66f4\u65b0\u5929\u773c\u67e5\u7269\u8d44\u4f9b\u5e94\u5546\u4fe1\u606f:{}\u6761", (Object)updateList.size());
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.service.saveOrUpdateBatch(updateList, updateList.size(), false);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void handleErpPage(JSONObject dataJson) {
    }

    private void handleMaterialInfo(Map<String, List<MatSupplierMaterialInfoEntity>> materialInfoMap, JSONArray supplyList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u4f9b\u8d27\u5185\u5bb9\u6570\u636e:{}\u6761", (Object)supplyList.size());
        JSONObject tmpJson = null;
        MatSupplierMaterialInfoEntity materialInfoEntity = null;
        HashSet<String> brandSid = new HashSet<String>();
        ArrayList<MatSupplierMaterialInfoEntity> allInfo = new ArrayList<MatSupplierMaterialInfoEntity>();
        for (Object obj : supplyList) {
            tmpJson = (JSONObject)obj;
            materialInfoEntity = new MatSupplierMaterialInfoEntity();
            materialInfoEntity.setInfoThirdSourceId(tmpJson.getString("C_PS_MESupplierInfo_SubDOID"));
            materialInfoEntity.setMaterialName(tmpJson.getString("CompanyType"));
            materialInfoEntity.setMaterialSid(tmpJson.getString("CompanyType_Sid"));
            materialInfoEntity.setBrandName(tmpJson.getString("MainBrands"));
            materialInfoEntity.setBrandSid(tmpJson.getString("MainBrands_Sid"));
            materialInfoEntity.setPropertyValue(PlanConstant.ERP_TO_EL_MAT_MATERIAL_PROPERTY.containsKey(tmpJson.getString("PropertyCode")) ? (String)PlanConstant.ERP_TO_EL_MAT_MATERIAL_PROPERTY.get(tmpJson.getString("PropertyCode")) : tmpJson.getString("PropertyCode"));
            materialInfoEntity.setCertification(StringUtils.isBlank((CharSequence)tmpJson.getString("CertificationCode")) ? null : Integer.valueOf("1".equals(tmpJson.getString("CertificationCode")) ? 2 : 1));
            if (StringUtils.isNotBlank((CharSequence)materialInfoEntity.getBrandSid())) {
                brandSid.add(materialInfoEntity.getBrandSid());
            }
            try {
                if (null != tmpJson.get((Object)"BeginTime") && StringUtils.isNotBlank((CharSequence)tmpJson.getString("BeginTime"))) {
                    materialInfoEntity.setStartTime(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpJson.getString("BeginTime").split("T")[0]));
                }
                if (null != tmpJson.get((Object)"EndTime") && StringUtils.isNotBlank((CharSequence)tmpJson.getString("EndTime"))) {
                    materialInfoEntity.setTerminalTime(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpJson.getString("EndTime").split("T")[0]));
                }
            }
            catch (Exception e) {
                this.logger.error("\u4f9b\u8d27\u5185\u5bb9\u8d77\u6b62\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38\uff1astart-{},end-{}", (Object)tmpJson.getString("BeginTime"), (Object)tmpJson.getString("EndTime"));
            }
            materialInfoEntity.setAffiliatedManufacturer(StringUtils.isNotBlank((CharSequence)tmpJson.getString("AffiliatedCompany")) ? tmpJson.getString("AffiliatedCompany") : null);
            materialInfoEntity.setAffiliatedProjectName(tmpJson.getString("AffiliatedProject"));
            materialInfoEntity.setAffiliatedProjectSid(StringUtils.isNotBlank((CharSequence)tmpJson.getString("AccountingProjectSet_FK")) ? tmpJson.getString("AccountingProjectSet_FK") : null);
            materialInfoEntity.setSupplierSid(tmpJson.getString("MESupplierInfo_FK"));
            if (!materialInfoMap.containsKey(materialInfoEntity.getSupplierSid())) {
                materialInfoMap.put(materialInfoEntity.getSupplierSid(), new ArrayList());
            }
            materialInfoMap.get(materialInfoEntity.getSupplierSid()).add(materialInfoEntity);
            allInfo.add(materialInfoEntity);
        }
        if (CollectionUtils.isNotEmpty(brandSid)) {
            CommonResponse brandSourceResp = this.brandApi.getAllMapBySourceIds(new ArrayList(brandSid));
            if (!brandSourceResp.isSuccess() || MapUtils.isEmpty((Map)((Map)brandSourceResp.getData()))) {
                this.logger.error("\u6839\u636e\u54c1\u724csid-{}\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25: {}", (Object)JSONObject.toJSONString(brandSid), (Object)JSONObject.toJSONString((Object)brandSourceResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else {
                Map brandSourceMap = (Map)brandSourceResp.getData();
                for (MatSupplierMaterialInfoEntity info : allInfo) {
                    if (!StringUtils.isNotBlank((CharSequence)info.getBrandSid()) || !brandSourceMap.containsKey(info.getBrandSid())) continue;
                    info.setBrandId(((BrandVO)brandSourceMap.get(info.getBrandSid())).getId().toString());
                }
            }
        }
    }

    private void handleBank(Map<String, List<MatSupplierBankEntity>> bankMap, JSONArray bankList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u94f6\u884c\u6570\u636e\uff1a{}\u6761", (Object)bankList.size());
        JSONObject tmpBankJson = null;
        MatSupplierBankEntity bankEntity = null;
        HashSet<String> bankName = new HashSet<String>();
        HashSet<String> bankCategoryName = new HashSet<String>();
        HashSet<String> bankCategoryCode = new HashSet<String>();
        ArrayList<MatSupplierBankEntity> allBank = new ArrayList<MatSupplierBankEntity>();
        for (Object obj : bankList) {
            tmpBankJson = (JSONObject)obj;
            bankEntity = new MatSupplierBankEntity();
            bankEntity.setBankThirdSourceId(tmpBankJson.getString("C_PS_MESupplierInfo_SubBOID"));
            bankEntity.setBankNumber(tmpBankJson.getString("Contact_BankAccount"));
            bankEntity.setNumberType(null != tmpBankJson.getInteger("AccountType") ? Integer.valueOf(tmpBankJson.getInteger("AccountType") + 1) : null);
            bankEntity.setBankName(tmpBankJson.getString("SubBankName"));
            bankEntity.setBankType(tmpBankJson.getString("BankType"));
            bankEntity.setProvince(tmpBankJson.getString("Province"));
            bankEntity.setCity(tmpBankJson.getString("City"));
            bankEntity.setOpenBank(tmpBankJson.getString("Contact_Bank"));
            bankEntity.setBankLineNumber(tmpBankJson.getString("Contact_BankNumber"));
            bankEntity.setSupplierSid(tmpBankJson.getString("C_PS_MESupplierInfo_FK"));
            if (!bankMap.containsKey(bankEntity.getSupplierSid())) {
                bankMap.put(bankEntity.getSupplierSid(), new ArrayList());
            }
            if (StringUtils.isNotBlank((CharSequence)bankEntity.getOpenBank())) {
                bankName.add(bankEntity.getOpenBank());
            }
            if (StringUtils.isNotBlank((CharSequence)bankEntity.getBankName())) {
                bankCategoryName.add(bankEntity.getBankName());
            }
            if (StringUtils.isNotBlank((CharSequence)bankEntity.getBankType())) {
                bankCategoryCode.add(bankEntity.getBankType());
            }
            bankMap.get(bankEntity.getSupplierSid()).add(bankEntity);
            allBank.add(bankEntity);
        }
        Map<String, BankEntity> bankNameMap = this.bankService.getAllMapByNames(new ArrayList<String>(bankName));
        Map<String, BankCategoryEntity> bankCategoryNameMap = this.bankCategoryService.getAllMapByNames(new ArrayList<String>(bankCategoryName));
        Map<String, BankCategoryEntity> bankCategoryCodeMap = this.bankCategoryService.getAllMapByCodes(new ArrayList<String>(bankCategoryCode));
        for (MatSupplierBankEntity bankSub : allBank) {
            if (StringUtils.isNotBlank((CharSequence)bankSub.getOpenBank()) && bankNameMap.containsKey(bankSub.getOpenBank())) {
                bankSub.setBankId(bankNameMap.get(bankSub.getOpenBank()).getId());
                bankSub.setBankSid(bankNameMap.get(bankSub.getOpenBank()).getSourceId());
            }
            if (StringUtils.isNotBlank((CharSequence)bankSub.getBankName()) && bankCategoryNameMap.containsKey(bankSub.getBankName())) {
                bankSub.setBankCategorySid(bankCategoryNameMap.get(bankSub.getBankName()).getSourceId());
                if (StringUtils.isNotBlank((CharSequence)bankSub.getBankType())) {
                    bankSub.setBankType(bankCategoryNameMap.get(bankSub.getBankName()).getCode());
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)bankSub.getBankType()) || !bankCategoryCodeMap.containsKey(bankSub.getBankType()) || !StringUtils.isBlank((CharSequence)bankSub.getBankCategorySid())) continue;
            bankSub.setBankCategorySid(bankCategoryCodeMap.get(bankSub.getBankType()).getSourceId());
            if (!StringUtils.isNotBlank((CharSequence)bankSub.getBankName())) continue;
            bankSub.setBankName(bankCategoryCodeMap.get(bankSub.getBankType()).getName());
        }
    }

    private void handleArchive(Map<String, List<MatSupplierAttachesEntity>> attachMap, JSONArray archiveList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u9644\u4ef6\u6570\u636e\uff1a{}\u6761", (Object)archiveList.size());
        JSONObject tmpAttachJson = null;
        MatSupplierAttachesEntity attach = null;
        for (Object obj : archiveList) {
            tmpAttachJson = (JSONObject)obj;
            attach = new MatSupplierAttachesEntity();
            attach.setThirdSourceId(tmpAttachJson.getString("C_PS_ArchivesOID"));
            attach.setFileName(tmpAttachJson.getString("Attach_Name"));
            attach.setFileType(tmpAttachJson.getString("Attach_Extension"));
            attach.setType(tmpAttachJson.getString("Attach_Type"));
            attach.setFileUrl(tmpAttachJson.getString("AttachBase64"));
            attach.setSourceType(3);
            attach.setSupplierSid(tmpAttachJson.getString("C_PS_MESupplierInfo_FK"));
            if (!attachMap.containsKey(attach.getSupplierSid())) {
                attachMap.put(attach.getSupplierSid(), new ArrayList());
            }
            attachMap.get(attach.getSupplierSid()).add(attach);
        }
    }

    private void handleLinker(Map<String, List<MatLinkerEntity>> linkerMap, JSONArray contactList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u8054\u7cfb\u4eba\u6570\u636e\uff1a{}\u6761", (Object)contactList.size());
        MatLinkerEntity tmpLinkerEntity = null;
        JSONObject tmpLinkerJson = null;
        for (Object obj : contactList) {
            tmpLinkerJson = (JSONObject)obj;
            tmpLinkerEntity = new MatLinkerEntity();
            tmpLinkerEntity.setIdCardType(ErpLinkerCardTypeEnum.getElCodeByCode((String)tmpLinkerJson.getString("IDType")));
            tmpLinkerEntity.setIdCardId(tmpLinkerJson.getString("IDCard"));
            tmpLinkerEntity.setName(tmpLinkerJson.getString("Company_Contact"));
            tmpLinkerEntity.setSupplierSid(tmpLinkerJson.getString("C_PS_MESupplierInfo_FK"));
            tmpLinkerEntity.setMobileLinkPhone(tmpLinkerJson.getString("Contact_Mobile"));
            tmpLinkerEntity.setLinkPhone(tmpLinkerJson.getString("Contact_Telephone"));
            tmpLinkerEntity.setElectronicMail(tmpLinkerJson.getString("Contact_Email"));
            tmpLinkerEntity.setAddress(tmpLinkerJson.getString("Contact_Address"));
            try {
                tmpLinkerEntity.setUserType(null != tmpLinkerJson.getInteger("ContactType") ? tmpLinkerJson.getInteger("ContactType") : null);
            }
            catch (Exception e) {
                tmpLinkerEntity.setUserType(null);
                this.logger.error("\u7269\u8d44\u8054\u7cfb\u4ebasid-{} \u8054\u7cfb\u4eba\u7c7b\u578b\u683c\u5f0f\u5316\u9519\u8bef\uff1a{}", (Object)tmpLinkerJson.getString("subA_oid"), (Object)tmpLinkerJson.getString("ContactType"));
            }
            tmpLinkerEntity.setThirdSourceId(tmpLinkerJson.getString("subA_oid"));
            tmpLinkerEntity.setCoordination("0");
            tmpLinkerEntity.setLinkerStatus(StringUtils.isNotBlank((CharSequence)tmpLinkerJson.getString("ContactState")) ? Integer.valueOf(tmpLinkerJson.getString("ContactState")) : null);
            tmpLinkerEntity.setEnableStatus(2);
            if (!linkerMap.containsKey(tmpLinkerEntity.getSupplierSid())) {
                linkerMap.put(tmpLinkerEntity.getSupplierSid(), new ArrayList());
            }
            linkerMap.get(tmpLinkerEntity.getSupplierSid()).add(tmpLinkerEntity);
        }
    }

    private String getDatePattern(String operatingPeriodStartEnd) {
        StringBuilder sp = new StringBuilder();
        String[] dateArr = operatingPeriodStartEnd.split(" ");
        String[] yearDateArr = dateArr[0].split("/");
        sp.append("yyyy/M");
        if (yearDateArr[1].length() > 1) {
            sp.append("M");
        }
        sp.append("/d");
        if (yearDateArr[1].length() > 1) {
            sp.append("d");
        }
        return sp.toString();
    }
}

