/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.sub.bean.SupplierChangeEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierChangeService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.service.impl.SupplierChangeBpmServiceImpl;
import com.ejianc.business.zdssupplier.sub.vo.SupplierChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jdk.nashorn.internal.ir.annotations.Ignore;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"supplierChange"})
public class SupplierChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER_CHANGE";
    @Autowired
    private ISupplierChangeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISubTypeManagerService subTypeManagerService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private SupplierChangeBpmServiceImpl bpmService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierChangeVO> saveOrUpdate(@RequestBody SupplierChangeVO saveOrUpdateVO) {
        SupplierChangeVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(vo.getSupplierId()));
        vo.setCorpSid(supplier.getCorpSid());
        vo.setCorpErpName(supplier.getCorpErpName());
        vo.setErpType(supplier.getErpType());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierChangeVO> queryDetail(Long id) {
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)this.service.selectById(id));
        SupplierChangeVO vo = (SupplierChangeVO)BeanMapper.map((Object)((Object)entity), SupplierChangeVO.class);
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()));
        vo.setCorpSid(supplier.getCorpSid());
        vo.setCorpErpName(supplier.getCorpErpName());
        vo.setErpType(supplier.getErpType());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierChangeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SupplierChangeVO supplierChangeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("sourceType", new Parameter("eq", (Object)PlanConstant.SOURCE_TYPE_EL));
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListBySupplier"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierChangeVO>> queryListBySupplier(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("sourceType", new Parameter("eq", (Object)PlanConstant.SOURCE_TYPE_SUPPLIER));
        List<Long> subTypeIds = this.subTypeManagerService.getSubTypeIdsByUserId(InvocationInfoProxy.getEmployeeId());
        if (CollectionUtils.isEmpty(subTypeIds)) {
            Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        StringBuffer sql = new StringBuffer(" and ( ");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        for (Long subTypeId : subTypeIds) {
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("dep_profession_id", new Parameter("like", (Object)subTypeId));
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("profession_id", new Parameter("like", (Object)subTypeId));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
        }
        param.getComplexParams().add(c1);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SupplierChange-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSupplierChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierChangeVO>> refSupplierChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveChangeBySupplierId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierChangeVO> saveChangeBySupplierId(@RequestParam Long id) {
        SupplierChangeVO vo = this.service.saveChangeBySupplierId(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/TYCDetail"}, method={RequestMethod.GET})
    @ResponseBody
    @Ignore
    public CommonResponse<SupplierChangeVO> TYCDetail(@RequestParam(value="supplierName") String supplierName, @RequestParam(value="supplierId") Long supplierId, @RequestParam(value="id", required=false) Long id) {
        SupplierChangeVO vo = this.service.TYCDetail(supplierName, supplierId, id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveSyncBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Long> saveSyncBill(HttpServletRequest request) {
        return CommonResponse.success((String)"\u63a5\u6536\u6210\u529f\uff01", (Object)this.service.saveSyncBill(request));
    }

    @PostMapping(value={"/updateBillStatus"})
    @ResponseBody
    public CommonResponse<String> updateBillStatus(@RequestBody SupplierChangeVO vo) {
        String msg = this.service.updateBillStatus(vo);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/contrast"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> contrast(Long changeId) {
        JSONObject contrast = this.service.contrast(changeId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)contrast);
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> test(@RequestParam Long id) {
        CommonResponse<String> response = this.bpmService.afterApprovalProcessor(id, null, null);
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)this.service.selectById(id));
        entity.setBillState(1);
        this.service.updateById((Object)entity);
        return response;
    }
}

