/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierManagerEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierManagerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierManagerVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"supplierManager"})
public class SupplierManagerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISupplierManagerService service;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CoordinationUtil coordinationUtil;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierManagerVO> saveOrUpdate(@RequestBody SupplierManagerVO saveOrUpdateVO) {
        SupplierManagerEntity entity = (SupplierManagerEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SupplierManagerEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        SupplierManagerVO vo = (SupplierManagerVO)BeanMapper.map((Object)((Object)entity), SupplierManagerVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierManagerVO> queryDetail(Long id) {
        SupplierManagerEntity entity = (SupplierManagerEntity)((Object)this.service.selectById(id));
        SupplierManagerVO vo = (SupplierManagerVO)BeanMapper.map((Object)((Object)entity), SupplierManagerVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierManagerVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SupplierManagerVO supplierManagerVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierManagerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierManagerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List records = BeanMapper.mapList((Iterable)list, SupplierManagerVO.class);
        records.forEach(vo -> vo.setIdCardTypeName((String)PlanConstant.ID_CARD_TYPE.get(vo.getIdCardType())));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SupplierManager-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSupplierManagerData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierManagerVO>> refSupplierManagerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierManagerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/updateEnableStatus"})
    @ResponseBody
    public CommonResponse<Boolean> updateEnableStatus(@RequestBody SupplierManagerVO vo) {
        SupplierManagerEntity entity = (SupplierManagerEntity)((Object)this.service.selectById(vo.getId()));
        entity.setEnableStatus(vo.getEnableStatus());
        JSONObject params = new JSONObject();
        params.put("userId", (Object)entity.getSupUserId());
        params.put("tenantId", (Object)entity.getTenant());
        params.put("accRole", (Object)"\u5206\u5305\u9879\u76ee\u7ecf\u7406");
        params.put("accRoleCheck", (Object)true);
        params.put("supplierId", (Object)entity.getSupplierId());
        if (1 == vo.getEnableStatus() && "1".equals(vo.getCoordination())) {
            this.coordinationUtil.addUserAccRole(params);
        } else if (2 == vo.getEnableStatus() && "1".equals(vo.getCoordination())) {
            this.coordinationUtil.removeUserAccRole(params);
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f", (Object)true);
    }

    @PostMapping(value={"/accCoordination"})
    @ResponseBody
    public CommonResponse<SupplierManagerVO> accCoordination(@RequestBody SupplierManagerVO managerVO) {
        SupplierManagerEntity entity = (SupplierManagerEntity)((Object)this.service.selectById(managerVO.getId()));
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()));
        if (!"1".equals(supplier.getCoordination())) {
            this.supplierService.createSupTenant(supplier);
        }
        SupplierManagerVO vo = this.service.createSupAccount(entity, supplier.getTenant());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)vo);
    }
}

