/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zds.archive.bean.AdministrativeAreaEntity;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IAdministrativeAreaService;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.ErpCompanyTypeEnums;
import com.ejianc.business.zdssupplier.cons.enums.ErpLinkerCardTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpTaxCreditLevelEnum;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAttachesEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierBankEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierCertificateEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierManagerEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierAttachesService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierBankService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierCertificateService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierManagerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.utils.ZDSReqUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/zdsSubSupSync"})
public class ZdsSubSupSyncController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierService service;
    private static final String ERP_SUB_SUPPLIER_UPDATE_URL = "/cefoc/yql/SubContractorList";
    @Autowired
    private ILinkerService linkerService;
    @Autowired
    private ISupplierAttachesService attachesService;
    @Autowired
    private ISupplierBankService supplierBankService;
    @Autowired
    private IBankService bankService;
    @Autowired
    private ISupplierManagerService managerService;
    @Autowired
    private ISupplierCertificateService certificateService;
    @Autowired
    private IAdministrativeAreaService areaService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IZDSSubTypeApi subTypeApi;
    @Autowired
    private IBankCategoryService bankCategoryService;

    @PostMapping(value={"/syncZdsSubSupplier"})
    @ResponseBody
    public CommonResponse<String> syncZdsMatSupplier(@RequestBody JSONObject params) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5206\u5305\u5206\u5305\u5546\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        HashMap<String, Object> param = new HashMap<String, Object>();
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_SUB_SUPPLIER_UPDATE_URL;
        JSONObject reqJson = null;
        Object pageData = null;
        String reqDateStr = null;
        if (null == params.get((Object)"beginDate") || null == params.get((Object)"endDate")) {
            if (!"all".equals(params.getString("range"))) {
                reqDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.addDays((Date)new Date(), (int)-1));
                param.put("BeginDateTime", reqDateStr + " 00:00:00");
                param.put("EndDateTime", reqDateStr + " 23:59:59");
            }
        } else {
            param.put("BeginDateTime", params.getString("beginDate"));
            param.put("EndDateTime", params.getString("endDate"));
        }
        if (null != params.get((Object)"supplierSid")) {
            reqUrl = reqUrl + "?OID=" + params.getString("supplierSid");
            param.remove("BeginDateTime");
            param.remove("EndDateTime");
        }
        param.put("PageSize", 100);
        param.put("PageNum", 1);
        try {
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)120000, (Integer)120000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                this.handleErpPage(reqJson);
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5206\u5305\u5206\u5305\u5546\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u5206\u5305\u5206\u5305\u5546\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u5206\u5305\u5206\u5305\u5546\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5206\u5305\u5206\u5305\u5546\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u5206\u5305\u5206\u5305\u5546\u540c\u6b65\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public void handleErpPage(JSONObject dataJson) {
        List<SupplierEntity> dbList;
        List<AdministrativeAreaEntity> dbAreas;
        ArrayList<SupplierEntity> supList = new ArrayList<SupplierEntity>();
        ArrayList<Object> linkerList = new ArrayList<Object>();
        ArrayList<SupplierBankEntity> bankList = new ArrayList<SupplierBankEntity>();
        ArrayList<SupplierAttachesEntity> attachList = new ArrayList<SupplierAttachesEntity>();
        ArrayList<Object> managerList = new ArrayList<Object>();
        ArrayList<Object> certList = new ArrayList<Object>();
        HashSet<String> areaSids = new HashSet<String>();
        HashSet<String> copSIds = new HashSet<String>();
        HashSet<String> subTypeSIds = new HashSet<String>();
        ArrayList tmpIds = new ArrayList();
        ArrayList tmpSIds = new ArrayList();
        ArrayList intenatNames = new ArrayList();
        ArrayList subTypeNames = new ArrayList();
        ArrayList subTypeIds = new ArrayList();
        SupplierEntity tmpSupEntity = null;
        JSONObject tmpSupJson = null;
        HashMap<String, SupplierEntity> mapSourceMap = new HashMap<String, SupplierEntity>();
        HashMap<String, List<LinkerEntity>> linkerMap = new HashMap<String, List<LinkerEntity>>();
        HashMap<Long, List<LinkerEntity>> dbLinkerMap = new HashMap<Long, List<LinkerEntity>>();
        HashMap<String, List<SupplierBankEntity>> bankMap = new HashMap<String, List<SupplierBankEntity>>();
        HashMap<Long, List<SupplierBankEntity>> dbBankMap = new HashMap<Long, List<SupplierBankEntity>>();
        HashMap<String, List<SupplierAttachesEntity>> attachMap = new HashMap<String, List<SupplierAttachesEntity>>();
        HashMap<Long, List<SupplierAttachesEntity>> dbAttachMap = new HashMap<Long, List<SupplierAttachesEntity>>();
        HashMap<String, List<SupplierManagerEntity>> managerMap = new HashMap<String, List<SupplierManagerEntity>>();
        HashMap<Long, List<SupplierManagerEntity>> dbManagerMap = new HashMap<Long, List<SupplierManagerEntity>>();
        HashMap<String, List<SupplierCertificateEntity>> certMap = new HashMap<String, List<SupplierCertificateEntity>>();
        HashMap<Long, List<SupplierCertificateEntity>> dbCertMap = new HashMap<Long, List<SupplierCertificateEntity>>();
        HashMap<String, AdministrativeAreaEntity> areaMap = new HashMap<String, AdministrativeAreaEntity>();
        HashMap orgMap = new HashMap();
        HashMap subTypeMap = new HashMap();
        JSONArray supplierArr = dataJson.getJSONArray("SubContractorInfo");
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546\u6570\u636e\uff1a{}\u6761", (Object)supplierArr.size());
        if (supplierArr.size() == 0) {
            this.logger.info("\u5f85\u5904\u7406\u5206\u5305\u5546\u6570\u636e\u4e3a\u7a7a\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002\u3002\u3002\u3002");
            return;
        }
        for (Object obj : supplierArr) {
            tmpSupJson = (JSONObject)obj;
            tmpSupEntity = new SupplierEntity();
            tmpSupEntity.setThirdSourceId(tmpSupJson.getString("C_PS_SubContractorInfoOID"));
            if (null != tmpSupJson.get((Object)"YQL_SID") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("YQL_SID"))) {
                tmpSupEntity.setId(Long.valueOf(tmpSupJson.getString("YQL_SID")));
            }
            tmpSupEntity.setMemo(tmpSupJson.getString("Memo"));
            tmpSupEntity.setName(tmpSupJson.getString("Company_Name"));
            tmpSupEntity.setLegalPerson(tmpSupJson.getString("Company_LegalPerson"));
            tmpSupEntity.setCompanyType(ErpCompanyTypeEnums.getByCode((String)tmpSupJson.getString("CompanyStyle")));
            tmpSupEntity.setRegisteredCapitalStr(tmpSupJson.getString("RegistrationCapital"));
            tmpSupEntity.setPaidCapitalStr(tmpSupJson.getString("Paidincapital"));
            tmpSupEntity.setBusinessStatus(tmpSupJson.getString("regStatus"));
            tmpSupEntity.setSysLastUpd(tmpSupJson.getString("SYS_LAST_UPD"));
            tmpSupEntity.setErpCreatorSid(tmpSupJson.getString("SYS_CreatedBy"));
            tmpSupEntity.setErpRegisterName(tmpSupJson.getString("Register_Name"));
            try {
                if (null != tmpSupJson.get((Object)"OperatingPeriodStart") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("OperatingPeriodStart"))) {
                    tmpSupEntity.setBusinessStartDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpSupJson.getString("OperatingPeriodStart").split("T")[0]));
                }
                if (null != tmpSupJson.get((Object)"OperatingPeriodEnd") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("OperatingPeriodEnd"))) {
                    tmpSupEntity.setBusinessEndDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpSupJson.getString("OperatingPeriodEnd").split("T")[0]));
                }
            }
            catch (Exception e) {
                this.logger.error("\u5206\u5305\u5546\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38\uff1a{}, ", (Object)tmpSupJson.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)e);
            }
            tmpSupEntity.setRegisteredAddress(tmpSupJson.getString("Company_Address"));
            tmpSupEntity.setSocialCreditCode(tmpSupJson.getString("RegistrationCode"));
            tmpSupEntity.setBusinessScope(tmpSupJson.getString("OperatingRange"));
            tmpSupEntity.setCode(tmpSupJson.getString("Ma_id"));
            tmpSupEntity.setTaxCreditLevel(ErpTaxCreditLevelEnum.getByCode((String)tmpSupJson.getString("Taxcreditrating")));
            tmpSupEntity.setDisposableState(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("IsitaOneTimeUse")) ? Integer.valueOf("true".equals(tmpSupJson.getString("IsitaOneTimeUse").toLowerCase()) ? 1 : 0) : null);
            tmpSupEntity.setDisposableReason(tmpSupJson.getString("ReasonforOneTimeUse"));
            tmpSupEntity.setSealState(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("IsSupportES")) ? ("true".equals(tmpSupJson.getString("IsSupportES")) ? "1" : "0") : null);
            tmpSupEntity.setCompanyGrade(tmpSupJson.getString("Company_Level"));
            tmpSupEntity.setCoordination("0");
            tmpSupEntity.setCompanyState(tmpSupJson.getString("CompanyStatus"));
            tmpSupEntity.setMaxContractOnYearMny(null != tmpSupJson.get((Object)"AnnualMaxVertragsbetrag") ? tmpSupJson.getBigDecimal("AnnualMaxVertragsbetrag") : null);
            tmpSupEntity.setMaxContractOnTimeMny(null != tmpSupJson.get((Object)"MaxLimitConMoney") ? tmpSupJson.getBigDecimal("MaxLimitConMoney") : null);
            tmpSupEntity.setGroupTrain(tmpSupJson.getString("ExecutiveHeadquartersTraining"));
            tmpSupEntity.setProfessionSid(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("MainCompanyTypeSid")) ? tmpSupJson.getString("MainCompanyTypeSid").toLowerCase() : null);
            tmpSupEntity.setProfessionName(tmpSupJson.getString("MainCompanyType"));
            tmpSupEntity.setAffiliatedCompanySid(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("RelatedCompanySid")) ? tmpSupJson.getString("RelatedCompanySid").toLowerCase() : null);
            tmpSupEntity.setAffiliatedCompanyName(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("RelatedCompany")) ? tmpSupJson.getString("RelatedCompany") : null);
            tmpSupEntity.setTypeLabel(tmpSupJson.getString("TypeLabel"));
            tmpSupEntity.setDepProfessionName(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("CompanyType")) ? tmpSupJson.getString("CompanyType").toLowerCase() : null);
            tmpSupEntity.setDepProfessionSid(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("CompanyType_Sid")) ? tmpSupJson.getString("CompanyType_Sid").toLowerCase() : null);
            tmpSupEntity.setCorpName(tmpSupJson.getString("OwnerDept"));
            tmpSupEntity.setCorpErpName(tmpSupJson.getString("OwnerDept"));
            tmpSupEntity.setCorpSid(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("OwnerDeptSid")) ? tmpSupJson.getString("OwnerDeptSid").toLowerCase() : null);
            if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getCorpSid())) {
                copSIds.add(tmpSupEntity.getCorpSid());
            }
            tmpSupEntity.setType(PlanConstant.ERP_SUB_INFO_TYPE_TO_EL_MAPPING.containsKey(tmpSupJson.getString("EntryDept")) ? (String)PlanConstant.ERP_SUB_INFO_TYPE_TO_EL_MAPPING.get(tmpSupJson.getString("EntryDept")) : "");
            tmpSupEntity.setErpType(tmpSupJson.getString("EntryDept"));
            tmpSupEntity.setIntentId(null);
            tmpSupEntity.setIntentName(null);
            if (StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("ServiceAreaSid"))) {
                tmpSupEntity.setIntentSid(tmpSupJson.getString("ServiceAreaSid").toLowerCase());
                if (StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("ServiceArea"))) {
                    tmpSupEntity.setIntentName(tmpSupJson.getString("ServiceArea").replaceAll("\\|", ","));
                }
                if (tmpSupEntity.getIntentSid().endsWith(",")) {
                    tmpSupEntity.setIntentSid(tmpSupEntity.getIntentSid().substring(0, tmpSupEntity.getIntentSid().length() - 1));
                }
                if (tmpSupEntity.getIntentSid().startsWith(",")) {
                    tmpSupEntity.setIntentSid(tmpSupEntity.getIntentSid().substring(1));
                }
                areaSids.addAll(Arrays.asList(tmpSupEntity.getIntentSid().split(",")));
            }
            try {
                tmpSupEntity.setLaborServNums(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("TotalStaff")) ? Integer.valueOf(tmpSupJson.getString("TotalStaff").replace("\u4eba", "")) : null);
            }
            catch (Exception e) {
                this.logger.error("\u683c\u5f0f\u5316\u52b3\u52a1\u4eba\u6570\u603b\u91cf:{} \u5f02\u5e38\uff1a", tmpSupJson.get((Object)"TotalStaff"), (Object)e);
                tmpSupEntity.setLaborServNums(null);
            }
            if (null == tmpSupEntity.getId()) {
                tmpSupEntity.setId(IdWorker.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getProfessionSid())) {
                subTypeSIds.addAll(Arrays.asList(tmpSupEntity.getProfessionSid().split(",")));
            }
            if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getDepProfessionSid())) {
                subTypeSIds.addAll(Arrays.asList(tmpSupEntity.getDepProfessionSid().split(",")));
            }
            mapSourceMap.put(tmpSupEntity.getThirdSourceId(), tmpSupEntity);
        }
        if (CollectionUtils.isNotEmpty(areaSids) && CollectionUtils.isNotEmpty(dbAreas = this.areaService.getAllBySourceIds(new ArrayList<String>(areaSids)))) {
            for (AdministrativeAreaEntity area : dbAreas) {
                areaMap.put(area.getSourceId(), area);
            }
        }
        if (CollectionUtils.isNotEmpty(copSIds)) {
            CommonResponse orgResp = this.orgApi.findAllBySourceIds(new ArrayList(copSIds));
            if (!orgResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7SId-{}\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(copSIds), (Object)JSONObject.toJSONString((Object)orgResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)orgResp.getData()))) {
                orgMap.putAll(((List)orgResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), Function.identity())));
            }
        }
        if (CollectionUtils.isNotEmpty(subTypeSIds)) {
            CommonResponse subTypeResp = this.subTypeApi.getAllBySourceIds(new ArrayList(subTypeSIds));
            if (!subTypeResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5206\u5305\u4e13\u4e1aSId\u5217\u8868-{}\u67e5\u8be2\u5206\u5305\u7c7b\u578b\u5931\u8d25, {}\uff01", (Object)JSONObject.toJSONString(subTypeSIds), (Object)JSONObject.toJSONString((Object)subTypeResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)subTypeResp.getData()))) {
                subTypeMap.putAll(((List)subTypeResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), Function.identity())));
            }
        }
        if (null != dataJson.get((Object)"ContactList") && dataJson.getJSONArray("ContactList").size() > 0) {
            this.handleLinker(linkerMap, dataJson.getJSONArray("ContactList"));
        }
        if (null != dataJson.get((Object)"ArchivesList") && dataJson.getJSONArray("ArchivesList").size() > 0) {
            this.handleArchive(attachMap, dataJson.getJSONArray("ArchivesList"));
        }
        if (null != dataJson.get((Object)"BankList") && dataJson.getJSONArray("BankList").size() > 0) {
            this.handleBank(bankMap, dataJson.getJSONArray("BankList"));
        }
        if (null != dataJson.get((Object)"ProjectManagerList") && dataJson.getJSONArray("ProjectManagerList").size() > 0) {
            this.handleProjectManager(managerMap, dataJson.getJSONArray("ProjectManagerList"));
        }
        if (null != dataJson.get((Object)"QualificationInfoList") && dataJson.getJSONArray("QualificationInfoList").size() > 0) {
            this.handleQualification(certMap, dataJson.getJSONArray("QualificationInfoList"));
        }
        if (CollectionUtils.isNotEmpty(dbList = this.service.getAllByThirdSourceIds(new ArrayList(mapSourceMap.keySet())))) {
            List<Long> supplierIds = dbList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<LinkerEntity> linkers = this.linkerService.getAllBySupplierIds(supplierIds);
            dbLinkerMap.putAll(linkers.stream().collect(Collectors.groupingBy(LinkerEntity::getSupplierId)));
            List<SupplierManagerEntity> dbManagerList = this.managerService.getAllBySupplierIds(supplierIds);
            dbManagerMap.putAll(dbManagerList.stream().filter(item -> null != item.getThirdSourceId()).collect(Collectors.groupingBy(SupplierManagerEntity::getSupplierId)));
            List<SupplierCertificateEntity> dbCertList = this.certificateService.getAllBySupplierIds(supplierIds);
            dbCertMap.putAll(dbCertList.stream().filter(item -> null != item.getThirdSourceId()).collect(Collectors.groupingBy(SupplierCertificateEntity::getSupplierId)));
            List<SupplierBankEntity> dbBankList = this.supplierBankService.getAllBySupplierIds(supplierIds);
            dbBankMap.putAll(dbBankList.stream().filter(item -> null != item.getBankThirdSourceId()).collect(Collectors.groupingBy(SupplierBankEntity::getSupplierId)));
            List<SupplierAttachesEntity> dbAttachList = this.attachesService.getAllBySupplierIds(supplierIds);
            dbAttachMap.putAll(dbAttachList.stream().filter(item -> null != item.getThirdSourceId()).collect(Collectors.groupingBy(SupplierAttachesEntity::getSupplierId)));
            for (SupplierEntity dbSupplier : dbList) {
                ArrayList saveAttaches;
                ArrayList saveBanks;
                ArrayList saveCerts;
                ArrayList saveManagers;
                ArrayList saveLinkers;
                tmpSupEntity = (SupplierEntity)((Object)mapSourceMap.get(dbSupplier.getThirdSourceId()));
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getIntentSid())) {
                    tmpIds.clear();
                    tmpSIds.clear();
                    intenatNames.clear();
                    Arrays.asList(tmpSupEntity.getIntentSid().split(",")).stream().forEach(item -> {
                        if (areaMap.containsKey(item)) {
                            tmpIds.add(((AdministrativeAreaEntity)((Object)((Object)areaMap.get(item)))).getId().toString());
                            tmpSIds.add(((AdministrativeAreaEntity)((Object)((Object)areaMap.get(item)))).getSourceId());
                            intenatNames.add(((AdministrativeAreaEntity)((Object)((Object)areaMap.get(item)))).getName());
                        }
                    });
                    if (CollectionUtils.isNotEmpty(tmpIds)) {
                        tmpSupEntity.setIntentId(StringUtils.join(tmpIds, (String)","));
                        tmpSupEntity.setIntentSid(StringUtils.join(tmpSIds, (String)","));
                        tmpSupEntity.setIntentName(StringUtils.join(intenatNames, (String)","));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getCorpSid()) && orgMap.containsKey(tmpSupEntity.getCorpSid())) {
                    tmpSupEntity.setCorpId(((OrgVO)orgMap.get(tmpSupEntity.getCorpSid())).getId());
                    tmpSupEntity.setCorpName(((OrgVO)orgMap.get(tmpSupEntity.getCorpSid())).getName());
                    tmpSupEntity.setCorpCode(((OrgVO)orgMap.get(tmpSupEntity.getCorpSid())).getCode());
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getProfessionSid())) {
                    subTypeNames.clear();
                    subTypeIds.clear();
                    Arrays.asList(tmpSupEntity.getProfessionSid().split(",")).stream().forEach(item -> {
                        if (subTypeMap.containsKey(item)) {
                            subTypeNames.add(((SubTypeVO)subTypeMap.get(item)).getName());
                            subTypeIds.add(((SubTypeVO)subTypeMap.get(item)).getId().toString());
                        }
                    });
                    if (CollectionUtils.isNotEmpty(subTypeIds)) {
                        tmpSupEntity.setProfessionId(StringUtils.join(subTypeIds, (String)","));
                        tmpSupEntity.setProfessionName(StringUtils.join(subTypeNames, (String)","));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getDepProfessionSid())) {
                    subTypeNames.clear();
                    subTypeIds.clear();
                    Arrays.asList(tmpSupEntity.getDepProfessionSid().split(",")).stream().forEach(item -> {
                        if (subTypeMap.containsKey(item)) {
                            subTypeNames.add(((SubTypeVO)subTypeMap.get(item)).getName());
                            subTypeIds.add(((SubTypeVO)subTypeMap.get(item)).getId().toString());
                        }
                    });
                    if (CollectionUtils.isNotEmpty(subTypeIds)) {
                        tmpSupEntity.setDepProfessionId(StringUtils.join(subTypeIds, (String)","));
                        tmpSupEntity.setDepProfessionName(StringUtils.join(subTypeNames, (String)","));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getErpRegisterName()) && StringUtils.isBlank((CharSequence)dbSupplier.getErpRegisterName())) {
                    dbSupplier.setErpRegisterName(tmpSupEntity.getErpRegisterName());
                }
                if (null == dbSupplier.getBusinessEndDate() && null != tmpSupEntity.getBusinessEndDate()) {
                    dbSupplier.setBusinessEndDate(tmpSupEntity.getBusinessEndDate());
                }
                if (null == dbSupplier.getBusinessStartDate() && null != tmpSupEntity.getBusinessStartDate()) {
                    dbSupplier.setBusinessStartDate(tmpSupEntity.getBusinessStartDate());
                }
                dbSupplier.setDisposableState(tmpSupEntity.getDisposableState());
                dbSupplier.setDisposableReason(tmpSupEntity.getDisposableReason());
                dbSupplier.setCompanyGrade(tmpSupEntity.getCompanyGrade());
                dbSupplier.setCompanyState(tmpSupEntity.getCompanyState());
                dbSupplier.setType(tmpSupEntity.getType());
                dbSupplier.setCorpSid(tmpSupEntity.getCorpSid());
                dbSupplier.setCorpId(tmpSupEntity.getCorpId());
                dbSupplier.setCorpName(tmpSupEntity.getCorpName());
                dbSupplier.setCorpCode(tmpSupEntity.getCorpCode());
                dbSupplier.setCorpErpName(tmpSupEntity.getCorpErpName());
                dbSupplier.setErpType(tmpSupEntity.getErpType());
                dbSupplier.setLaborServNums(tmpSupEntity.getLaborServNums());
                dbSupplier.setTypeLabel(tmpSupEntity.getTypeLabel());
                dbSupplier.setSysLastUpd(tmpSupEntity.getSysLastUpd());
                dbSupplier.setErpCreatorSid(tmpSupEntity.getErpCreatorSid());
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getProfessionId())) {
                    dbSupplier.setProfessionId(tmpSupEntity.getProfessionId());
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getProfessionSid())) {
                    dbSupplier.setProfessionSid(tmpSupEntity.getProfessionSid());
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getProfessionName())) {
                    dbSupplier.setProfessionSid(tmpSupEntity.getProfessionName());
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getDepProfessionId())) {
                    dbSupplier.setDepProfessionId(tmpSupEntity.getDepProfessionId());
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getDepProfessionSid())) {
                    dbSupplier.setDepProfessionSid(tmpSupEntity.getDepProfessionSid());
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getDepProfessionName())) {
                    dbSupplier.setDepProfessionName(tmpSupEntity.getDepProfessionName());
                }
                dbSupplier.setDisposableState(tmpSupEntity.getDisposableState());
                dbSupplier.setDisposableReason(tmpSupEntity.getDisposableReason());
                dbSupplier.setSealState(tmpSupEntity.getSealState());
                dbSupplier.setIntentName(tmpSupEntity.getIntentName());
                dbSupplier.setIntentId(tmpSupEntity.getIntentId());
                dbSupplier.setIntentSid(tmpSupEntity.getIntentSid());
                dbSupplier.setGroupTrain(tmpSupEntity.getGroupTrain());
                supList.add(dbSupplier);
                mapSourceMap.remove(dbSupplier.getThirdSourceId());
                List<Object> list = saveLinkers = linkerMap.containsKey(dbSupplier.getThirdSourceId()) ? ((List)linkerMap.get(dbSupplier.getThirdSourceId())).stream().collect(Collectors.toList()) : new ArrayList();
                if (CollectionUtils.isNotEmpty(saveLinkers)) {
                    HashMap sourceLinkers = dbLinkerMap.containsKey(dbSupplier.getId()) ? ((List)dbLinkerMap.get(dbSupplier.getId())).stream().collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item)) : new HashMap();
                    LinkerEntity tmpLink = null;
                    for (Object link2 : saveLinkers) {
                        if (sourceLinkers.containsKey(link2.getThirdSourceId())) {
                            tmpLink = (LinkerEntity)((Object)sourceLinkers.get(link2.getThirdSourceId()));
                            tmpLink.setIdCardType(link2.getIdCardType());
                            tmpLink.setIdCardId(link2.getIdCardId());
                            tmpLink.setName(link2.getName());
                            tmpLink.setMobileLinkPhone(link2.getMobileLinkPhone());
                            tmpLink.setLinkPhone(link2.getLinkPhone());
                            tmpLink.setElectronicMail(link2.getElectronicMail());
                            tmpLink.setAddress(link2.getAddress());
                            tmpLink.setLinkerStatus(link2.getLinkerStatus());
                            tmpLink.setUserType(link2.getUserType());
                            linkerList.add((Object)tmpLink);
                            continue;
                        }
                        link2.setSupplierName(dbSupplier.getName());
                        link2.setSupplierCode(dbSupplier.getCode());
                        link2.setSupplierId(dbSupplier.getId());
                        link2.setDateType(0);
                        link2.setEnableStatus(2);
                        link2.setChangeVersion(0);
                        if (null == link2.getId()) {
                            link2.setId(IdWorker.getId());
                            link2.setSourceId(dbSupplier.getId());
                            link2.setSourceDetailId(link2.getId());
                        }
                        linkerList.add(link2);
                    }
                }
                List<Object> list2 = saveManagers = managerMap.containsKey(dbSupplier.getThirdSourceId()) ? ((List)managerMap.get(dbSupplier.getThirdSourceId())).stream().collect(Collectors.toList()) : new ArrayList();
                if (CollectionUtils.isNotEmpty(saveManagers)) {
                    Object link2;
                    HashMap sourceManager = dbManagerMap.containsKey(dbSupplier.getId()) ? ((List)dbManagerMap.get(dbSupplier.getId())).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getThirdSourceId())).collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item)) : new HashMap();
                    SupplierManagerEntity tmpManager = null;
                    link2 = saveManagers.iterator();
                    while (link2.hasNext()) {
                        Object manager2 = (SupplierManagerEntity)((Object)link2.next());
                        if (sourceManager.containsKey(manager2.getThirdSourceId())) {
                            tmpManager = (SupplierManagerEntity)((Object)sourceManager.get(manager2.getThirdSourceId()));
                            tmpManager.setIdCardId(manager2.getIdCardId());
                            tmpManager.setIdCardType(manager2.getIdCardType());
                            tmpManager.setProjectManagerName(manager2.getProjectManagerName());
                            tmpManager.setMobileLinkPhone(manager2.getMobileLinkPhone());
                            tmpManager.setLinkPhone(manager2.getLinkPhone());
                            tmpManager.setElectronicMail(manager2.getElectronicMail());
                            tmpManager.setAddress(manager2.getAddress());
                            tmpManager.setProjectManagerStatus(manager2.getProjectManagerStatus());
                            managerList.add((Object)tmpManager);
                            continue;
                        }
                        manager2.setCoordination("0");
                        manager2.setSynergyAccountStatus(2);
                        manager2.setEnableStatus(2);
                        manager2.setSupplierId(dbSupplier.getId());
                        if (null == manager2.getId()) {
                            manager2.setId(IdWorker.getId());
                            manager2.setSourceId(dbSupplier.getId());
                            manager2.setSourceDetailId(manager2.getId());
                        }
                        managerList.add(manager2);
                    }
                }
                List<Object> list3 = saveCerts = certMap.containsKey(dbSupplier.getThirdSourceId()) ? ((List)certMap.get(dbSupplier.getThirdSourceId())).stream().collect(Collectors.toList()) : new ArrayList();
                if (CollectionUtils.isNotEmpty(saveCerts)) {
                    HashMap sourceCert = dbCertMap.containsKey(dbSupplier.getId()) ? ((List)dbCertMap.get(dbSupplier.getId())).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getThirdSourceId())).collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item)) : new HashMap();
                    SupplierCertificateEntity tmpCert = null;
                    for (Object cert2 : saveCerts) {
                        if (sourceCert.containsKey(cert2.getThirdSourceId())) {
                            tmpCert = (SupplierCertificateEntity)((Object)sourceCert.get(cert2.getThirdSourceId()));
                            tmpCert.setCertificateNumber(cert2.getCertificateNumber());
                            tmpCert.setCertificateTypeName(cert2.getCertificateTypeName());
                            if (StringUtils.isNotBlank((CharSequence)cert2.getCertificateFileName())) {
                                tmpCert.setCertificateFileName(cert2.getCertificateFileName());
                            }
                            if (StringUtils.isNotBlank((CharSequence)cert2.getCertificateTypeCode())) {
                                tmpCert.setCertificateTypeCode(cert2.getCertificateTypeCode());
                            }
                            if (null == tmpCert.getCertificateTypeId() && null != cert2.getCertificateTypeId()) {
                                tmpCert.setCertificateTypeId(cert2.getCertificateTypeId());
                            }
                            if (StringUtils.isNotBlank((CharSequence)cert2.getCertificateFileUrl())) {
                                tmpCert.setCertificateFileUrl(cert2.getCertificateFileUrl());
                            }
                            tmpCert.setPeriodOfValidity(cert2.getPeriodOfValidity());
                            certList.add((Object)tmpCert);
                            continue;
                        }
                        cert2.setSupplierId(dbSupplier.getId());
                        if (null == cert2.getId()) {
                            cert2.setId(IdWorker.getId());
                            cert2.setSourceId(dbSupplier.getId());
                            cert2.setSourceDetailId(cert2.getId());
                        }
                        certList.add(cert2);
                    }
                }
                List<Object> list4 = saveBanks = bankMap.containsKey(dbSupplier.getThirdSourceId()) ? ((List)bankMap.get(dbSupplier.getThirdSourceId())).stream().collect(Collectors.toList()) : new ArrayList();
                if (CollectionUtils.isNotEmpty(saveBanks)) {
                    Object cert2;
                    HashMap sourceBank = dbBankMap.containsKey(dbSupplier.getId()) ? ((List)dbBankMap.get(dbSupplier.getId())).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getBankThirdSourceId())).collect(Collectors.toMap(item -> item.getBankThirdSourceId(), item -> item)) : new HashMap();
                    SupplierBankEntity tmpBank = null;
                    cert2 = saveBanks.iterator();
                    while (cert2.hasNext()) {
                        SupplierBankEntity bank2 = (SupplierBankEntity)((Object)cert2.next());
                        if (sourceBank.containsKey(bank2.getBankThirdSourceId())) {
                            tmpBank = (SupplierBankEntity)((Object)sourceBank.get(bank2.getBankThirdSourceId()));
                            tmpBank.setBankNumber(bank2.getBankNumber());
                            tmpBank.setNumberType(bank2.getNumberType());
                            tmpBank.setBankName(bank2.getBankName());
                            tmpBank.setBankType(bank2.getBankType());
                            tmpBank.setProvince(bank2.getProvince());
                            tmpBank.setCity(bank2.getCity());
                            tmpBank.setOpenBank(bank2.getOpenBank());
                            tmpBank.setBankLineNumber(bank2.getBankLineNumber());
                            if (StringUtils.isBlank((CharSequence)tmpBank.getBankSid()) && StringUtils.isNotBlank((CharSequence)bank2.getBankSid())) {
                                tmpBank.setBankSid(bank2.getBankSid());
                            }
                            if (StringUtils.isBlank((CharSequence)tmpBank.getBankCategorySid()) && StringUtils.isNotBlank((CharSequence)bank2.getBankCategorySid())) {
                                tmpBank.setBankCategorySid(bank2.getBankCategorySid());
                            }
                            bankList.add(tmpBank);
                            continue;
                        }
                        bank2.setSupplierId(dbSupplier.getId());
                        if (null == bank2.getId()) {
                            bank2.setId(IdWorker.getId());
                            bank2.setSourceId(dbSupplier.getId());
                            bank2.setSourceDetailId(bank2.getId());
                        }
                        bankList.add(bank2);
                    }
                }
                List<Object> list5 = saveAttaches = attachMap.containsKey(dbSupplier.getThirdSourceId()) ? ((List)attachMap.get(dbSupplier.getThirdSourceId())).stream().collect(Collectors.toList()) : new ArrayList();
                if (dbAttachMap.containsKey(dbSupplier.getId())) {
                    Map<String, SupplierAttachesEntity> sourceAttach = ((List)dbAttachMap.get(dbSupplier.getId())).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getThirdSourceId())).collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));
                    Object saveAttach = null;
                    for (SupplierAttachesEntity attach2 : saveAttaches) {
                        if (sourceAttach.containsKey(attach2.getThirdSourceId())) continue;
                        attach2.setSupplierId(dbSupplier.getId());
                        if (null == attach2.getId()) {
                            attach2.setId(IdWorker.getId());
                            attach2.setSourceId(dbSupplier.getId());
                            attach2.setSourceDetailId(attach2.getId());
                        }
                        attachList.add(attach2);
                    }
                }
                linkerMap.remove(dbSupplier.getThirdSourceId());
                attachMap.remove(dbSupplier.getThirdSourceId());
                bankMap.remove(dbSupplier.getThirdSourceId());
                managerMap.remove(dbSupplier.getThirdSourceId());
                certMap.remove(dbSupplier.getThirdSourceId());
            }
        }
        if (!mapSourceMap.isEmpty()) {
            for (SupplierEntity erpSupplier : mapSourceMap.values()) {
                if (StringUtils.isNotBlank((CharSequence)erpSupplier.getIntentName())) {
                    tmpIds.clear();
                    tmpSIds.clear();
                    Arrays.asList(erpSupplier.getIntentName().split(",")).stream().forEach(item -> {
                        if (areaMap.containsKey(item)) {
                            tmpIds.add(((AdministrativeAreaEntity)((Object)((Object)areaMap.get(item)))).getId().toString());
                            tmpSIds.add(((AdministrativeAreaEntity)((Object)((Object)areaMap.get(item)))).getSourceId());
                        }
                    });
                    if (CollectionUtils.isNotEmpty(tmpIds)) {
                        erpSupplier.setIntentId(StringUtils.join(tmpIds, (String)","));
                        erpSupplier.setIntentSid(StringUtils.join(tmpSIds, (String)","));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)erpSupplier.getCorpSid()) && orgMap.containsKey(erpSupplier.getCorpSid())) {
                    erpSupplier.setCorpId(((OrgVO)orgMap.get(erpSupplier.getCorpSid())).getId());
                    erpSupplier.setCorpName(((OrgVO)orgMap.get(erpSupplier.getCorpSid())).getName());
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getProfessionId())) {
                    subTypeNames.clear();
                    subTypeIds.clear();
                    Arrays.asList(tmpSupEntity.getProfessionId().split(",")).stream().forEach(item -> {
                        if (subTypeMap.containsKey(item)) {
                            subTypeNames.add(((SubTypeVO)subTypeMap.get(item)).getName());
                            subTypeIds.add(((SubTypeVO)subTypeMap.get(item)).getId().toString());
                        }
                    });
                    if (CollectionUtils.isNotEmpty(subTypeIds)) {
                        tmpSupEntity.setProfessionId(StringUtils.join(subTypeIds, (String)","));
                        tmpSupEntity.setProfessionName(StringUtils.join(subTypeNames, (String)","));
                    }
                }
                supList.add(erpSupplier);
                if (linkerMap.containsKey(erpSupplier.getThirdSourceId())) {
                    ((List)linkerMap.get(erpSupplier.getThirdSourceId())).forEach(link -> {
                        link.setSupplierName(erpSupplier.getName());
                        link.setSupplierCode(erpSupplier.getCode());
                        link.setSupplierId(erpSupplier.getId());
                        link.setDateType(0);
                        link.setChangeVersion(0);
                        linkerList.add(link);
                    });
                }
                if (bankMap.containsKey(erpSupplier.getThirdSourceId())) {
                    ((List)bankMap.get(erpSupplier.getThirdSourceId())).forEach(bank -> {
                        bank.setSupplierId(erpSupplier.getId());
                        bankList.add((SupplierBankEntity)((Object)bank));
                    });
                }
                if (attachMap.containsKey(erpSupplier.getThirdSourceId())) {
                    ((List)attachMap.get(erpSupplier.getThirdSourceId())).forEach(attach -> {
                        attach.setSupplierId(erpSupplier.getId());
                        attachList.add((SupplierAttachesEntity)((Object)attach));
                    });
                }
                if (managerMap.containsKey(erpSupplier.getThirdSourceId())) {
                    ((List)managerMap.get(erpSupplier.getThirdSourceId())).forEach(manager -> {
                        manager.setSupplierId(erpSupplier.getId());
                        managerList.add(manager);
                    });
                }
                if (!certMap.containsKey(erpSupplier.getThirdSourceId())) continue;
                ((List)certMap.get(erpSupplier.getThirdSourceId())).forEach(cert -> {
                    cert.setSupplierId(erpSupplier.getId());
                    certList.add(cert);
                });
            }
        }
        if (CollectionUtils.isNotEmpty(supList)) {
            this.logger.info("\u672c\u6b21\u66f4\u65b0\u5206\u5305\u5546\u6570\u91cf\uff1a{}", (Object)supList.size());
            this.service.saveOrUpdateBatch(supList, supList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(linkerList)) {
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u5206\u5305\u5546\u8054\u7cfb\u4eba\u6570\u91cf\uff1a{}", (Object)linkerList.size());
            this.linkerService.saveOrUpdateBatch(linkerList, linkerList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(bankList)) {
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u5206\u5305\u5546\u94f6\u884c\u6570\u91cf\uff1a{}", (Object)bankList.size());
            this.supplierBankService.saveOrUpdateBatch(bankList, bankList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(attachList)) {
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u5206\u5305\u5546\u9644\u4ef6\u6570\u91cf\uff1a{}", (Object)attachList.size());
            this.attachesService.saveOrUpdateBatch(attachList, attachList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(managerList)) {
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u5206\u5305\u5546\u9879\u76ee\u7ecf\u7406\u6570\u91cf\uff1a{}", (Object)managerList.size());
            this.managerService.saveOrUpdateBatch(managerList, managerList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(certList)) {
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u5206\u5305\u5546\u8d44\u8d28\u8bc1\u4e66\u6570\u91cf\uff1a{}", (Object)certList.size());
            this.certificateService.saveOrUpdateBatch(certList, certList.size(), false);
        }
    }

    private void handleQualification(Map<String, List<SupplierCertificateEntity>> certMap, JSONArray qualificationInfoList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u8d44\u8d28\u8bc1\u4e66\u6570\u636e\uff1a{}\u6761", (Object)qualificationInfoList.size());
        JSONObject tmpQuaJson = null;
        SupplierCertificateEntity tmpQua = null;
        HashSet<String> certTypeSid = new HashSet<String>();
        HashSet<String> certTypeName = new HashSet<String>();
        ArrayList<SupplierCertificateEntity> allCert = new ArrayList<SupplierCertificateEntity>();
        for (Object obj : qualificationInfoList) {
            tmpQuaJson = (JSONObject)obj;
            tmpQua = new SupplierCertificateEntity();
            tmpQua.setThirdSourceId(tmpQuaJson.getString("C_PS_QualificationInfoOID"));
            tmpQua.setCertificateTypeName(tmpQuaJson.getString("LQualificationcateGoryandevel"));
            tmpQua.setCertificateTypeCode(tmpQuaJson.getString("LQualificationcateGoryandevelsid"));
            tmpQua.setCertificateNumber(tmpQuaJson.getString("CertificateNumber"));
            tmpQua.setSourceType(3);
            if (StringUtils.isNotEmpty((CharSequence)tmpQua.getCertificateTypeCode())) {
                certTypeSid.add(tmpQua.getCertificateTypeCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)tmpQua.getCertificateTypeName())) {
                certTypeName.add(tmpQua.getCertificateTypeName());
            }
            try {
                if (null != tmpQuaJson.get((Object)"Validityperiod") && StringUtils.isNotBlank((CharSequence)tmpQuaJson.getString("Validityperiod"))) {
                    tmpQua.setPeriodOfValidity(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpQuaJson.getString("Validityperiod").split("T")[0]));
                }
            }
            catch (Exception e) {
                this.logger.error("\u5206\u5305\u5546\u8d44\u8d28\u8bc1\u4e66\u6709\u6548\u671f\u683c\u5f0f\u5316\u5f02\u5e38\uff1a{}, ", (Object)tmpQuaJson.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)e);
            }
            tmpQua.setSupplierSid(tmpQuaJson.getString("C_PS_SubContractorInfo_FK"));
            if (!certMap.containsKey(tmpQua.getSupplierSid())) {
                certMap.put(tmpQua.getSupplierSid(), new ArrayList());
            }
            allCert.add(tmpQua);
            certMap.get(tmpQua.getSupplierSid()).add(tmpQua);
        }
        Map<String, DefdocDetailVO> sidMap = this.certificateService.getAllCertTypeByCertTypeSid(new ArrayList<String>(certTypeSid));
        Map<String, DefdocDetailVO> nameMap = this.certificateService.getAllCertTypeByCertTypeName(new ArrayList<String>(certTypeName));
        for (SupplierCertificateEntity cert : allCert) {
            if (sidMap.containsKey(cert.getCertificateTypeCode())) {
                cert.setCertificateTypeId(sidMap.get(cert.getCertificateTypeCode()).getId());
            }
            if (null != cert.getCertificateTypeId() || !nameMap.containsKey(cert.getCertificateTypeName())) continue;
            cert.setCertificateTypeId(nameMap.get(cert.getCertificateTypeName()).getId());
            cert.setCertificateTypeCode(nameMap.get(cert.getCertificateTypeName()).getCode());
        }
    }

    private void handleProjectManager(Map<String, List<SupplierManagerEntity>> managerMap, JSONArray projectManagerList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u9879\u76ee\u7ecf\u7406\u6570\u636e\uff1a{}\u6761", (Object)projectManagerList.size());
        JSONObject tmpManagerJson = null;
        SupplierManagerEntity tmpManager = null;
        for (Object obj : projectManagerList) {
            tmpManagerJson = (JSONObject)obj;
            tmpManager = new SupplierManagerEntity();
            tmpManager.setThirdSourceId(tmpManagerJson.getString("C_PS_ProjektleiterInfoOID"));
            tmpManager.setProjectManagerStatus(tmpManagerJson.getInteger("ContactStatus"));
            tmpManager.setEnableStatus(2);
            tmpManager.setIdCardType(ErpLinkerCardTypeEnum.getElCodeByCode((String)tmpManagerJson.getString("IDType")));
            tmpManager.setIdCardId(tmpManagerJson.getString("IDCard"));
            tmpManager.setProjectManagerName(tmpManagerJson.getString("ContactName"));
            tmpManager.setCoordination("0");
            tmpManager.setMobileLinkPhone(tmpManagerJson.getString("Contact_Mobile"));
            tmpManager.setLinkPhone(tmpManagerJson.getString("Contact_Telephone"));
            tmpManager.setElectronicMail(tmpManagerJson.getString("Contact_Email"));
            tmpManager.setAddress(tmpManagerJson.getString("Contact_Address"));
            tmpManager.setSupplierSid(tmpManagerJson.getString("C_PS_SubContractorInfo_FK"));
            if (!managerMap.containsKey(tmpManager.getSupplierSid())) {
                managerMap.put(tmpManager.getSupplierSid(), new ArrayList());
            }
            managerMap.get(tmpManager.getSupplierSid()).add(tmpManager);
        }
    }

    private void handleLinker(Map<String, List<LinkerEntity>> linkerMap, JSONArray contactList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u8054\u7cfb\u4eba\u6570\u636e\uff1a{}\u6761", (Object)contactList.size());
        LinkerEntity tmpLinkerEntity = null;
        JSONObject tmpLinkerJson = null;
        for (Object obj : contactList) {
            tmpLinkerJson = (JSONObject)obj;
            tmpLinkerEntity = new LinkerEntity();
            tmpLinkerEntity.setIdCardType(ErpLinkerCardTypeEnum.getElCodeByCode((String)tmpLinkerJson.getString("IDType")));
            tmpLinkerEntity.setIdCardId(tmpLinkerJson.getString("IDCard"));
            tmpLinkerEntity.setName(tmpLinkerJson.getString("Company_Contact"));
            tmpLinkerEntity.setSupplierSid(tmpLinkerJson.getString("C_PS_SubContractorInfo_FK"));
            try {
                tmpLinkerEntity.setUserType(StringUtils.isNotBlank((CharSequence)tmpLinkerJson.getString("AuthorFlag")) ? Integer.valueOf("0".equals(tmpLinkerJson.getString("AuthorFlag")) ? 1 : 2) : null);
            }
            catch (Exception e) {
                this.logger.error("\u5206\u5305\u8054\u7cfb\u4ebasid-{} \u8054\u7cfb\u4eba\u7c7b\u578b\u683c\u5f0f\u5316\u9519\u8bef\uff1a{}", (Object)tmpLinkerJson.getString("subA_oid"), (Object)tmpLinkerJson.getString("AuthorFlag"));
                tmpLinkerEntity.setUserType(null);
            }
            tmpLinkerEntity.setMobileLinkPhone(tmpLinkerJson.getString("Contact_Mobile"));
            tmpLinkerEntity.setLinkPhone(tmpLinkerJson.getString("Contact_Telephone"));
            tmpLinkerEntity.setElectronicMail(tmpLinkerJson.getString("Contact_Email"));
            tmpLinkerEntity.setAddress(tmpLinkerJson.getString("Contact_Address"));
            tmpLinkerEntity.setLinkerStatus(tmpLinkerJson.getInteger("ContactState"));
            tmpLinkerEntity.setThirdSourceId(tmpLinkerJson.getString("subA_oid"));
            tmpLinkerEntity.setCoordination("0");
            tmpLinkerEntity.setEnableStatus(2);
            if (!linkerMap.containsKey(tmpLinkerEntity.getSupplierSid())) {
                linkerMap.put(tmpLinkerEntity.getSupplierSid(), new ArrayList());
            }
            linkerMap.get(tmpLinkerEntity.getSupplierSid()).add(tmpLinkerEntity);
        }
    }

    private void handleBank(Map<String, List<SupplierBankEntity>> bankMap, JSONArray bankList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u94f6\u884c\u6570\u636e\uff1a{}\u6761", (Object)bankList.size());
        JSONObject tmpBankJson = null;
        SupplierBankEntity bankEntity = null;
        HashSet<String> bankName = new HashSet<String>();
        HashSet<String> bankCategoryName = new HashSet<String>();
        HashSet<String> bankCategoryCode = new HashSet<String>();
        ArrayList<SupplierBankEntity> allBank = new ArrayList<SupplierBankEntity>();
        for (Object obj : bankList) {
            tmpBankJson = (JSONObject)obj;
            bankEntity = new SupplierBankEntity();
            bankEntity.setBankThirdSourceId(tmpBankJson.getString("C_PS_SubContractorInfo_SubBOID"));
            bankEntity.setBankNumber(tmpBankJson.getString("Contact_BankAccount"));
            bankEntity.setNumberType(null != tmpBankJson.getInteger("AccountType") ? Integer.valueOf(tmpBankJson.getInteger("AccountType") + 1) : null);
            bankEntity.setBankName(tmpBankJson.getString("SubBankName"));
            bankEntity.setBankType(tmpBankJson.getString("BankType"));
            bankEntity.setProvince(tmpBankJson.getString("Province"));
            bankEntity.setCity(tmpBankJson.getString("City"));
            bankEntity.setOpenBank(tmpBankJson.getString("Contact_Bank"));
            bankEntity.setBankLineNumber(tmpBankJson.getString("Contact_BankNumber"));
            bankEntity.setSupplierSid(tmpBankJson.getString("C_PS_SubContractorInfo_FK"));
            if (!bankMap.containsKey(bankEntity.getSupplierSid())) {
                bankMap.put(bankEntity.getSupplierSid(), new ArrayList());
            }
            if (StringUtils.isNotBlank((CharSequence)bankEntity.getOpenBank())) {
                bankName.add(bankEntity.getOpenBank());
            }
            if (StringUtils.isNotBlank((CharSequence)bankEntity.getBankName())) {
                bankCategoryName.add(bankEntity.getBankName());
            }
            if (StringUtils.isNotBlank((CharSequence)bankEntity.getBankType())) {
                bankCategoryCode.add(bankEntity.getBankType());
            }
            bankMap.get(bankEntity.getSupplierSid()).add(bankEntity);
            allBank.add(bankEntity);
        }
        Map<String, BankEntity> bankNameMap = this.bankService.getAllMapByNames(new ArrayList<String>(bankName));
        Map<String, BankCategoryEntity> bankCategoryNameMap = this.bankCategoryService.getAllMapByNames(new ArrayList<String>(bankCategoryName));
        Map<String, BankCategoryEntity> bankCategoryCodeMap = this.bankCategoryService.getAllMapByCodes(new ArrayList<String>(bankCategoryCode));
        for (SupplierBankEntity bankSub : allBank) {
            if (StringUtils.isNotBlank((CharSequence)bankSub.getOpenBank()) && bankNameMap.containsKey(bankSub.getOpenBank())) {
                bankSub.setBankId(bankNameMap.get(bankSub.getOpenBank()).getId());
                bankSub.setBankSid(bankNameMap.get(bankSub.getOpenBank()).getSourceId());
            }
            if (StringUtils.isNotBlank((CharSequence)bankSub.getBankName()) && bankCategoryNameMap.containsKey(bankSub.getBankName())) {
                bankSub.setBankCategorySid(bankCategoryNameMap.get(bankSub.getBankName()).getSourceId());
                if (StringUtils.isNotBlank((CharSequence)bankSub.getBankType())) {
                    bankSub.setBankType(bankCategoryNameMap.get(bankSub.getBankName()).getCode());
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)bankSub.getBankType()) || !bankCategoryCodeMap.containsKey(bankSub.getBankType()) || !StringUtils.isBlank((CharSequence)bankSub.getBankCategorySid())) continue;
            bankSub.setBankCategorySid(bankCategoryCodeMap.get(bankSub.getBankType()).getSourceId());
            if (!StringUtils.isNotBlank((CharSequence)bankSub.getBankName())) continue;
            bankSub.setBankName(bankCategoryCodeMap.get(bankSub.getBankType()).getName());
        }
    }

    private void handleArchive(Map<String, List<SupplierAttachesEntity>> attachMap, JSONArray archiveList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u5206\u5305\u5546-\u9644\u4ef6\u6570\u636e\uff1a{}\u6761", (Object)archiveList.size());
        JSONObject tmpAttachJson = null;
        SupplierAttachesEntity attach = null;
        for (Object obj : archiveList) {
            tmpAttachJson = (JSONObject)obj;
            attach = new SupplierAttachesEntity();
            attach.setThirdSourceId(tmpAttachJson.getString("C_PS_ArchivesOID"));
            attach.setFileName(tmpAttachJson.getString("Attach_Name"));
            attach.setFileType(tmpAttachJson.getString("Attach_Extension"));
            attach.setFileUrl(tmpAttachJson.getString("AttachBase64"));
            attach.setSourceType(3);
            attach.setSupplierSid(tmpAttachJson.getString(""));
            attach.setSupplierSid(tmpAttachJson.getString("C_PS_SubContractorInfo_FK"));
            if (!attachMap.containsKey(attach.getSupplierSid())) {
                attachMap.put(attach.getSupplierSid(), new ArrayList());
            }
            attachMap.get(attach.getSupplierSid()).add(attach);
        }
    }

    private String getDatePattern(String operatingPeriodStartEnd) {
        StringBuilder sp = new StringBuilder();
        String[] dateArr = operatingPeriodStartEnd.split(" ");
        String[] yearDateArr = dateArr[0].split("/");
        sp.append("yyyy/M");
        if (yearDateArr[1].length() > 1) {
            sp.append("M");
        }
        sp.append("/d");
        if (yearDateArr[1].length() > 1) {
            sp.append("d");
        }
        return sp.toString();
    }
}

