/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.controller.api;

import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subLinkerApi"})
public class SubLinkerApi {
    @Autowired
    private ILinkerService service;
    @Autowired
    private ISupplierService supplierService;

    @PostMapping(value={"/getBySourceIds"})
    public CommonResponse<List<LinkerVO>> getBySourceIds(@RequestBody List<String> sourceIds) {
        List<LinkerVO> vos = this.service.getBySourceIds(sourceIds);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", vos);
    }

    @GetMapping(value={"/getByMobileLinkPhone"})
    public CommonResponse<LinkerVO> getByMobileLinkPhone(String mobileLinkPhone) {
        LinkerVO vo = this.service.getByMobileLinkPhone(mobileLinkPhone);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)vo);
    }

    @PostMapping(value={"/addLinker"})
    public CommonResponse<LinkerVO> addLinker(@RequestBody LinkerVO linker) {
        LinkerVO vo = this.service.saveOrUpdate(linker);
        if (vo != null) {
            return CommonResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01", (Object)vo);
        }
        return CommonResponse.error((String)"\u65b0\u589e\u5931\u8d25\uff01");
    }

    @GetMapping(value={"/getSupUserIdAndTenant"})
    public CommonResponse<LinkerVO> getSupUserIdAndTenant(@RequestParam Long supUserId, @RequestParam Long tenantId) {
        LinkerVO linker = this.service.getSupUserIdAndTenant(supUserId, tenantId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)linker);
    }

    @GetMapping(value={"/getOneById"})
    CommonResponse<LinkerVO> getOneById(@RequestParam(value="id") Long id) {
        LinkerEntity entity = (LinkerEntity)((Object)this.service.getById(id));
        if (null == entity) {
            return CommonResponse.success(null);
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), LinkerVO.class));
    }

    @GetMapping(value={"/getBySupUserId"})
    CommonResponse<LinkerVO> getBySupUserId(@RequestParam(value="supUserId") Long supUserId, @RequestParam(value="supplierId") Long supplierId) {
        LinkerVO resp = this.service.getBySupUserId(supUserId, supplierId);
        return CommonResponse.success((Object)resp);
    }
}

