/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAttachesEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierBankEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierCertificateEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierChangeAttachesEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierChangeCertificateEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierChangeEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierManagerEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierChangeService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierChangeVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="supplierChange")
public class SupplierChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String sourceBillType = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u53d8\u66f4.getCode();
    private static final String targetBillType = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u6863\u6848.getCode();
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISupplierChangeService service;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ISubTypeManagerService subTypeManagerService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IZDSSubTypeApi subTypeApi;
    @Autowired
    private IBankService bankService;
    @Autowired
    private IBankCategoryService bankCategoryService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        Date invokeDate;
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)this.service.selectById(billId));
        boolean saveFlag = false;
        if (StringUtils.isNotBlank((CharSequence)entity.getDepProfessionId())) {
            CommonResponse subTypeResp = this.subTypeApi.getAllByIds(Arrays.stream(entity.getDepProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            if (!subTypeResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)subTypeResp.getData()))) {
                this.logger.error("\u5206\u5305\u5546\u53d8\u66f4\u4fe1\u606f\u63a8\u9001ERP\u5931\u8d25\uff0c\u67e5\u8be2\u4e3b\u952e\u4e3a\uff1a{}\u7684\u5206\u5305\u7c7b\u578b\u5931\u8d25: {}", (Object)entity.getDepProfessionId(), (Object)JSONObject.toJSONString((Object)subTypeResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else {
                saveFlag = true;
                entity.setDepProfessionSid(((List)subTypeResp.getData()).stream().map(SubTypeVO::getSourceId).collect(Collectors.joining(",")));
            }
        }
        if (null == (invokeDate = entity.getInvokeDate()) || DateUtil.compareDate(DateUtil.addDays(invokeDate, 15), new Date()) < 0) {
            return CommonResponse.error((String)"\u8ddd\u79bb\u4e0a\u4e00\u6b21\u8c03\u7528\u5929\u773c\u67e5\u65f6\u95f4\u5df2\u8d85\u8fc715\u5929\uff0c\u8bf7\u66f4\u65b0\u540e\u64cd\u4f5c\uff01");
        }
        if (CollectionUtil.isEmpty(entity.getManagerList())) {
            return CommonResponse.error((String)"\u9879\u76ee\u7ecf\u7406\u81f3\u5c11\u6dfb\u52a0\u4e00\u9879!");
        }
        JSONArray resp = this.service.getSupplierApprList(entity);
        if (resp.size() == 0) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u5206\u5305\u5546\u7684\u53d1\u5c55\u4e13\u4e1a\u6216\u4e3b\u5bfc\u4e13\u4e1a\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\uff01");
        }
        this.validate(entity);
        if (saveFlag) {
            this.service.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success();
    }

    private void validate(SupplierChangeEntity entity) {
        this.supplierService.validateUnique(entity.getName(), entity.getSocialCreditCode(), entity.getSupplierId(), "\u53d8\u66f4");
        this.service.validateRunning(entity.getSupplierId(), entity.getId());
        if (CollectionUtils.isEmpty(entity.getBankList())) {
            throw new BusinessException("\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u6761\u94f6\u884c\u4fe1\u606f\uff01");
        }
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)this.service.selectById(billId));
        SupplierChangeVO vo = new SupplierChangeVO();
        vo.setId(entity.getId());
        vo.setSourceType(entity.getSourceType());
        vo.setStatus("3");
        this.service.updateBillStatus(vo);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)this.service.selectById(billId));
        SupplierChangeVO vo = new SupplierChangeVO();
        vo.setId(entity.getId());
        vo.setSourceType(entity.getSourceType());
        vo.setStatus("2");
        vo.setFlowType("7");
        this.service.updateBillStatus(vo);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)this.service.selectById(billId));
        this.validate(entity);
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)this.service.selectById(billId));
        this.pushToArchive(entity);
        UserContext user = this.sessionManager.getUserContext();
        String msg = this.supplierService.syncSupplierChangeToErp(new SupplierSyncErpParamVO(entity.getSupplierId(), null, "supChange", billId, true, user.getUserId(), user.getUserName()));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new BusinessException(msg);
        }
        SupplierChangeVO vo = new SupplierChangeVO();
        vo.setId(entity.getId());
        vo.setSourceType(entity.getSourceType());
        vo.setStatus("6");
        this.service.updateBillStatus(vo);
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean pushToArchive(SupplierChangeEntity entity) {
        BaseEntity target;
        Map<Long, SupplierAttachesEntity> attachMap;
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(entity.getSupplierId()));
        SupplierEntity saveEntity = EntityUtil.transformFileds(supplier, entity);
        saveEntity.setSourceType("3");
        saveEntity.setCode(supplier.getCode());
        saveEntity.setBillState(supplier.getBillState());
        saveEntity.setThirdSourceId(supplier.getThirdSourceId());
        saveEntity.setTenant(supplier.getTenant());
        saveEntity.setTenantName(supplier.getTenantName());
        saveEntity.setCoordination(supplier.getCoordination());
        saveEntity.setCorpSid(supplier.getCorpSid());
        saveEntity.setCorpErpName(supplier.getCorpErpName());
        saveEntity.setAffiliatedCompanySid(supplier.getAffiliatedCompanySid());
        saveEntity.setMajorSid(supplier.getMajorSid());
        if (StringUtils.isNotBlank((CharSequence)entity.getDepProfessionSid())) {
            saveEntity.setDepProfessionSid(entity.getDepProfessionSid());
        } else {
            saveEntity.setDepProfessionSid(supplier.getDepProfessionSid());
        }
        saveEntity.setDepProfessionName(supplier.getDepProfessionName());
        saveEntity.setDepProfessionId(saveEntity.getDepProfessionId());
        saveEntity.setLinkerList(supplier.getLinkerList());
        if (StringUtils.isNotBlank((CharSequence)supplier.getErpType())) {
            saveEntity.setErpType(supplier.getErpType());
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getCorpErpName())) {
            saveEntity.setCorpErpName(supplier.getCorpErpName());
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getErpCreatorSid())) {
            saveEntity.setErpCreatorSid(supplier.getErpCreatorSid());
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getSysLastUpd())) {
            saveEntity.setSysLastUpd(supplier.getSysLastUpd());
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getErpRegisterName())) {
            saveEntity.setErpRegisterName(supplier.getErpRegisterName());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getAffiliatedCompany())) {
            String[] supplierIdsStrArr = entity.getAffiliatedCompany().split(",");
            List<Long> supplierIds = Arrays.stream(entity.getAffiliatedCompany().split(",")).map(item -> Long.valueOf(item)).collect(Collectors.toList());
            List<SupplierEntity> supplierList = this.supplierService.getAllByIds(supplierIds);
            Map<String, SupplierEntity> map = supplierList.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
            ArrayList<String> nameList = new ArrayList<String>();
            ArrayList<String> sidList = new ArrayList<String>();
            for (String supplierIdStr : supplierIdsStrArr) {
                if (!map.containsKey(supplierIdStr)) continue;
                nameList.add(map.get(supplierIdStr).getName());
                sidList.add(map.get(supplierIdStr).getThirdSourceId());
            }
            if (CollectionUtils.isNotEmpty(sidList)) {
                saveEntity.setAffiliatedCompanyName(StringUtils.join(nameList, (String)","));
            }
            if (CollectionUtils.isNotEmpty(sidList)) {
                saveEntity.setAffiliatedCompanySid(StringUtils.join(sidList, (String)","));
            }
        }
        if (CollectionUtils.isNotEmpty(supplier.getBankList())) {
            Map<Long, SupplierBankEntity> bankMap = supplier.getBankList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            if (CollectionUtils.isNotEmpty(saveEntity.getBankList())) {
                Map<String, BankEntity> bankNameMap = this.bankService.getAllMapByNames(saveEntity.getBankList().stream().map(item -> item.getOpenBank()).collect(Collectors.toList()));
                Map<String, BankCategoryEntity> bankCategoryNameMap = this.bankCategoryService.getAllMapByNames(saveEntity.getBankList().stream().map(item -> item.getBankName()).collect(Collectors.toList()));
                saveEntity.getBankList().forEach(bank -> {
                    if (bankMap.containsKey(bank.getSourceDetailId())) {
                        bank.setBankThirdSourceId(((SupplierBankEntity)((Object)((Object)((Object)bankMap.get(bank.getSourceDetailId()))))).getBankThirdSourceId());
                        bank.setBankSid(((SupplierBankEntity)((Object)((Object)((Object)bankMap.get(bank.getSourceDetailId()))))).getBankSid());
                        bank.setBankCategorySid(((SupplierBankEntity)((Object)((Object)((Object)bankMap.get(bank.getSourceDetailId()))))).getBankCategorySid());
                    }
                    if (StringUtils.isNotBlank((CharSequence)bank.getOpenBank()) && bankNameMap.containsKey(bank.getOpenBank())) {
                        bank.setBankSid(((BankEntity)((Object)((Object)((Object)bankNameMap.get(bank.getOpenBank()))))).getSourceId());
                    }
                    if (StringUtils.isNotBlank((CharSequence)bank.getBankName()) && bankCategoryNameMap.containsKey(bank.getBankName())) {
                        bank.setBankCategorySid(((BankCategoryEntity)((Object)((Object)((Object)bankCategoryNameMap.get(bank.getBankName()))))).getSourceId());
                    }
                });
            }
        }
        if (CollectionUtils.isNotEmpty(supplier.getAttachesList())) {
            attachMap = supplier.getAttachesList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            if (CollectionUtils.isNotEmpty(saveEntity.getAttachesList())) {
                saveEntity.getAttachesList().forEach(attach -> {
                    if (attachMap.containsKey(attach.getSourceDetailId())) {
                        attach.setThirdSourceId(((SupplierAttachesEntity)((Object)((Object)((Object)attachMap.get(attach.getSourceDetailId()))))).getThirdSourceId());
                    }
                });
            }
        }
        if (CollectionUtils.isNotEmpty(supplier.getCertificateList())) {
            Map<Long, SupplierCertificateEntity> certMap = supplier.getCertificateList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            if (CollectionUtils.isNotEmpty(saveEntity.getAttachesList())) {
                saveEntity.getCertificateList().forEach(cert -> {
                    if (certMap.containsKey(cert.getSourceDetailId())) {
                        cert.setThirdSourceId(((SupplierCertificateEntity)((Object)((Object)((Object)certMap.get(cert.getSourceDetailId()))))).getThirdSourceId());
                    }
                });
            }
        }
        if (CollectionUtils.isNotEmpty(saveEntity.getManagerList())) {
            if (CollectionUtils.isNotEmpty(supplier.getManagerList())) {
                Map<Long, SupplierManagerEntity> managerMap = supplier.getManagerList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
                if (CollectionUtils.isNotEmpty(saveEntity.getAttachesList())) {
                    saveEntity.getManagerList().forEach(manager -> {
                        if (managerMap.containsKey(manager.getSourceDetailId())) {
                            manager.setThirdSourceId(((SupplierManagerEntity)((Object)((Object)((Object)managerMap.get(manager.getSourceDetailId()))))).getThirdSourceId());
                        }
                    });
                }
            }
        } else {
            saveEntity.setManagerList(supplier.getManagerList());
        }
        this.supplierService.saveOrUpdate((Object)saveEntity, false);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, "attachMgr", String.valueOf(supplier.getId()), targetBillType, "attachMgr");
        attachMap = new HashMap<Long, SupplierAttachesEntity>();
        for (SupplierAttachesEntity x : supplier.getAttachesList()) {
            attachMap.put(x.getSourceDetailId(), x);
        }
        HashMap<Long, SupplierCertificateEntity> certMap = new HashMap<Long, SupplierCertificateEntity>();
        for (SupplierCertificateEntity supplierCertificateEntity : supplier.getCertificateList()) {
            certMap.put(supplierCertificateEntity.getSourceDetailId(), supplierCertificateEntity);
        }
        for (SupplierChangeAttachesEntity supplierChangeAttachesEntity : entity.getAttachesList()) {
            if (!attachMap.containsKey(supplierChangeAttachesEntity.getId())) continue;
            target = attachMap.get(supplierChangeAttachesEntity.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierChangeAttachesEntity.getId()), sourceBillType, "file", String.valueOf(target.getId()), targetBillType, "file");
        }
        for (SupplierChangeCertificateEntity supplierChangeCertificateEntity : entity.getCertificateList()) {
            if (!certMap.containsKey(supplierChangeCertificateEntity.getId())) continue;
            target = (SupplierCertificateEntity)((Object)certMap.get(supplierChangeCertificateEntity.getId()));
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierChangeCertificateEntity.getId()), sourceBillType, "cert", String.valueOf(target.getId()), targetBillType, "cert");
        }
        return true;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray resp = this.service.getSupplierApprList(billId);
        if (resp.size() == 0) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u5206\u5305\u5546\u7684\u53d1\u5c55\u4e13\u4e1a\u6216\u4e3b\u5bfc\u4e13\u4e1a\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\uff01");
        }
        return CommonResponse.success((Object)resp);
    }
}

