/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zds.archive.bean.SubTypeManagerEntity;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.SupplierAttachesEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierCertificateEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierChangeAttachesEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierChangeCertificateEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierChangeEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierChangeFlowEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierHistoryEntity;
import com.ejianc.business.zdssupplier.sub.mapper.SupplierChangeMapper;
import com.ejianc.business.zdssupplier.sub.service.ISupplierChangeCertificateService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierChangeFlowService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierChangeService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierHistoryService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierChangeFlowVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierChangeVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierHistoryAttachesVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierHistoryCertificateVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierHistoryVO;
import com.ejianc.business.zdssupplier.utils.enterprise.dispatch.CompanyCheckFactory;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCertificateVO;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCompanyInfoVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplierChangeService")
public class SupplierChangeServiceImpl
extends BaseServiceImpl<SupplierChangeMapper, SupplierChangeEntity>
implements ISupplierChangeService {
    private static final String BILL_CODE = "ZDS_SUB_SUPPLIER_CHANGE";
    private static final String SYSTEM_ID = "systemId";
    private static final String BILL_TYPE = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u53d8\u66f4.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u53d8\u66f4.getName();
    private static final String sourceBillType = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u6863\u6848.getCode();
    private static final String targetBillType = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u53d8\u66f4.getCode();
    private static final String historyBillType = BillTypeEnum.\u5206\u5305\u4f9b\u5e94\u5546\u5386\u53f2.getCode();
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supplierChange/syncBillStatus";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ISupplierHistoryService historyService;
    @Autowired
    private ISupplierChangeCertificateService certService;
    @Autowired
    private ISupplierChangeFlowService flowService;
    @Autowired
    private ISubTypeManagerService subTypeManagerService;

    @Override
    public SupplierChangeVO saveOrUpdate(SupplierChangeVO saveOrUpdateVO) {
        SupplierChangeEntity data;
        SupplierEntity supplier;
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SupplierChangeEntity.class));
        if (null == entity.getId() ? !(supplier = (SupplierEntity)((Object)this.supplierService.selectById(saveOrUpdateVO.getSupplierId()))).getName().equals(entity.getName()) && DateUtil.compareDate(entity.getInvokeDate(), supplier.getInvokeDate()) == 0 : !(data = (SupplierChangeEntity)((Object)super.selectById((Serializable)entity.getId()))).getName().equals(entity.getName()) && DateUtil.compareDate(entity.getInvokeDate(), data.getInvokeDate()) == 0) {
            throw new BusinessException("\u4f9b\u5e94\u5546\u540d\u79f0\u5df2\u4fee\u6539\uff0c\u8bf7\u5148\u70b9\u51fb\u5929\u773c\u67e5\u540c\u6b65\u4f01\u4e1a\u4fe1\u606f\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        }
        super.saveOrUpdate((Object)entity, false);
        SupplierChangeVO vo = (SupplierChangeVO)BeanMapper.map((Object)((Object)entity), SupplierChangeVO.class);
        return vo;
    }

    @Override
    public SupplierChangeVO saveChangeBySupplierId(Long id) {
        BaseEntity target;
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(id));
        SupplierChangeEntity entity = EntityUtil.clearInvalidEntity(supplier, SupplierChangeEntity.class);
        entity.setSupplierId(id);
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        UserContext user = this.pushSupUtil.getUser();
        entity.setEmployeeId(user.getEmployeeId());
        entity.setEmployeeName(user.getEmployeeName());
        entity.setBillDate(new Date());
        super.saveOrUpdate((Object)entity, false);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplier.getId()), sourceBillType, "attachMgr", String.valueOf(entity.getId()), targetBillType, "attachMgr");
        Map<Long, SupplierChangeAttachesEntity> attachMap = entity.getAttachesList().stream().collect(Collectors.toMap(x -> x.getSourceDetailId(), x -> x));
        Map<Long, SupplierChangeCertificateEntity> certMap = entity.getCertificateList().stream().collect(Collectors.toMap(x -> x.getSourceDetailId(), x -> x));
        for (SupplierAttachesEntity supplierAttachesEntity : supplier.getAttachesList()) {
            if (!attachMap.containsKey(supplierAttachesEntity.getId())) continue;
            target = attachMap.get(supplierAttachesEntity.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierAttachesEntity.getId()), sourceBillType, "file", String.valueOf(target.getId()), targetBillType, "file");
        }
        for (SupplierCertificateEntity supplierCertificateEntity : supplier.getCertificateList()) {
            if (!certMap.containsKey(supplierCertificateEntity.getId())) continue;
            target = certMap.get(supplierCertificateEntity.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierCertificateEntity.getId()), sourceBillType, "cert", String.valueOf(target.getId()), targetBillType, "cert");
        }
        this.pushToHistory(entity.getSupplierId(), entity.getId());
        SupplierChangeVO resp = (SupplierChangeVO)BeanMapper.map((Object)((Object)entity), SupplierChangeVO.class);
        resp.setCorpSid(supplier.getCorpSid());
        resp.setCorpErpName(supplier.getCorpErpName());
        resp.setErpType(supplier.getErpType());
        return resp;
    }

    @Override
    public SupplierChangeVO TYCDetail(String supplierName, Long supplierId, Long id) {
        if (StringUtils.isEmpty((CharSequence)supplierName)) {
            throw new BusinessException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BaseCompanyInfoVO company = CompanyCheckFactory.getInstance("TYCProcessor").getCompanyInfo(supplierName, null);
        if (null == company) {
            return new SupplierChangeVO();
        }
        SupplierChangeEntity entity = null;
        if (id != null) {
            entity = (SupplierChangeEntity)((Object)super.selectById((Serializable)id));
        }
        if (entity == null) {
            SupplierChangeVO vo = this.saveChangeBySupplierId(supplierId);
            entity = (SupplierChangeEntity)((Object)BeanMapper.map((Object)vo, SupplierChangeEntity.class));
        }
        entity.setName(supplierName);
        entity.setInvokeDate(new Date());
        entity.setSocialCreditCode(company.getSocialCreditCode());
        entity.setBusinessStatus(company.getBusinessStatus());
        entity.setRegisteredCapitalStr(company.getRegisteredCapitalStr());
        entity.setPaidCapitalStr(company.getPaidCapitalStr());
        entity.setBusinessScope(company.getBusinessScope());
        entity.setLegalPerson(company.getLegalPerson());
        entity.setRegisteredAddress(company.getRegisteredAddress());
        entity.setCompanyType(PushSupUtil.clearBracket(company.getCompanyType()));
        entity.setBusinessStartDate(company.getBusinessStartDate());
        entity.setBusinessEndDate(company.getBusinessEndDate());
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        List<BaseCertificateVO> certList = company.getCertiList();
        List<SupplierChangeCertificateEntity> addList = this.transferCertList(certList, entity.getId());
        if (CollectionUtils.isNotEmpty(addList)) {
            entity.setCertificateList(addList);
        }
        super.saveOrUpdate((Object)entity, false);
        SupplierChangeVO vo = (SupplierChangeVO)BeanMapper.map((Object)((Object)entity), SupplierChangeVO.class);
        return vo;
    }

    @Override
    public Boolean validateRunning(Long supplierId, Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getParams().put("id", new Parameter("ne", (Object)id));
        param.getParams().put("status", new Parameter("in", (Object)"2,3"));
        List list = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Set billCodes = list.stream().map(SupplierChangeEntity::getCode).collect(Collectors.toSet());
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u8fdb\u884c\u4e2d\u53d8\u66f4\u5355\u3010" + StringUtils.join(billCodes, (String)",") + "\u3011\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u8d77\u53d8\u66f4!");
        }
        return true;
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        Long fileId;
        String transData = request.getParameter("transData");
        SupplierChangeEntity saveEntity = (SupplierChangeEntity)((Object)JSONObject.parseObject((String)transData, SupplierChangeEntity.class));
        this.validateRunning(saveEntity.getSupplierId(), saveEntity.getId());
        Long id = this.pushSupUtil.saveSyncBill(request, SupplierChangeEntity.class, BILL_TYPE, BILL_NAME, false);
        if (null == id) {
            throw new BusinessException("\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01");
        }
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)super.selectById((Serializable)id));
        entity.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER.toString());
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        List<SupplierChangeAttachesEntity> attachList = entity.getAttachesList();
        List<SupplierChangeCertificateEntity> certList = entity.getCertificateList();
        for (SupplierChangeAttachesEntity attach : attachList) {
            fileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, attach.getId(), "file", attach.getFileId());
            attach.setFileId(fileId);
            attach.setAttachIds(Collections.singletonList(fileId));
        }
        for (SupplierChangeCertificateEntity cert : certList) {
            fileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, cert.getId(), "cert", cert.getCertificateFileId());
            cert.setCertificateFileId(fileId);
            cert.setAttachIds(Collections.singletonList(fileId));
        }
        super.saveOrUpdate((Object)entity, false);
        this.pushToHistory(entity.getSupplierId(), entity.getId());
        SupplierChangeVO vo = new SupplierChangeVO();
        vo.setId(entity.getId());
        vo.setSourceType(entity.getSourceType());
        vo.setStatus("2");
        vo.setEmployeeId(entity.getEmployeeId());
        vo.setEmployeeName(entity.getEmployeeName());
        vo.setBillDate(entity.getBillDate());
        this.updateBillStatus(vo, true);
        return id;
    }

    @Override
    public String updateBillStatus(SupplierChangeVO vo) {
        return this.updateBillStatus(vo, false);
    }

    @Override
    public String updateBillStatus(SupplierChangeVO vo, Boolean saveFlag) {
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (PlanConstant.SOURCE_TYPE_EL.equals(Integer.valueOf(entity.getSourceType()))) {
            return null;
        }
        this.pushSupUtil.validateStatus(vo.getStatus(), entity.getStatus());
        entity.setStatus(vo.getStatus());
        if (!saveFlag.booleanValue()) {
            this.pushSupUtil.updateBillStatus((JSONObject)JSONObject.toJSON((Object)((Object)entity)), "status", SYSTEM_ID, BILL_TYPE, BILL_NAME, BILL_WITER_BACK_SERVER_URL, null);
        }
        super.saveOrUpdate((Object)entity);
        if (saveFlag.booleanValue()) {
            SupplierChangeFlowEntity flow = new SupplierChangeFlowEntity();
            flow.setChangeId(entity.getId());
            flow.setFlowType(vo.getStatus());
            flow.setOperatorId(vo.getEmployeeId());
            flow.setOperatorName(vo.getEmployeeName());
            flow.setOperateTime(vo.getBillDate());
            this.flowService.saveOrUpdate((Object)flow, false);
        } else {
            SupplierChangeFlowVO flow = new SupplierChangeFlowVO();
            flow.setChangeId(entity.getId());
            flow.setFlowType(StringUtils.isNotEmpty((CharSequence)vo.getFlowType()) ? vo.getFlowType() : vo.getStatus());
            this.flowService.saveOrUpdate(flow);
        }
        return null;
    }

    @Override
    public JSONObject contrast(Long changeId) {
        SupplierChangeEntity entity = (SupplierChangeEntity)((Object)super.selectById((Serializable)changeId));
        QueryParam param = new QueryParam();
        param.getParams().put("changeId", new Parameter("eq", (Object)changeId));
        List list = this.historyService.queryList(param);
        SupplierHistoryEntity history = (SupplierHistoryEntity)((Object)this.historyService.selectById(((SupplierHistoryEntity)((Object)list.get(0))).getId()));
        JSONObject json = new JSONObject();
        json.put("change", BeanMapper.map((Object)((Object)entity), SupplierChangeVO.class));
        json.put("source", BeanMapper.map((Object)((Object)history), SupplierHistoryVO.class));
        return json;
    }

    @Override
    public Boolean pushToHistory(Long supplierId, Long changeId) {
        SupplierHistoryAttachesVO target;
        SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        SupplierHistoryVO save = EntityUtil.clearInvalidEntity(supplier, SupplierHistoryVO.class);
        save.setSupplierId(supplier.getId());
        save.setChangeId(changeId);
        SupplierHistoryVO history = this.historyService.saveOrUpdate(save);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplier.getId()), sourceBillType, "attachMgr", String.valueOf(history.getId()), historyBillType, "attachMgr");
        Map<Long, SupplierHistoryAttachesVO> attachMap = history.getAttachesList().stream().collect(Collectors.toMap(x -> null != x.getSourceDetailId() ? x.getSourceDetailId() : x.getId(), x -> x));
        Map<Long, SupplierHistoryCertificateVO> certMap = history.getCertificateList().stream().collect(Collectors.toMap(x -> null != x.getSourceDetailId() ? x.getSourceDetailId() : x.getId(), x -> x));
        for (SupplierAttachesEntity supplierAttachesEntity : supplier.getAttachesList()) {
            if (!attachMap.containsKey(supplierAttachesEntity.getId())) continue;
            target = attachMap.get(supplierAttachesEntity.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierAttachesEntity.getId()), sourceBillType, "file", String.valueOf(target.getId()), historyBillType, "file");
        }
        for (SupplierCertificateEntity supplierCertificateEntity : supplier.getCertificateList()) {
            if (!certMap.containsKey(supplierCertificateEntity.getId())) continue;
            target = certMap.get(supplierCertificateEntity.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierCertificateEntity.getId()), sourceBillType, "cert", String.valueOf(target.getId()), historyBillType, "cert");
        }
        return true;
    }

    @Override
    public JSONArray getSupplierApprList(SupplierChangeEntity supplier) {
        List<SubTypeManagerEntity> mangers;
        JSONArray resp = new JSONArray();
        if (StringUtils.isBlank((CharSequence)supplier.getProfessionId()) && StringUtils.isBlank((CharSequence)supplier.getDepProfessionId())) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u5206\u5305\u5546\u7684\u53d1\u5c55\u4e13\u4e1a\u548c\u4e3b\u5bfc\u4e13\u4e1a\u90fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)supplier.getDepProfessionId())) {
            mangers = this.subTypeManagerService.getAllBySubTypeIds(Arrays.stream(supplier.getDepProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(mangers)) {
                mangers.stream().forEach(item -> {
                    JSONObject obj = new JSONObject();
                    obj.put("userId", (Object)item.getManagerId());
                    obj.put("userName", (Object)item.getManagerName());
                    resp.add((Object)obj);
                });
            }
        } else if (StringUtils.isNotBlank((CharSequence)supplier.getDepProfessionSid()) && CollectionUtils.isNotEmpty(mangers = this.subTypeManagerService.getAllBySubTypeSids(Arrays.stream(supplier.getDepProfessionSid().split(",")).collect(Collectors.toList())))) {
            mangers.stream().forEach(item -> {
                JSONObject obj = new JSONObject();
                obj.put("userId", (Object)item.getManagerId());
                obj.put("userName", (Object)item.getManagerName());
                resp.add((Object)obj);
            });
        }
        if (resp.size() == 0 && StringUtils.isNotBlank((CharSequence)supplier.getProfessionId()) && CollectionUtils.isNotEmpty(mangers = this.subTypeManagerService.getAllBySubTypeIds(Arrays.stream(supplier.getProfessionId().split(",")).map(Long::parseLong).collect(Collectors.toList())))) {
            mangers.stream().forEach(item -> {
                JSONObject obj = new JSONObject();
                obj.put("userId", (Object)item.getManagerId());
                obj.put("userName", (Object)item.getManagerName());
                resp.add((Object)obj);
            });
        }
        return resp;
    }

    @Override
    public JSONArray getSupplierApprList(Long id) {
        SupplierChangeEntity supplier = (SupplierChangeEntity)((Object)super.selectById((Serializable)id));
        return this.getSupplierApprList(supplier);
    }

    private List<SupplierChangeCertificateEntity> transferCertList(List<BaseCertificateVO> certList, Long changeId) {
        if (CollectionUtils.isEmpty(certList)) {
            return new ArrayList<SupplierChangeCertificateEntity>();
        }
        Map<Object, Object> certMap = new HashMap();
        if (changeId != null) {
            QueryParam param = new QueryParam();
            param.getParams().put("changeId", new Parameter("eq", (Object)changeId));
            List list = this.certService.queryList(param);
            certMap = list.stream().collect(Collectors.toMap(e -> e.getCertificateTypeName() + "|" + e.getCertificateNumber(), x -> x, (v1, v2) -> v2));
        }
        Map<Object, Object> defMap = new HashMap();
        CommonResponse resp = this.defdocApi.getDefDocByDefId(Long.valueOf(824965747632509009L));
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            defMap = ((List)resp.getData()).stream().collect(Collectors.toMap(x -> x.getName(), x -> x, (v1, v2) -> v2));
        }
        ArrayList<SupplierChangeCertificateEntity> addList = new ArrayList<SupplierChangeCertificateEntity>();
        for (BaseCertificateVO cert : certList) {
            List<String> names = Arrays.asList(cert.getName().split(","));
            for (String name : names) {
                SupplierChangeCertificateEntity vo = new SupplierChangeCertificateEntity();
                if (certMap.containsKey(name + "|" + cert.getCode())) {
                    vo = (SupplierChangeCertificateEntity)((Object)certMap.get(name + "|" + cert.getCode()));
                }
                vo.setCertificateTypeName(name);
                if (!defMap.containsKey(name)) continue;
                vo.setCertificateTypeId(((DefdocDetailVO)defMap.get(name)).getId());
                vo.setCertificateTypeCode(((DefdocDetailVO)defMap.get(name)).getCode());
                vo.setCertificateNumber(cert.getCode());
                vo.setPeriodOfValidity(cert.getEndDate());
                vo.setSourceType(2);
                addList.add(vo);
            }
        }
        return addList;
    }
}

