/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sq.keyan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sq.keyan.bean.KeyanWorkSureEntity;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;
import com.ejianc.business.sq.keyan.service.IKeyanWorkSureService;
import com.ejianc.business.sq.keyan.vo.KeyanWorkSureVO;
import com.ejianc.business.util.ImportCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sq/keyan/workSure"})
public class KeyanWorkSureController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    private static final String BILL_CODE = "zydxKeyanWorkSure";
    @Autowired
    private IKeyanWorkSureService service;
    @Autowired
    private IKeyanProjectService keyanProjectService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<KeyanWorkSureVO> saveOrUpdate(@RequestBody KeyanWorkSureVO saveOrUpdateVO) {
        KeyanWorkSureEntity entity = (KeyanWorkSureEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KeyanWorkSureEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        KeyanWorkSureVO vo = (KeyanWorkSureVO)((Object)BeanMapper.map((Object)((Object)entity), KeyanWorkSureVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KeyanWorkSureVO> queryDetail(Long id) {
        KeyanWorkSureEntity entity = (KeyanWorkSureEntity)((Object)this.service.selectById(id));
        KeyanWorkSureVO vo = (KeyanWorkSureVO)((Object)BeanMapper.map((Object)((Object)entity), KeyanWorkSureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KeyanWorkSureVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<KeyanWorkSureVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fillUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("unitId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KeyanWorkSureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/downTemplateUrl"})
    @ResponseBody
    public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"sq/keyanWorkSure-import.xlsx", (String)"\u5176\u4ed6\u6a21\u677f");
    }

    @RequestMapping(value={"/importCheckData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> importCheckData(HttpServletRequest request, HttpServletResponse response) {
        ImportCommonUtil importUtil = new ImportCommonUtil();
        importUtil.setDataStartLine(2);
        LinkedList<String> fileds = new LinkedList<String>();
        fileds.addAll(Arrays.asList("projectName", "fillUserName", "fillDate", "remarks"));
        importUtil.setFileds(fileds);
        LinkedList<String> filedsName = new LinkedList<String>();
        filedsName.addAll(Arrays.asList("\u9879\u76ee", "\u586b\u62a5\u4eba", "\u586b\u62a5\u65f6\u95f4", "\u5907\u6ce8"));
        importUtil.setFiledsName(filedsName);
        importUtil.setRequest(request);
        HashMap<String, JSONObject> filedsConfig = new HashMap<String, JSONObject>();
        JSONObject projectNameConfig = new JSONObject();
        projectNameConfig.put("keyanProject", (Object)"keyanProject");
        JSONObject projectNameMath = new JSONObject();
        projectNameMath.put("projectId", (Object)"id");
        projectNameMath.put("unitId", (Object)"bearUnitId");
        projectNameMath.put("unitName", (Object)"bearUnitName");
        projectNameConfig.put("fieldMath", (Object)projectNameMath);
        filedsConfig.put("projectName", projectNameConfig);
        JSONObject fillUserNameConfig = new JSONObject();
        fillUserNameConfig.put("user", (Object)"user");
        JSONObject fillUserNameMath = new JSONObject();
        fillUserNameMath.put("fillUserId", (Object)"id");
        fillUserNameConfig.put("fieldMath", (Object)fillUserNameMath);
        filedsConfig.put("fillUserName", fillUserNameConfig);
        importUtil.setFiledsConfig(filedsConfig);
        importUtil.setFiledsConfig(filedsConfig);
        importUtil.setVoName("com.ejianc.business.sq.keyan.vo.KeyanWorkSureVO");
        importUtil.setServiceName("keyanWorkSureService");
        ArrayList<String> requiredFields = new ArrayList<String>();
        requiredFields.addAll(Arrays.asList("projectName", "fillUserName", "fillDate"));
        importUtil.setRequiredFields(requiredFields);
        importUtil.setEmployeeApi(this.employeeApi);
        importUtil.setKeyanProjectService(this.keyanProjectService);
        importUtil.setiOrgApi(this.iOrgApi);
        JSONObject json = importUtil.importCheckData();
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/importDataSave"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> importDataSave(@RequestBody List<KeyanWorkSureVO> vos) {
        ArrayList<KeyanWorkSureEntity> entitys;
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid(), vos.size());
        if (billCode.isSuccess() && ((List)billCode.getData()).size() == vos.size()) {
            entitys = new ArrayList<KeyanWorkSureEntity>();
            for (int i = 0; i < vos.size(); ++i) {
                KeyanWorkSureEntity entity = (KeyanWorkSureEntity)((Object)BeanMapper.map((Object)((Object)vos.get(i)), KeyanWorkSureEntity.class));
                entity.setBillCode((String)((List)billCode.getData()).get(i));
                entitys.add(entity);
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdateBatch(entitys, entitys.size(), false);
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fillUserName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("unitId", new Parameter("in", commonOrgIds));
        }
        List list = this.service.queryList(param);
        List result = new ArrayList();
        if (list != null && list.size() > 0) {
            result = BeanMapper.mapList((Iterable)list, KeyanWorkSureVO.class);
        }
        HashMap beans = new HashMap();
        beans.put("records", result);
        ExcelExport.getInstance().exportWithTrans("sq/keyanWorkSure-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refKeyanWorkSureData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<KeyanWorkSureVO>> refKeyanWorkSureData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KeyanWorkSureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

