package com.ejianc.business.sq.keyan.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sq.keyan.bean.*;
import com.ejianc.business.sq.keyan.service.IKeyanProjectChangeService;
import com.ejianc.business.sq.keyan.service.IKeyanProjectDetailService;
import com.ejianc.business.sq.keyan.service.IKeyanProjectRecordService;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("keyanProjectChange") 
public class KeyanProjectChangeBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IKeyanProjectChangeService changeService;
	@Autowired
	private IKeyanProjectService keyanProjectService;
	@Autowired
	private IKeyanProjectDetailService detailService;
	@Autowired
	private IKeyanProjectRecordService recordService;
	@Autowired
	private IAttachmentApi attachmentApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		KeyanProjectChangeEntity changeEntity = changeService.selectById(billId);

		KeyanProjectEntity newEntity = null;
		KeyanProjectEntity entity = keyanProjectService.selectById(changeEntity.getOldMainId());

		//1、复制合同信息到合同记录
		KeyanProjectRecordEntity recordEntity = BeanMapper.map(entity, KeyanProjectRecordEntity.class);
		//设置合同Id
		recordEntity.setOldMainId(entity.getId());
		//Id置为空
		recordEntity.setId(null);
		if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
			recordEntity.getDetailList().stream().forEach(detail -> {
				detail.setOldDetailId(detail.getId());
				detail.setId(null);
			});
		}

		//设置编制人等信息
		recordEntity.setCreateUserCode(changeEntity.getCreateUserCode());
		recordEntity.setCreateTime(changeEntity.getCreateTime());
		recordEntity.setUpdateTime(changeEntity.getUpdateTime());
		recordEntity.setUpdateUserCode(changeEntity.getUpdateUserCode());
		//合同变更记录保存
		if (recordService.saveOrUpdate(recordEntity, false)) {
			Long recordEntityId = recordEntity.getId();
			Long oldEntityId = recordEntity.getOldMainId();
			//将原合同附件复制到历史记录
			attachmentApi.copyFiles(String.valueOf(oldEntityId),"EJCBT202412000003","projectProposal",
					String.valueOf(recordEntityId), "EJCBT202505000002","projectProposal",true);
			attachmentApi.copyFiles(String.valueOf(oldEntityId),"EJCBT202412000003","feasibleReport",
					String.valueOf(recordEntityId), "EJCBT202505000002","feasibleReport",true);
			attachmentApi.copyFiles(String.valueOf(oldEntityId),"EJCBT202412000003","budgetSheet",
					String.valueOf(recordEntityId), "EJCBT202505000002","budgetSheet",true);
			attachmentApi.copyFiles(String.valueOf(oldEntityId),"EJCBT202412000003","internalArgumentationOpinion",
					String.valueOf(recordEntityId), "EJCBT202505000002","internalArgumentationOpinion",true);
		}


		//修改合同字段
		newEntity = BeanMapper.map(changeEntity, KeyanProjectEntity.class);
		//变更状态-已变更
		newEntity.setChangeState(3);
		//冗余变更单审批状态清空
		newEntity.setId(entity.getId());
		newEntity.setVersion(entity.getVersion());
		//合同初始创建信息
		newEntity.setCreateUserCode(entity.getCreateUserCode());
		newEntity.setCreateTime(entity.getCreateTime());

		List<Long> delIds = new ArrayList();
		if (CollectionUtils.isNotEmpty(entity.getDetailList())){
			delIds=entity.getDetailList().stream().map(KeyanProjectDetailEntity::getId).collect(Collectors.toList());
		}
		if (CollectionUtils.isNotEmpty(newEntity.getDetailList())) {
			for (KeyanProjectDetailChangeEntity item : changeEntity.getDetailList()) {
				item.setId(item.getOldDetailId());
				item.setPid(entity.getId());
				delIds.remove(item.getOldDetailId());
			};
			newEntity.setDetailList(BeanMapper.mapList(changeEntity.getDetailList(), KeyanProjectDetailEntity.class));
		}

		//删除已有子表
		if (CollectionUtils.isNotEmpty(delIds)){
			detailService.removeByIds(delIds);
		}

		if (keyanProjectService.saveOrUpdate(newEntity, false)) {
			//变更合同附件复制到主合同
			attachmentApi.copyFiles(String.valueOf(billId),"EJCBT202505000001","projectProposal",
					String.valueOf(newEntity.getId()), "EJCBT202412000003","projectProposal",true);
			attachmentApi.copyFiles(String.valueOf(billId),"EJCBT202505000001","feasibleReport",
					String.valueOf(newEntity.getId()), "EJCBT202412000003","feasibleReport",true);
			attachmentApi.copyFiles(String.valueOf(billId),"EJCBT202505000001","budgetSheet",
					String.valueOf(newEntity.getId()), "EJCBT202412000003","budgetSheet",true);
			attachmentApi.copyFiles(String.valueOf(billId),"EJCBT202505000001","internalArgumentationOpinion",
					String.valueOf(newEntity.getId()), "EJCBT202412000003","internalArgumentationOpinion",true);
			return CommonResponse.success("回调业务处理成功！");
			}
				return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
