package com.ejianc.business.zyscene.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zyscene.bean.SceneQualityCheckCategoryEntity;
import com.ejianc.business.zyscene.mapper.SceneQualityCheckCategoryMapper;
import com.ejianc.business.zyscene.service.ISceneQualityCheckCategoryService;
import com.ejianc.business.zyscene.vo.SceneQualityCheckCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 资源管理-质量检查分类实体
 * 
 * @author generator
 * 
 */
@Service("sceneQualityCheckCategoryService")
public class SceneQualityCheckCategoryServiceImpl extends BaseServiceImpl<SceneQualityCheckCategoryMapper, SceneQualityCheckCategoryEntity> implements ISceneQualityCheckCategoryService {

    @Autowired
    private SceneQualityCheckCategoryMapper mapper;

    @Override
    public SceneQualityCheckCategoryEntity queryByCode(String code) {
        QueryWrapper<SceneQualityCheckCategoryEntity> query = new QueryWrapper<>();
        query.eq("code", code);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.getOne(query);
    }

    @Override
    public List<SceneQualityCheckCategoryEntity> queryListByPid(List<Long> ids) {
        QueryWrapper<SceneQualityCheckCategoryEntity> query = new QueryWrapper<>();
        query.in("parent_id", ids);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<SceneQualityCheckCategoryEntity> queryByCodes(ArrayList<String> codes) {
        QueryWrapper<SceneQualityCheckCategoryEntity> query = new QueryWrapper<>();
        query.in("code", codes);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.list(query);
    }

    @Override
    public List<SceneQualityCheckCategoryVO> queryAllByPid(Long pid) {
        List<SceneQualityCheckCategoryVO> resp = new ArrayList<>();
        SceneQualityCheckCategoryEntity entity = super.selectById(pid);

        QueryWrapper<SceneQualityCheckCategoryEntity> query = new QueryWrapper<>();
        query.likeRight("inner_code", entity.getInnerCode());
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<SceneQualityCheckCategoryEntity> dataList = super.list(query);

        if(CollectionUtils.isNotEmpty(dataList)) {
            resp = BeanMapper.mapList(dataList, SceneQualityCheckCategoryVO.class);
        }
        return resp;
    }

    @Override
    public List<SceneQualityCheckCategoryVO> queryList(Map<String, Object> condition) {
        return mapper.queryList(condition);
    }
}