package com.ejianc.business.zyscene.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 检查单主表
 * 
 * @author generator
 * 
 */
@ApiModel("检查单主表")
public class SceneCheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("项目id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("组织名")
    private String orgName;
    @ApiModelProperty("检查名称")
    private String checkName;
    @ApiModelProperty("检查类型")
    private Long checkType;
    @ApiModelProperty("检查类型名称")
    private String checkTypeName;
    private Integer checkAttr; // 检查属性
    private String checkAttrName;
    private Integer checkLevel; // 检查级别1项目2公司
    @ApiModelProperty("检查人id")
    private String checkId;
    @ApiModelProperty("检查人")
    private String checkPerson;
    @ApiModelProperty("检查日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date checkDate;
    @ApiModelProperty("整改完成日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reformFinishDate;
    @ApiModelProperty("要求完成日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date finishDate;
    @ApiModelProperty("整改责任人id")
    private String reformDutyId;
    @ApiModelProperty("整改责任人")
    private String reformDutyPerson;
    @ApiModelProperty("整改次数")
    private Integer reformNumber;
    @ApiModelProperty("复查人id")
    private String reviewId;
    @ApiModelProperty("复查人")
    private String reviewPerson;
    @ApiModelProperty("复查项")
    private Integer reviewItem;
    @ApiModelProperty("整改状态")
    private Integer reformStatus;
    @ApiModelProperty("已复查数量")
    private Integer reviewedNum;
    @ApiModelProperty("已完成")
    private Integer reviewPass;
    @ApiModelProperty("通知相关人员id")
    private String notifRelevantId;
    @ApiModelProperty("通知相关人员")
    private String notifRelevantPerson;
    @ApiModelProperty("复查状态：0-自由态，1-已提交")
    private Integer reviewStatus;
    @ApiModelProperty("逾期数量")
    private Integer overdueNum;
    @ApiModelProperty("备注")
    private String remarks;
    @ApiModelProperty("单据状态：0自由态，1已提交")
    private Integer billState;
    @ApiModelProperty("整改名称")
    private String reformName;

    @ApiModelProperty("检查单待检复检子表")
    private List<SceneCheckDetailVO> sceneCheckDetails = new ArrayList<>();

    @ApiModelProperty("发送消息时用到的数量")
    private Integer msgNum;
    @ApiModelProperty("发送消息时用到的ID")
    private Long msgId;
    @ApiModelProperty("发送消息时用到的billCode")
    private String msgBillCode;

    private String checkLevelName;

    public String getCheckLevelName() {
        return checkLevelName;
    }

    public void setCheckLevelName(String checkLevelName) {
        this.checkLevelName = checkLevelName;
    }

    public Integer getCheckAttr() {
        return checkAttr;
    }

    public void setCheckAttr(Integer checkAttr) {
        this.checkAttr = checkAttr;
    }

    public String getCheckAttrName() {
        return checkAttrName;
    }

    public void setCheckAttrName(String checkAttrName) {
        this.checkAttrName = checkAttrName;
    }

    public Integer getCheckLevel() {
        return checkLevel;
    }

    public void setCheckLevel(Integer checkLevel) {
        this.checkLevel = checkLevel;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 检查名称
     */
    public String getCheckName() {
        return checkName;
    }

    /**
     * 检查名称
     */
    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCheckType() {
        return checkType;
    }
    @ReferDeserialTransfer
    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }

    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    /**
     * 检查人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public String getCheckId() {
        return checkId;
    }

    /**
     * 检查人id
     */
    @ReferDeserialTransfer
    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }
    /**
     * 检查人
     */
    public String getCheckPerson() {
        return checkPerson;
    }

    /**
     * 检查人
     */
    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }
    /**
     * 检查日期
     */
    public java.util.Date getCheckDate() {
        return checkDate;
    }

    /**
     * 检查日期
     */
    public void setCheckDate(java.util.Date checkDate) {
        this.checkDate = checkDate;
    }
    /**
     * 整改完成日期
     */
    public java.util.Date getReformFinishDate() {
        return reformFinishDate;
    }

    /**
     * 整改完成日期
     */
    public void setReformFinishDate(java.util.Date reformFinishDate) {
        this.reformFinishDate = reformFinishDate;
    }
    /**
     * 要求完成日期
     */
    public java.util.Date getFinishDate() {
        return finishDate;
    }

    /**
     * 要求完成日期
     */
    public void setFinishDate(java.util.Date finishDate) {
        this.finishDate = finishDate;
    }
    /**
     * 整改责任人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public String getReformDutyId() {
        return reformDutyId;
    }

    /**
     * 整改责任人id
     */
    @ReferDeserialTransfer
    public void setReformDutyId(String reformDutyId) {
        this.reformDutyId = reformDutyId;
    }
    /**
     * 整改责任人
     */
    public String getReformDutyPerson() {
        return reformDutyPerson;
    }

    /**
     * 整改责任人
     */
    public void setReformDutyPerson(String reformDutyPerson) {
        this.reformDutyPerson = reformDutyPerson;
    }
    /**
     * 整改次数
     */
    public Integer getReformNumber() {
        return reformNumber;
    }

    /**
     * 整改次数
     */
    public void setReformNumber(Integer reformNumber) {
        this.reformNumber = reformNumber;
    }
    /**
     * 复查人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public String getReviewId() {
        return reviewId;
    }

    /**
     * 复查人id
     */
    @ReferDeserialTransfer
    public void setReviewId(String reviewId) {
        this.reviewId = reviewId;
    }
    /**
     * 复查人
     */
    public String getReviewPerson() {
        return reviewPerson;
    }

    /**
     * 复查人
     */
    public void setReviewPerson(String reviewPerson) {
        this.reviewPerson = reviewPerson;
    }
    /**
     * 复查项
     */
    public Integer getReviewItem() {
        return reviewItem;
    }

    /**
     * 复查项
     */
    public void setReviewItem(Integer reviewItem) {
        this.reviewItem = reviewItem;
    }
    /**
     * 整改状态
     */
    public Integer getReformStatus() {
        return reformStatus;
    }
    /**
     * 整改状态
     */
    public void setReformStatus(Integer reformStatus) {
        this.reformStatus = reformStatus;
    }

    /**
     * 已复查数量
     */
    public Integer getReviewedNum() {
        return reviewedNum;
    }

    /**
     * 已复查数量
     */
    public void setReviewedNum(Integer reviewedNum) {
        this.reviewedNum = reviewedNum;
    }
    /**
     * 已复查合格数量
     */
    public Integer getReviewPass() {
        return reviewPass;
    }
    /**
     * 已复查合格数量
     */
    public void setReviewPass(Integer reviewPass) {
        this.reviewPass = reviewPass;
    }

    /**
     * 通知相关人员id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public String getNotifRelevantId() {
        return notifRelevantId;
    }

    /**
     * 通知相关人员id
     */
    @ReferDeserialTransfer
    public void setNotifRelevantId(String notifRelevantId) {
        this.notifRelevantId = notifRelevantId;
    }
    /**
     * 通知相关人员
     */
    public String getNotifRelevantPerson() {
        return notifRelevantPerson;
    }

    /**
     * 通知相关人员
     */
    public void setNotifRelevantPerson(String notifRelevantPerson) {
        this.notifRelevantPerson = notifRelevantPerson;
    }
    /**
     * 复查状态：0-自由态，1-已提交
     */
    public Integer getReviewStatus() {
        return reviewStatus;
    }

    /**
     * 复查状态：0-自由态，1-已提交
     */
    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }
    /**
     * 逾期数量
     */
    public Integer getOverdueNum() {
        return overdueNum;
    }

    /**
     * 逾期数量
     */
    public void setOverdueNum(Integer overdueNum) {
        this.overdueNum = overdueNum;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    /**
     * 检查单待检复检子表
     */
    public List<SceneCheckDetailVO> getSceneCheckDetails() {
        return sceneCheckDetails;
    }
    /**
     * 检查单待检复检子表
     */
    public void setSceneCheckDetails(List<SceneCheckDetailVO> sceneCheckDetails) {
        this.sceneCheckDetails = sceneCheckDetails;
    }
    /**
     * 整改名称
     */
    public String getReformName() {
        return reformName;
    }
    /**
     * 整改名称
     */
    public void setReformName(String reformName) {
        this.reformName = reformName;
    }

    public Integer getMsgNum() {
        return msgNum;
    }

    public void setMsgNum(Integer msgNum) {
        this.msgNum = msgNum;
    }

    public Long getMsgId() {
        return msgId;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public String getMsgBillCode() {
        return msgBillCode;
    }

    public void setMsgBillCode(String msgBillCode) {
        this.msgBillCode = msgBillCode;
    }

}
