/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zyscene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zyscene.bean.SceneQualityCheckCategoryEntity;
import com.ejianc.business.zyscene.service.ISceneQualityCheckCategoryService;
import com.ejianc.business.zyscene.service.ISceneQualityCheckItemService;
import com.ejianc.business.zyscene.vo.SceneQualityCheckCategoryVO;
import com.ejianc.business.zyscene.vo.SceneQualityCheckItemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"sceneQualityCheckCategory"})
public class SceneQualityCheckCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZY_SCENE_QUALITY_CHECK_CATEGORY";
    @Autowired
    private ISceneQualityCheckCategoryService service;
    @Autowired
    private ISceneQualityCheckItemService qualityCheckItemService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<SceneQualityCheckCategoryVO> saveOrUpdate(@RequestBody SceneQualityCheckCategoryVO saveOrUpdateVO) {
        SceneQualityCheckCategoryEntity codeData;
        SceneQualityCheckCategoryEntity entity = null;
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0L) {
            saveOrUpdateVO.setId(IdWorker.getId());
            entity = (SceneQualityCheckCategoryEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), SceneQualityCheckCategoryEntity.class));
            if (StringUtils.isBlank((CharSequence)saveOrUpdateVO.getCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) return CommonResponse.success((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setCode((String)billCode.getData());
            } else {
                codeData = this.service.queryByCode(saveOrUpdateVO.getCode());
                if (codeData != null) {
                    return CommonResponse.error((String)"\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
                }
            }
            if (null == saveOrUpdateVO.getEnabled()) {
                entity.setEnabled(1);
            }
            if (null != saveOrUpdateVO.getParentId()) {
                SceneQualityCheckCategoryEntity parent = (SceneQualityCheckCategoryEntity)((Object)this.service.selectById(saveOrUpdateVO.getParentId()));
                entity.setInnerCode(parent.getInnerCode() + "|" + saveOrUpdateVO.getId());
            } else {
                entity.setInnerCode(saveOrUpdateVO.getId().toString());
            }
        } else {
            codeData = this.service.queryByCode(saveOrUpdateVO.getCode());
            if (codeData != null && !codeData.getId().equals(saveOrUpdateVO.getId())) {
                return CommonResponse.error((String)"\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
            }
            entity = (SceneQualityCheckCategoryEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
            entity.setEnabled(saveOrUpdateVO.getEnabled());
            entity.setCode(saveOrUpdateVO.getCode());
            entity.setName(saveOrUpdateVO.getName());
            entity.setDescription(saveOrUpdateVO.getDescription());
            entity.setSequence(saveOrUpdateVO.getSequence());
        }
        this.service.saveOrUpdate((Object)entity, false);
        SceneQualityCheckCategoryVO vo = (SceneQualityCheckCategoryVO)((Object)BeanMapper.map((Object)((Object)entity), SceneQualityCheckCategoryVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<SceneQualityCheckCategoryVO> queryDetail(Long id) {
        SceneQualityCheckCategoryEntity entity = (SceneQualityCheckCategoryEntity)((Object)this.service.selectById(id));
        SceneQualityCheckCategoryVO vo = (SceneQualityCheckCategoryVO)((Object)BeanMapper.map((Object)((Object)entity), SceneQualityCheckCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            List childIds;
            List<SceneQualityCheckItemVO> materialList = this.qualityCheckItemService.queryListByCategoryId(ids);
            if (CollectionUtils.isNotEmpty(materialList)) {
                Set categoryNames = materialList.stream().map(SceneQualityCheckItemVO::getCategoryName).collect(Collectors.toSet());
                return CommonResponse.error((String)("\u5206\u7c7b\u3010" + StringUtils.join(categoryNames, (String)",") + "\u3011\u4e0b\u68c0\u67e5\u9879\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
            }
            List<SceneQualityCheckCategoryEntity> children = this.service.queryListByPid(ids);
            if (CollectionUtils.isNotEmpty(children) && CollectionUtils.isNotEmpty(childIds = children.stream().filter(item -> !ids.contains(item.getId())).collect(Collectors.toList()))) {
                return CommonResponse.error((String)"\u5f85\u5220\u9664\u5206\u7c7b\u4e0b\u6709\u5b50\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            this.service.removeByIds(ids, true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : param.getParams().entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<SceneQualityCheckCategoryVO> dataList = this.service.queryList(condition);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("leafFlag").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/updateEnabledStatus"}, method={RequestMethod.POST})
    public CommonResponse<String> updateEnabled(@RequestBody SceneQualityCheckCategoryVO saveOrUpdateVO) {
        SceneQualityCheckCategoryEntity dbEntity = (SceneQualityCheckCategoryEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        dbEntity.setEnabled(saveOrUpdateVO.getEnabled());
        this.service.saveOrUpdate((Object)dbEntity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/lazyCategoryTree"})
    public List<Map<String, Object>> lazyCategoryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            params.put("searchText", searchText);
        }
        if (null != pid) {
            params.put("parentId", pid);
        }
        List<SceneQualityCheckCategoryVO> dataList = this.service.queryList(params);
        List parentIds = dataList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List map = BeanMapper.mapList(dataList, Map.class);
        map.forEach(l -> {
            if (l.get("leafFlag").equals(false)) {
                l.put("children", new ArrayList());
            } else {
                l.put("children", null);
            }
        });
        if (null != pid && parentIds.size() > 0) {
            params.remove("parentId");
            params.put("parentIds", parentIds);
            List<SceneQualityCheckCategoryVO> dataLists = this.service.queryList(params);
            List map2 = BeanMapper.mapList(dataLists, Map.class);
            map.addAll(map2);
        }
        return ResultAsTree.createTreeData((List)map);
    }

    @RequestMapping(value={"/download"})
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"quality-check-category-import.xlsx", (String)"\u8d28\u91cf\u68c0\u67e5\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelImport"})
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<SceneQualityCheckCategoryVO> successList = new ArrayList<SceneQualityCheckCategoryVO>();
        ArrayList<SceneQualityCheckCategoryVO> processList = new ArrayList<SceneQualityCheckCategoryVO>();
        ArrayList<SceneQualityCheckCategoryVO> errorList = new ArrayList<SceneQualityCheckCategoryVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, SceneQualityCheckCategoryVO> codeMapCache = new HashMap<String, SceneQualityCheckCategoryVO>();
            SceneQualityCheckCategoryVO importVo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                importVo = new SceneQualityCheckCategoryVO();
                importVo.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                importVo.setCode((String)datas.get(0));
                importVo.setParentCode((String)datas.get(1));
                importVo.setName((String)datas.get(2));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    importVo.setDescription("\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(importVo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    importVo.setDescription("\u5206\u7c7b\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(importVo);
                    continue;
                }
                if (codeMapCache.containsKey(importVo.getCode())) {
                    importVo.setDescription("\u5206\u7c7b\u540d\u79f0\u91cd\u590d\uff01");
                    errorList.add(importVo);
                    continue;
                }
                importVo.setId(IdWorker.getId());
                importVo.setEnabled(1);
                importVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                importVo.setCreateTime(new Date());
                importVo.setTenantId(InvocationInfoProxy.getTenantid());
                processList.add(importVo);
                codeMapCache.put(importVo.getCode(), importVo);
            }
            if (ListUtil.isNotEmpty(processList)) {
                List<SceneQualityCheckCategoryEntity> parentListByCode;
                List<SceneQualityCheckCategoryEntity> codeList = this.service.queryByCodes(new ArrayList<String>(codeMapCache.keySet()));
                Set pCodes = processList.stream().map(SceneQualityCheckCategoryVO::getParentCode).collect(Collectors.toSet());
                Map<Object, Object> parentCodeMap = new HashMap();
                if (CollectionUtils.isNotEmpty(pCodes) && CollectionUtils.isNotEmpty(parentListByCode = this.service.queryByCodes(new ArrayList<String>(pCodes)))) {
                    parentCodeMap = parentListByCode.stream().collect(Collectors.toMap(SceneQualityCheckCategoryEntity::getCode, item -> item));
                }
                if (CollectionUtils.isNotEmpty(codeList)) {
                    for (SceneQualityCheckCategoryEntity repeatCode : codeList) {
                        importVo = (SceneQualityCheckCategoryVO)((Object)codeMapCache.get(repeatCode.getCode()));
                        codeMapCache.remove(repeatCode.getCode());
                        processList.remove((Object)importVo);
                        importVo.setDescription("\u5206\u7c7b\u540d\u79f0\u91cd\u590d\uff01");
                        errorList.add(importVo);
                    }
                }
                for (SceneQualityCheckCategoryVO item2 : processList) {
                    if (StringUtils.isNotBlank((CharSequence)item2.getParentCode())) {
                        if (parentCodeMap.containsKey(item2.getParentCode())) {
                            item2.setInnerCode(((SceneQualityCheckCategoryEntity)((Object)parentCodeMap.get(item2.getParentCode()))).getInnerCode() + "|" + item2.getId());
                            item2.setParentId(((SceneQualityCheckCategoryEntity)((Object)parentCodeMap.get(item2.getParentCode()))).getId());
                        } else if (codeMapCache.containsKey(item2.getParentCode())) {
                            item2.setInnerCode(((SceneQualityCheckCategoryVO)((Object)codeMapCache.get(item2.getParentCode()))).getInnerCode() + "|" + item2.getId());
                            item2.setParentId(((SceneQualityCheckCategoryVO)((Object)codeMapCache.get(item2.getParentCode()))).getId());
                        }
                        if (null == item2.getParentId()) {
                            item2.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u5bf9\u5e94\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
                            errorList.add(importVo);
                            continue;
                        }
                    } else {
                        item2.setInnerCode(item2.getId().toString());
                    }
                    successList.add(item2);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/saveImportExcelCategory"})
    public CommonResponse<String> saveImportExcelCategory(@RequestBody List<SceneQualityCheckCategoryVO> saveImportVos) {
        if (ListUtil.isEmpty(saveImportVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List saveList = BeanMapper.mapList(saveImportVos, SceneQualityCheckCategoryEntity.class);
        this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

