package com.ejianc.business.sq.keyan.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.sq.keyan.bean.KeyanProjectDetailChangeEntity;
import com.ejianc.business.sq.keyan.bean.KeyanProjectEntity;
import com.ejianc.business.sq.keyan.bean.KeyanProjectRecordEntity;
import com.ejianc.business.sq.keyan.service.IKeyanProjectRecordService;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sq.keyan.bean.KeyanProjectChangeEntity;
import com.ejianc.business.sq.keyan.service.IKeyanProjectChangeService;
import com.ejianc.business.sq.keyan.vo.KeyanProjectChangeVO;

/**
 * 在研项目立项变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sq/keyan/projectChange")
public class KeyanProjectChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zydxKeyanProject";//此处需要根据实际修改

    @Autowired
    private IKeyanProjectChangeService service;
    @Autowired
    private IKeyanProjectService keyanProjectService;
    @Autowired
    private IKeyanProjectRecordService keyanProjectRecordService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KeyanProjectChangeVO> saveOrUpdate(@RequestBody KeyanProjectChangeVO changeVO) {
        int count = 0;

        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<KeyanProjectChangeEntity> lambdachange = Wrappers.<KeyanProjectChangeEntity>lambdaQuery();
        lambdachange.eq(KeyanProjectChangeEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(KeyanProjectChangeEntity::getOldMainId,changeVO.getOldMainId());
        if(changeVO.getId() != null && changeVO.getId() > 0) {
            lambdachange.ne(KeyanProjectChangeEntity::getId,changeVO.getId());
        }
        lambdachange.ne(KeyanProjectChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(KeyanProjectChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = service.count(lambdachange);
        if(num>0){
            throw new BusinessException("该已存在未生效的变更单!");
        }
        if(StringUtils.isEmpty(changeVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                changeVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        KeyanProjectChangeEntity changeEntity = BeanMapper.map(changeVO, KeyanProjectChangeEntity.class);
        //保存前清空主键和父主键，重新生成
        List<KeyanProjectDetailChangeEntity> beforeDetails = changeEntity.getDetailList();
        if((CollectionUtils.isNotEmpty(beforeDetails) && null == changeEntity.getId())||(CollectionUtils.isNotEmpty(beforeDetails) && service.getById(changeVO.getId())==null)){
            for(KeyanProjectDetailChangeEntity cdEntity : beforeDetails){
                cdEntity.setId(null);
            }
        }
        service.saveOrUpdate(changeEntity, false);
        saveWrite(changeEntity);
    	return CommonResponse.success("保存或修改单据成功！",BeanMapper.map(changeEntity, KeyanProjectChangeVO.class));
    }
    /**
     * 保存回写合同
     * @param changeEntity
     */
    private void saveWrite(KeyanProjectChangeEntity changeEntity){
        LambdaUpdateWrapper<KeyanProjectEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(KeyanProjectEntity::getChangeId, changeEntity.getId());
        updateWrapper.set(KeyanProjectEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(KeyanProjectEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(KeyanProjectEntity::getChangeState, 2);
        updateWrapper.eq(KeyanProjectEntity::getId, changeEntity.getOldMainId());
        keyanProjectService.update(keyanProjectService.selectById(changeEntity.getOldMainId()), updateWrapper, false);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KeyanProjectChangeVO> queryDetail(Long id) {
    	KeyanProjectChangeEntity entity = service.selectById(id);
    	KeyanProjectChangeVO vo = BeanMapper.map(entity, KeyanProjectChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    //查询变更前数据
    @RequestMapping(value = "/addConvertByMainId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KeyanProjectChangeVO> addConvertByMainId(Long mainId) {
        KeyanProjectChangeVO vo = service.addConvertByMainId(mainId);
        return CommonResponse.success("新增转换数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KeyanProjectChangeVO> vos) {
        ArrayList ids = new ArrayList();
        if(ListUtil.isNotEmpty(vos)){
            for (KeyanProjectChangeVO vo : vos) {
                KeyanProjectChangeEntity e = service.selectById(vo.getId());
                if (
                        !BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(e.getBillState())
                                && !BillStateEnum.UNAPPROVED.getBillStateCode().equals(e.getBillState())

                ) {
                    throw new BusinessException("删除失败，只能删除自由态/审批驳回的变更数据！");
                }
                Integer changeState = 1;
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("old_main_id", new Parameter(QueryParam.EQ, vo.getOldMainId()));
                List<KeyanProjectRecordEntity> changeRecords = keyanProjectRecordService.queryList(queryParam, false);
                if (CollectionUtils.isNotEmpty(changeRecords)) {
                    changeState = 3;
                }

                KeyanProjectEntity entity = keyanProjectService.selectById(e.getOldMainId());
                entity.setChangeState(changeState);
                entity.setChangeId(null);
                entity.setChangeCode(null);
                entity.setChangeVersion(entity.getChangeVersion()-1);

                keyanProjectService.saveOrUpdate(entity, false);
                ids.add(vo.getId());
            }
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KeyanProjectChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<KeyanProjectChangeEntity> page = service.queryPage(param,false);
        IPage<KeyanProjectChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), KeyanProjectChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<KeyanProjectChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("KeyanProjectChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refKeyanProjectChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<KeyanProjectChangeVO>> refKeyanProjectChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<KeyanProjectChangeEntity> page = service.queryPage(param,false);
        IPage<KeyanProjectChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KeyanProjectChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
