package com.ejianc.business.prjdocs.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 投入资源需求计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prjdocs_invest_resource_require_plan")
public class PrjInvestResourceRequirePlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="org_id")
    private Long orgId; // 所属单位id
    @TableField(value="org_name")
    private String orgName; // 所属单位名称
    @TableField(value="contract_amount")
    private BigDecimal contractAmount; // 合同金额
    @TableField(value="project_start_date")
    private Date projectStartDate; // 项目开始时间
    @TableField(value="project_end_date")
    private Date projectEndDate; // 项目结束时间
    @TableField(value="project_area")
    private String projectArea; // 项目地点
    @TableField(value="work_content")
    private String workContent; // 工作内容
    @TableField(value="workload")
    private String workload; // 工作量
    @TableField(value="person_salary")
    private BigDecimal personSalary; // 人员工资
    @TableField(value="bonus")
    private BigDecimal bonus; // 奖金
    @TableField(value="business_travel")
    private BigDecimal businessTravel; // 差旅应酬
    @TableField(value="project_material")
    private BigDecimal projectMaterial; // 项目材料
    @TableField(value="other_expense")
    private BigDecimal otherExpense; // 其他费用
    @TableField(value="total_cost")
    private BigDecimal totalCost; // 总费用

    @TableField(exist=false)
    @SubEntity(serviceName="prjInvestResourceRequirePlanPersonService", pidName="pid")
    private List<PrjInvestResourceRequirePlanPersonEntity> personList = new ArrayList<>(); // 投入资源需求计划--人员计划
    @TableField(exist=false)
    @SubEntity(serviceName="prjInvestResourceRequirePlanEquipmentService", pidName="pid")
    private List<PrjInvestResourceRequirePlanEquipmentEntity> equipmentList = new ArrayList<>(); // 投入资源需求计划--设备计划

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }
    public Date getProjectEndDate() {
        return projectEndDate;
    }

    public void setProjectEndDate(Date projectEndDate) {
        this.projectEndDate = projectEndDate;
    }
    public String getProjectArea() {
        return projectArea;
    }

    public void setProjectArea(String projectArea) {
        this.projectArea = projectArea;
    }
    public String getWorkContent() {
        return workContent;
    }

    public void setWorkContent(String workContent) {
        this.workContent = workContent;
    }
    public String getWorkload() {
        return workload;
    }

    public void setWorkload(String workload) {
        this.workload = workload;
    }
    public BigDecimal getPersonSalary() {
        return personSalary;
    }

    public void setPersonSalary(BigDecimal personSalary) {
        this.personSalary = personSalary;
    }
    public BigDecimal getBonus() {
        return bonus;
    }

    public void setBonus(BigDecimal bonus) {
        this.bonus = bonus;
    }
    public BigDecimal getBusinessTravel() {
        return businessTravel;
    }

    public void setBusinessTravel(BigDecimal businessTravel) {
        this.businessTravel = businessTravel;
    }
    public BigDecimal getProjectMaterial() {
        return projectMaterial;
    }

    public void setProjectMaterial(BigDecimal projectMaterial) {
        this.projectMaterial = projectMaterial;
    }
    public BigDecimal getOtherExpense() {
        return otherExpense;
    }

    public void setOtherExpense(BigDecimal otherExpense) {
        this.otherExpense = otherExpense;
    }
    public BigDecimal getTotalCost() {
        return totalCost;
    }

    public void setTotalCost(BigDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public List<PrjInvestResourceRequirePlanPersonEntity> getPersonList() {
        return personList;
    }

    public void setPersonList(List<PrjInvestResourceRequirePlanPersonEntity> personList) {
        this.personList = personList;
    }

    public List<PrjInvestResourceRequirePlanEquipmentEntity> getEquipmentList() {
        return equipmentList;
    }

    public void setEquipmentList(List<PrjInvestResourceRequirePlanEquipmentEntity> equipmentList) {
        this.equipmentList = equipmentList;
    }
}
