package com.ejianc.business.zyscene.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zyscene.bean.SceneCheckDetailEntity;
import com.ejianc.business.zyscene.bean.SceneCheckEntity;
import com.ejianc.business.zyscene.service.ISceneCheckDetailService;
import com.ejianc.business.zyscene.service.ISceneCheckService;
import com.ejianc.business.zyscene.util.ReformState;
import com.ejianc.business.zyscene.vo.SceneCheckDetailVO;
import com.ejianc.business.zyscene.vo.SceneCheckStatisticsVO;
import com.ejianc.business.zyscene.vo.SceneCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("checkResult")
@Api(value = "检查结果", tags = {"检查单主子记录表表"})
public class SceneCheckResultController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;

    @Autowired
    private IOrgApi iOrgApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("检查结果查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = service.selectById(id);
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List<SceneCheckDetailVO> sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetailVOList.forEach(item -> {
                item.setBaseImgUrl(baseImgUrl);
            });
        }
        SceneCheckVO vo = BeanMapper.map(entity, SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询检查结果列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //移动端和pc端权限处理
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("overdueNum")) {
            String overdueNum = (String) params.get("overdueNum").getValue();
            params.remove("overdueNum");
            if (overdueNum.equals("1")) {
                param.getParams().put("overdueNum", new Parameter(QueryParam.GT, 0));
            }
            if (overdueNum.equals("0")) {
                param.getParams().put("overdueNum", new Parameter(QueryParam.EQ, 0));
            }
        }
        IPage<SceneCheckEntity> page = service.queryPage(param, false);
        IPage<SceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<SceneCheckEntity> list = service.queryList(param);
        List<SceneCheckVO> sceneCheckVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            sceneCheckVOS = BeanMapper.mapList(list, SceneCheckVO.class);
            sceneCheckVOS.forEach(vo -> {
                vo.setReformName(ReformState.getEnumByStateCode(vo.getReformStatus()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().export("SceneCheckResult-export.xlsx", beans, response);
    }

    @ApiOperation("查询检查结果统计")
    @RequestMapping(value = "/getStatisticsNum", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckStatisticsVO> getStatisticsNum() {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //移动端和pc端权限处理
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        SceneCheckStatisticsVO sceneCheckStatisticsVO = new SceneCheckStatisticsVO();
        List<SceneCheckEntity> sceneCheckEntities = service.queryList(param, false);
        if (CollectionUtils.isNotEmpty(sceneCheckEntities)) {
            //所有的检查
            sceneCheckStatisticsVO.setTotal(sceneCheckEntities.size());
             //检查全部通过的
            List<SceneCheckEntity> collect = sceneCheckEntities.stream().filter(s -> s.getReformStatus() == Integer.parseInt(ReformState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                sceneCheckStatisticsVO.setFinished(collect.size());
            } else {
                sceneCheckStatisticsVO.setFinished(collect.size());
            }
            //待整改和不合格的
            List<SceneCheckEntity> reformList = sceneCheckEntities.stream().filter(s -> s.getReformStatus() == Integer.parseInt(ReformState.REFORM_STATE.getCode()) || s.getReformStatus() == Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(reformList)) {
                sceneCheckStatisticsVO.setRectification(reformList.size());
            } else {
                sceneCheckStatisticsVO.setRectification(0);
            }
            //逾期的
            List<SceneCheckEntity> overdueList = sceneCheckEntities.stream().filter(s -> s.getOverdueNum()!=null && s.getOverdueNum()>0).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(overdueList)){
                List<SceneCheckEntity> overdueReformList = overdueList.stream().filter(s -> s.getReformStatus() == Integer.parseInt(ReformState.REFORM_STATE.getCode()) || s.getReformStatus() == Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
               if (CollectionUtils.isNotEmpty(overdueReformList)){
                   sceneCheckStatisticsVO.setOverdueNum(overdueReformList.size());
               }
               else {
                   sceneCheckStatisticsVO.setOverdueNum(0);
               }
            }else {
                sceneCheckStatisticsVO.setOverdueNum(0);
            }
        }

        return CommonResponse.success("查询统计数据成功！", sceneCheckStatisticsVO);
    }

}
