package com.ejianc.business.zyscene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zyscene.bean.SceneCheckDetailEntity;
import com.ejianc.business.zyscene.bean.SceneSafetyCheckCategoryEntity;
import com.ejianc.business.zyscene.bean.SceneSafetyCheckItemEntity;
import com.ejianc.business.zyscene.service.ISceneCheckDetailService;
import com.ejianc.business.zyscene.service.ISceneSafetyCheckCategoryService;
import com.ejianc.business.zyscene.service.ISceneSafetyCheckItemService;
import com.ejianc.business.zyscene.vo.SceneSafetyCheckCategoryVO;
import com.ejianc.business.zyscene.vo.SceneSafetyCheckItemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 资源管理-安全检查项表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("sceneSafetyCheckItem")
public class SceneSafetyCheckItemController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZY_SCENE_SAFETY_CHECK_ITEM";
    private static final String BILL_TYPE_CODE = "BT202310000009";
    @Autowired
    private ISceneSafetyCheckItemService service;
    @Autowired
    private ISceneSafetyCheckCategoryService checkCategoryService;

    @Autowired
    private ISceneCheckDetailService checkDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneSafetyCheckItemVO> saveOrUpdate(@RequestBody SceneSafetyCheckItemVO saveOrUpdateVO) {
        SceneSafetyCheckItemEntity entity = null;
        if(saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
            entity = BeanMapper.map(saveOrUpdateVO, SceneSafetyCheckItemEntity.class);
            if(StringUtils.isBlank(entity.getCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());
                }else{
                    return CommonResponse.error("网络异常， 编码生成失败， 请稍后再试");
                }
            } else {
                SceneSafetyCheckItemEntity dbEntity = service.getByCode(saveOrUpdateVO.getCode());
                if(null != dbEntity) {
                    return CommonResponse.error("物资编码已存在,请重新填写");
                }
            }

            if(null == entity.getEnabled()) {
                //默认启用
                entity.setEnabled(1);
            }
        } else {
            SceneSafetyCheckItemEntity dbEntity = service.getByCode(saveOrUpdateVO.getCode());
            if(null != dbEntity && !dbEntity.getId().equals(saveOrUpdateVO.getId())) {
                return CommonResponse.error("检查项编码已存在,请重新填写");
            }
            entity = service.selectById(saveOrUpdateVO.getId());
            entity.setEnabled(saveOrUpdateVO.getEnabled());
            entity.setCode(saveOrUpdateVO.getCode());
            entity.setName(saveOrUpdateVO.getName());
            entity.setSequence(saveOrUpdateVO.getSequence());
            entity.setDescription(saveOrUpdateVO.getDescription());
            Long categoryIdOld = entity.getCategoryId();
            Long categoryId = saveOrUpdateVO.getCategoryId();
            String categoryName = saveOrUpdateVO.getCategoryName();
            if(!categoryIdOld.equals(categoryId)){
                LambdaUpdateWrapper<SceneCheckDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(SceneCheckDetailEntity::getCheckItemId, entity.getId());
                updateWrapper.set(SceneCheckDetailEntity::getCheckCategoryId, categoryId);
                updateWrapper.set(SceneCheckDetailEntity::getCheckCategory, categoryName);
                checkDetailService.update(updateWrapper);
            }
            entity.setCategoryId(categoryId);
            entity.setCategoryCode(saveOrUpdateVO.getCategoryCode());
            entity.setCategoryName(categoryName);
        }
        service.saveOrUpdate(entity, false);
        SceneSafetyCheckItemVO vo = BeanMapper.map(entity, SceneSafetyCheckItemVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneSafetyCheckItemVO> queryDetail(Long id) {
    	SceneSafetyCheckItemEntity entity = service.selectById(id);
    	SceneSafetyCheckItemVO vo = BeanMapper.map(entity, SceneSafetyCheckItemVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if(ListUtil.isNotEmpty(ids)){
            for (Long id : ids) {
                CommonResponse<String> response = billTypeApi.checkQuote(BILL_TYPE_CODE, id);
                if (!response.isSuccess()) {
                    return CommonResponse.error("删除失败：" + response.getMsg());
                }
            }
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneSafetyCheckItemVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("description");
        fuzzyFields.add("categoryCode");
        fuzzyFields.add("categoryName");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<SceneSafetyCheckItemEntity> page = service.queryPage(param,false);
        IPage<SceneSafetyCheckItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneSafetyCheckItemVO.class));


        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SceneSafetyCheckItemEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SceneSafetyCheckItem-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "safety-check-item-import.xlsx", "安全检查项导入模板");
    }

    @PostMapping(value = "/excelItemImport")
    public CommonResponse<JSONObject> excelItemImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<SceneSafetyCheckItemVO> processList = new ArrayList<>();
        List<SceneSafetyCheckItemVO> successList = new ArrayList<>();
        List<SceneSafetyCheckItemVO> errorList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<List<String>> result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error("检查项超过10000条，请分批上传！");
            }

            SceneSafetyCheckItemVO importVO = null;
            List<String> datas = null;
            Map<String, SceneSafetyCheckItemVO> codeCacheMap = new HashMap<>();
            for (int i = 0; i < result.size(); i++) {
                datas = result.get(i);
                importVO = new SceneSafetyCheckItemVO();
                importVO.setId(IdWorker.getId());
                importVO.setCategoryCode(datas.get(0));
                importVO.setCode(datas.get(1));
                importVO.setName(datas.get(2));

                if(StringUtils.isBlank(datas.get(0))) {
                    importVO.setDescription("检查项分类编号为空！");
                    errorList.add(importVO);
                    continue;
                }
                if (StringUtils.isBlank(datas.get(2))) {
                    importVO.setDescription("检查项名称为空！");
                    errorList.add(importVO);
                    continue;
                }
                if(StringUtils.isNotBlank(importVO.getCode()) && codeCacheMap.containsKey(importVO.getCode())) {
                    importVO.setDescription("检查项编号重复！");
                    errorList.add(importVO);
                    continue;
                }

                codeCacheMap.put(importVO.getCode(), importVO);
                processList.add(importVO);
            }

            Map<String, SceneSafetyCheckCategoryEntity> categoryCodeMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(processList)) {
                Set<String> codes = processList.stream().map(SceneSafetyCheckItemVO::getCategoryCode).collect(Collectors.toSet());
                List<SceneSafetyCheckCategoryEntity> categoryList = checkCategoryService.queryByCodes(new ArrayList<>(codes));
                if(CollectionUtils.isNotEmpty(categoryList)) {
                    categoryCodeMap = categoryList.stream().collect(Collectors.toMap(SceneSafetyCheckCategoryEntity::getCode, item -> item));
                }

                SceneSafetyCheckCategoryEntity category = null;
                for(SceneSafetyCheckItemVO item : processList) {
                    category = categoryCodeMap.get(item.getCategoryCode());
                    if(null == category) {
                        item.setDescription("所属分类不存在！");
                        errorList.add(item);
                        continue;
                    }

                    item.setCategoryId(category.getId());
                    item.setCategoryName(category.getName());
                    successList.add(item);
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @PostMapping(value = "/saveImportExcelItem")
    public CommonResponse<String> saveImportExcelItem(@RequestBody List<SceneSafetyCheckItemVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<SceneSafetyCheckItemVO> noCodeItems = importVOS.stream().filter(item -> StringUtils.isBlank(item.getCode())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(noCodeItems)) {
            //没有编码的自动生成编码
            CommonResponse<List<String>> codeResp = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid(), noCodeItems.size());
            if(!codeResp.isSuccess()) {
                logger.error("质量检查项编码生成失败, {}", JSONObject.toJSONString(codeResp));
                return CommonResponse.error("保存失败，自动生成编码失败！");
            }
            List<String> codes = codeResp.getData();
            for(int i=0; i<codes.size(); i++) {
                noCodeItems.get(i).setCode(codes.get(i));
            }
        }

        service.saveOrUpdateBatch(BeanMapper.mapList(importVOS, SceneSafetyCheckItemEntity.class), importVOS.size(), false);
        return CommonResponse.success("保存成功！");
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refSceneQualityCheckItemData", method = RequestMethod.GET)
    public CommonResponse<IPage<SceneSafetyCheckItemVO>> refSceneQualityCheckItemData(@RequestParam(defaultValue = "1")  Integer pageNumber,
                                                                                       @RequestParam(defaultValue = "10") Integer pageSize,
                                                                                       @RequestParam(required = false) String relyCondition,
                                                                                       @RequestParam(required = false) String condition,
                                                                                       @RequestParam(required = false) String searchObject,
                                                                                       @RequestParam(required = false) String searchText) {
        QueryParam param = new QueryParam();

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("description");
        fuzzyFields.add("categoryCode");
        fuzzyFields.add("categoryName");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            List<SceneSafetyCheckCategoryVO> materialCategoryVos = checkCategoryService.queryAllByPid(categoryId);
            if(CollectionUtils.isEmpty(materialCategoryVos)) {
                return CommonResponse.error("当前分类信息获取失败！");
            }
            param.getParams().put("category_id", new Parameter(QueryParam.IN, materialCategoryVos.stream().map(SceneSafetyCheckCategoryVO::getId).collect(Collectors.toList())));
        }

        IPage<SceneSafetyCheckItemEntity> page = service.queryPage(param,false);
        IPage<SceneSafetyCheckItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneSafetyCheckItemVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
