package com.ejianc.business.prjdocs.controller;

import java.io.Serializable;

import com.ejianc.business.prjdocs.bean.PrjexecuteAssessmentItemDetailEntity;
import com.ejianc.business.prjdocs.service.IPrjexecuteAssessmentItemDetailService;
import com.ejianc.business.prjdocs.vo.PrjexecuteAssessmentItemDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.prjdocs.bean.PrjexecuteAssessmentItemEntity;
import com.ejianc.business.prjdocs.service.IPrjexecuteAssessmentItemService;
import com.ejianc.business.prjdocs.vo.PrjexecuteAssessmentItemVO;

/**
 * 考核项
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("prjdocs/assessmentItem")
public class PrjexecuteAssessmentItemController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IPrjexecuteAssessmentItemService service;
    @Autowired
    private IPrjexecuteAssessmentItemDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PrjexecuteAssessmentItemVO> saveOrUpdate(@RequestBody PrjexecuteAssessmentItemVO saveOrUpdateVO) {
        PrjexecuteAssessmentItemVO vo = service.saveData(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PrjexecuteAssessmentItemVO> queryDetail(Long id) {
    	PrjexecuteAssessmentItemVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrjexecuteAssessmentItemVO> vos) {
        service.removeByIds(vos.stream().map(PrjexecuteAssessmentItemVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PrjexecuteAssessmentItemVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("assessmentItemName");
        fuzzyFields.add("assessmentItemCategory");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PrjexecuteAssessmentItemEntity> page = service.queryPage(param,false);
        IPage<PrjexecuteAssessmentItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrjexecuteAssessmentItemVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("assessmentItemName");
        fuzzyFields.add("assessmentItemCategory");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<PrjexecuteAssessmentItemEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PrjexecuteAssessmentItem-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPrjexecuteAssessmentItemData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PrjexecuteAssessmentItemVO>> refPrjexecuteAssessmentItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PrjexecuteAssessmentItemEntity> page = service.queryPage(param,false);
        IPage<PrjexecuteAssessmentItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrjexecuteAssessmentItemVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public Long getOrgId(List<OrgVO> data, Integer type) {
        if(data.get(0).getOrgType()==1){
            //查询的数据由上到下（根组织为第一个）
            for(int i=(data.size()-1);i>=0;i--){
                if(data.get(i).getOrgType()==type){
                    return data.get(i).getId();
                }
            }
        }else{
            //查询的数据由上到下（根组织为最后一个）
            for(int i=0;i<data.size();i++){
                if(data.get(i).getOrgType()==type){
                    return data.get(i).getId();
                }
            }
        }
        return null;
    }
    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryReferAssessmentItemList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PrjexecuteAssessmentItemDetailVO>> queryReferAssessmentItemList(
            @RequestParam Integer pageNumber, @RequestParam Integer pageSize,
            String condition, String searchObject, String searchText) {
        Long orgId = null;
        String assessmentItemCategory = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.get("orgId") != null) {
                orgId = Long.parseLong(_con.getString("orgId"));

                CommonResponse<List<OrgVO>> orgList = iOrgApi.findParentsByOrgId(orgId);
                if(orgList.getCode()==0&&orgList.getData()!=null&&orgList.getData().size()>0) {
                    List<OrgVO> data = orgList.getData();
                    //根据项目所属组织，查询最近的是分子公司的组织
                    orgId = getOrgId(data, 2);
                }
                logger.info("orgId:{}",orgId);
            } else {
                return CommonResponse.error("缺少组织数据");
            }
            if (_con.get("assessmentItemCategory") != null) {
                assessmentItemCategory = _con.getString("assessmentItemCategory");
            }
        } else {
            return CommonResponse.error("缺少组织数据");
        }

        PrjexecuteAssessmentItemEntity entity = null;


        QueryParam param1 = new QueryParam();
        /** 租户隔离 */
        param1.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param1.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        param1.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        if(StringUtils.isNotBlank(assessmentItemCategory)){
            param1.getParams().put("assessmentItemCategory", new Parameter(QueryParam.EQ, assessmentItemCategory));
        }
        List<PrjexecuteAssessmentItemEntity> list1 = service.queryList(param1, false);
        if (list1 != null && list1.size() > 0) {
            entity = list1.get(0);
        } else {
            //获取本上组织数据
            LinkedList<Long> orgIdList = new LinkedList<>();
            CommonResponse<List<OrgVO>> orgResponse = iOrgApi.findParentsByOrgId(orgId);
            if (orgResponse.isSuccess() && orgResponse.getData() != null) {
                List<OrgVO> orgList = orgResponse.getData();
                Collections.sort(orgList, new Comparator() {
                    @Override
                    public int compare(Object o1, Object o2) {
                        ObjectMapper objectMapper = new ObjectMapper();
                        OrgVO o1Detail = objectMapper.convertValue(o1, OrgVO.class);
                        OrgVO o2Detail = objectMapper.convertValue(o2, OrgVO.class);
                        if (o1Detail.getInnerCode().length() > o2Detail.getInnerCode().length()) {
                            return 1;
                        } else {
                            return -1;
                        }
                    }
                });
                for (OrgVO vo : orgList) {
                    orgIdList.add(vo.getId());
                }
            }

            QueryParam param = new QueryParam();
            /** 租户隔离 */
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
            param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
            if(StringUtils.isNotBlank(assessmentItemCategory)){
                param.getParams().put("assessmentItemCategory", new Parameter(QueryParam.EQ, assessmentItemCategory));
            }
            List<PrjexecuteAssessmentItemEntity> list = service.queryList(param, false);
            Map<Long, PrjexecuteAssessmentItemEntity> itemMap = new HashMap<>();
            for (PrjexecuteAssessmentItemEntity en : list) {
                itemMap.put(en.getOrgId(), en);
            }
            for (Long oId : orgIdList) {
                if (itemMap.get(oId) != null) {
                    entity = itemMap.get(oId);
                    break;
                }
            }
        }

        if (entity == null) {
            IPage<PrjexecuteAssessmentItemDetailVO> pageData = new Page<>(pageNumber, pageSize, 0);
            return CommonResponse.success("查询参照数据成功！", pageData);
        }

        QueryParam param2 = new QueryParam();
        /** 租户隔离 */
        param2.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param2.getParams().put("assessmentId", new Parameter(QueryParam.EQ, entity.getId()));
        param2.getParams().put("pid", new Parameter(QueryParam.SQL, "pid is not null"));//请求子集的数据
        param2.setPageIndex(pageNumber);
        param2.setPageSize(pageSize);
        List<String> fuzzyFields = param2.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("assessmentItemName");
        fuzzyFields.add("assessmentItemCategory");
        fuzzyFields.add("orgName");
        if(StringUtils.isNotBlank(searchText)){
            param2.setSearchText(searchText);
        }
        param2.getOrderMap().put("serialNumber", QueryParam.ASC);
        IPage<PrjexecuteAssessmentItemDetailEntity> page = detailService.queryPage(param2, false);

        QueryParam param3 = new QueryParam();
        /** 租户隔离 */
        param3.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param3.getParams().put("assessmentId", new Parameter(QueryParam.EQ, entity.getId()));
        param3.getParams().put("pid", new Parameter(QueryParam.SQL, "pid is null"));//
        List<PrjexecuteAssessmentItemDetailEntity> list3 = detailService.queryList(param3, false);
        Map<Long, PrjexecuteAssessmentItemDetailEntity> pMap = new HashMap<>();
        for(PrjexecuteAssessmentItemDetailEntity en : list3){
            pMap.put(en.getId(), en);
        }

        IPage<PrjexecuteAssessmentItemDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PrjexecuteAssessmentItemDetailVO> vos = new ArrayList<>();
        if(page.getRecords()!=null && page.getRecords().size()>0){
            for(PrjexecuteAssessmentItemDetailEntity en : page.getRecords()){
                PrjexecuteAssessmentItemDetailVO vo = BeanMapper.map(en, PrjexecuteAssessmentItemDetailVO.class);
                vo.setItemName(entity.getAssessmentItemName());
                if(en.getPid()!=null && pMap.get(en.getPid())!=null){
                    vo.setPname(pMap.get(en.getPid()).getItemContent() + "("+pMap.get(en.getPid()).getScoreValue()+"分)");
                }
                vo.setChildren(null);
                vos.add(vo);
            }
        }
        pageData.setRecords(vos);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
