package com.ejianc.business.prjdocs.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目管理人员任命
 * 
 * @author generator
 * 
 */
public class PrjmanagerAssignVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long signerId; // 签发人
    private String signerName; // 签发人
    private String signPost; // 签发人职务
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签发日期
    private String remark; // 备注
    private Long projectDepartmentId; // 项目部id
    private Long orgId; // 所属单位id
    
    private List<PrjmanagerAssignDetailVO> prjmanagerAssignDetailList = new ArrayList<>(); // 项目管理人员任命明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSignerId() {
        return signerId;
    }

    @ReferDeserialTransfer
    public void setSignerId(Long signerId) {
        this.signerId = signerId;
    }

    public String getSignerName() {
        return signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public String getSignPost() {
        return signPost;
    }

    public void setSignPost(String signPost) {
        this.signPost = signPost;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    
     public List<PrjmanagerAssignDetailVO> getPrjmanagerAssignDetailList() {
        return prjmanagerAssignDetailList;
     }

     public void setPrjmanagerAssignDetailList(List<PrjmanagerAssignDetailVO> prjmanagerAssignDetailList) {
        this.prjmanagerAssignDetailList = prjmanagerAssignDetailList;
     }
}
