package com.ejianc.business.sq.keyan.controller;

import java.io.Serializable;

import com.ejianc.business.sq.keyan.bean.KeyanMilestoneEntity;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;
import com.ejianc.business.sq.keyan.vo.KeyanMilestoneVO;
import com.ejianc.business.util.ImportCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sq.keyan.bean.KeyanWorkSureEntity;
import com.ejianc.business.sq.keyan.service.IKeyanWorkSureService;
import com.ejianc.business.sq.keyan.vo.KeyanWorkSureVO;

/**
 * 工时确认
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sq/keyan/workSure")
public class KeyanWorkSureController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi employeeApi;

    private static final String BILL_CODE = "zydxKeyanWorkSure";//此处需要根据实际修改

    @Autowired
    private IKeyanWorkSureService service;
    @Autowired
    private IKeyanProjectService keyanProjectService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KeyanWorkSureVO> saveOrUpdate(@RequestBody KeyanWorkSureVO saveOrUpdateVO) {
    	KeyanWorkSureEntity entity = BeanMapper.map(saveOrUpdateVO, KeyanWorkSureEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	KeyanWorkSureVO vo = BeanMapper.map(entity, KeyanWorkSureVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KeyanWorkSureVO> queryDetail(Long id) {
    	KeyanWorkSureEntity entity = service.selectById(id);
    	KeyanWorkSureVO vo = BeanMapper.map(entity, KeyanWorkSureVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KeyanWorkSureVO> vos) {
        service.removeByIds(vos.stream().map(KeyanWorkSureVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KeyanWorkSureVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fillUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("unitId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<KeyanWorkSureEntity> page = service.queryPage(param,false);
        IPage<KeyanWorkSureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), KeyanWorkSureVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }



    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downTemplateUrl")
    @ResponseBody
    public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "sq/keyanWorkSure-import.xlsx", "其他模板");
    }
    /**
     * @Description excel导入数据检验
     */
    @RequestMapping(value = "/importCheckData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> importCheckData(HttpServletRequest request, HttpServletResponse response) {
        ImportCommonUtil importUtil = new ImportCommonUtil();

        importUtil.setDataStartLine(2);
        LinkedList<String> fileds = new LinkedList<>();
        fileds.addAll(Arrays.asList("projectName","fillUserName","fillDate","remarks"));
        importUtil.setFileds(fileds);
        LinkedList<String> filedsName = new LinkedList<>();
        filedsName.addAll(Arrays.asList("项目","填报人","填报时间","备注"));
        importUtil.setFiledsName(filedsName);
        importUtil.setRequest(request);
        Map<String, JSONObject> filedsConfig = new HashMap<>();

        JSONObject projectNameConfig = new JSONObject();
        projectNameConfig.put("keyanProject", "keyanProject");
        JSONObject projectNameMath = new JSONObject();
        projectNameMath.put("projectId", "id");
        projectNameMath.put("unitId", "bearUnitId");
        projectNameMath.put("unitName", "bearUnitName");
        projectNameConfig.put("fieldMath", projectNameMath);
        filedsConfig.put("projectName", projectNameConfig);

        JSONObject fillUserNameConfig = new JSONObject();
        fillUserNameConfig.put("user", "user");
        JSONObject fillUserNameMath = new JSONObject();
        fillUserNameMath.put("fillUserId", "id");
        fillUserNameConfig.put("fieldMath", fillUserNameMath);
        filedsConfig.put("fillUserName", fillUserNameConfig);
        importUtil.setFiledsConfig(filedsConfig);//字段关联性配置信息

        importUtil.setFiledsConfig(filedsConfig);//字段关联性配置信息
        importUtil.setVoName("com.ejianc.business.sq.keyan.vo.KeyanWorkSureVO");
        importUtil.setServiceName("keyanWorkSureService");
        List<String> requiredFields = new ArrayList<>();//必填字段
        requiredFields.addAll(Arrays.asList("projectName","fillUserName","fillDate"));
        importUtil.setRequiredFields(requiredFields);
//        List<String> uniqueneFields = new ArrayList<>();//唯一性字段
//        uniqueneFields.addAll(Arrays.asList("projectName"));
//        importUtil.setUniqueneFields(uniqueneFields);
        importUtil.setEmployeeApi(employeeApi);
        importUtil.setKeyanProjectService(keyanProjectService);
        importUtil.setiOrgApi(iOrgApi);
        JSONObject json = importUtil.importCheckData();
        return CommonResponse.success("保存或修改单据成功！",json);
    }

    /**
     * @Description importDataSave 导入批量新增
     */
    @RequestMapping(value = "/importDataSave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> importDataSave(@RequestBody List<KeyanWorkSureVO> vos) {
        CommonResponse<List<String>> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,InvocationInfoProxy.getTenantid(),vos.size());
        if(billCode.isSuccess() && billCode.getData().size() == vos.size()){
            List<KeyanWorkSureEntity> entitys = new ArrayList<>();
            for(int i=0; i<vos.size(); i++){
                KeyanWorkSureEntity entity = BeanMapper.map(vos.get(i), KeyanWorkSureEntity.class);
                entity.setBillCode(billCode.getData().get(i));
                entitys.add(entity);
            }
            service.saveOrUpdateBatch(entitys, entitys.size(), false);
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return CommonResponse.success("导入成功！");
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("fillUserName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("unitId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<KeyanWorkSureEntity> list = service.queryList(param);
        List<KeyanWorkSureVO> result = new ArrayList<>();
        if(list!=null && list.size()>0){
            result = BeanMapper.mapList(list, KeyanWorkSureVO.class);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", result);
        ExcelExport.getInstance().exportWithTrans("sq/keyanWorkSure-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refKeyanWorkSureData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<KeyanWorkSureVO>> refKeyanWorkSureData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<KeyanWorkSureEntity> page = service.queryPage(param,false);
        IPage<KeyanWorkSureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KeyanWorkSureVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
