/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjdocs.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prjdocs.bean.PrjexecuteAssessmentItemDetailEntity;
import com.ejianc.business.prjdocs.bean.PrjexecuteAssessmentItemEntity;
import com.ejianc.business.prjdocs.service.IPrjexecuteAssessmentItemDetailService;
import com.ejianc.business.prjdocs.service.IPrjexecuteAssessmentItemService;
import com.ejianc.business.prjdocs.vo.PrjexecuteAssessmentItemDetailVO;
import com.ejianc.business.prjdocs.vo.PrjexecuteAssessmentItemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"prjdocs/assessmentItem"})
public class PrjexecuteAssessmentItemController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPrjexecuteAssessmentItemService service;
    @Autowired
    private IPrjexecuteAssessmentItemDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PrjexecuteAssessmentItemVO> saveOrUpdate(@RequestBody PrjexecuteAssessmentItemVO saveOrUpdateVO) {
        PrjexecuteAssessmentItemVO vo = this.service.saveData(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PrjexecuteAssessmentItemVO> queryDetail(Long id) {
        PrjexecuteAssessmentItemVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrjexecuteAssessmentItemVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PrjexecuteAssessmentItemVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("assessmentItemName");
        fuzzyFields.add("assessmentItemCategory");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PrjexecuteAssessmentItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("assessmentItemName");
        fuzzyFields.add("assessmentItemCategory");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PrjexecuteAssessmentItem-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPrjexecuteAssessmentItemData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PrjexecuteAssessmentItemVO>> refPrjexecuteAssessmentItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PrjexecuteAssessmentItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public Long getOrgId(List<OrgVO> data, Integer type) {
        if (data.get(0).getOrgType() == 1) {
            for (int i = data.size() - 1; i >= 0; --i) {
                if (data.get(i).getOrgType() != type) continue;
                return data.get(i).getId();
            }
        } else {
            for (int i = 0; i < data.size(); ++i) {
                if (data.get(i).getOrgType() != type) continue;
                return data.get(i).getId();
            }
        }
        return null;
    }

    @RequestMapping(value={"/queryReferAssessmentItemList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PrjexecuteAssessmentItemDetailVO>> queryReferAssessmentItemList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        List list1;
        Long orgId = null;
        String assessmentItemCategory = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"orgId") != null) {
                orgId = Long.parseLong(_con.getString("orgId"));
                CommonResponse orgList = this.iOrgApi.findParentsByOrgId(orgId);
                if (orgList.getCode() == 0 && orgList.getData() != null && ((List)orgList.getData()).size() > 0) {
                    List data = (List)orgList.getData();
                    orgId = this.getOrgId(data, 2);
                }
            } else {
                return CommonResponse.error((String)"\u7f3a\u5c11\u7ec4\u7ec7\u6570\u636e");
            }
            this.logger.info("orgId:{}", (Object)orgId);
            if (_con.get((Object)"assessmentItemCategory") != null) {
                assessmentItemCategory = _con.getString("assessmentItemCategory");
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11\u7ec4\u7ec7\u6570\u636e");
        }
        PrjexecuteAssessmentItemEntity entity = null;
        QueryParam param1 = new QueryParam();
        param1.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param1.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        param1.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        if (StringUtils.isNotBlank((CharSequence)assessmentItemCategory)) {
            param1.getParams().put("assessmentItemCategory", new Parameter("eq", (Object)assessmentItemCategory));
        }
        if ((list1 = this.service.queryList(param1, false)) != null && list1.size() > 0) {
            entity = (PrjexecuteAssessmentItemEntity)((Object)list1.get(0));
        } else {
            LinkedList<Long> orgIdList = new LinkedList<Long>();
            CommonResponse orgResponse = this.iOrgApi.findParentsByOrgId(orgId);
            if (orgResponse.isSuccess() && orgResponse.getData() != null) {
                List orgList = (List)orgResponse.getData();
                Collections.sort(orgList, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ObjectMapper objectMapper = new ObjectMapper();
                        OrgVO o1Detail = (OrgVO)objectMapper.convertValue(o1, OrgVO.class);
                        OrgVO o2Detail = (OrgVO)objectMapper.convertValue(o2, OrgVO.class);
                        if (o1Detail.getInnerCode().length() > o2Detail.getInnerCode().length()) {
                            return 1;
                        }
                        return -1;
                    }
                });
                for (OrgVO vo : orgList) {
                    orgIdList.add(vo.getId());
                }
            }
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("orgId", new Parameter("in", orgIdList));
            param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
            if (StringUtils.isNotBlank((CharSequence)assessmentItemCategory)) {
                param.getParams().put("assessmentItemCategory", new Parameter("eq", (Object)assessmentItemCategory));
            }
            List list = this.service.queryList(param, false);
            HashMap<Long, PrjexecuteAssessmentItemEntity> itemMap = new HashMap<Long, PrjexecuteAssessmentItemEntity>();
            for (PrjexecuteAssessmentItemEntity prjexecuteAssessmentItemEntity : list) {
                itemMap.put(prjexecuteAssessmentItemEntity.getOrgId(), prjexecuteAssessmentItemEntity);
            }
            for (Long l : orgIdList) {
                if (itemMap.get(l) == null) continue;
                entity = (PrjexecuteAssessmentItemEntity)((Object)itemMap.get(l));
                break;
            }
        }
        if (entity == null) {
            Page pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), 0L);
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        QueryParam param2 = new QueryParam();
        param2.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param2.getParams().put("assessmentId", new Parameter("eq", (Object)entity.getId()));
        param2.getParams().put("pid", new Parameter("sql", (Object)"pid is not null"));
        param2.setPageIndex(pageNumber.intValue());
        param2.setPageSize(pageSize.intValue());
        List fuzzyFields = param2.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("assessmentItemName");
        fuzzyFields.add("assessmentItemCategory");
        fuzzyFields.add("orgName");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param2.setSearchText(searchText);
        }
        param2.getOrderMap().put("serialNumber", "asc");
        IPage page = this.detailService.queryPage(param2, false);
        QueryParam param3 = new QueryParam();
        param3.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param3.getParams().put("assessmentId", new Parameter("eq", (Object)entity.getId()));
        param3.getParams().put("pid", new Parameter("sql", (Object)"pid is null"));
        List list3 = this.detailService.queryList(param3, false);
        HashMap<Long, PrjexecuteAssessmentItemDetailEntity> pMap = new HashMap<Long, PrjexecuteAssessmentItemDetailEntity>();
        for (PrjexecuteAssessmentItemDetailEntity en : list3) {
            pMap.put(en.getId(), en);
        }
        Page page2 = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        ArrayList<PrjexecuteAssessmentItemDetailVO> vos = new ArrayList<PrjexecuteAssessmentItemDetailVO>();
        if (page.getRecords() != null && page.getRecords().size() > 0) {
            for (PrjexecuteAssessmentItemDetailEntity en : page.getRecords()) {
                PrjexecuteAssessmentItemDetailVO vo = (PrjexecuteAssessmentItemDetailVO)((Object)BeanMapper.map((Object)((Object)en), PrjexecuteAssessmentItemDetailVO.class));
                vo.setItemName(entity.getAssessmentItemName());
                if (en.getPid() != null && pMap.get(en.getPid()) != null) {
                    vo.setPname(((PrjexecuteAssessmentItemDetailEntity)((Object)pMap.get(en.getPid()))).getItemContent() + "(" + ((PrjexecuteAssessmentItemDetailEntity)((Object)pMap.get(en.getPid()))).getScoreValue() + "\u5206)");
                }
                vo.setChildren(null);
                vos.add(vo);
            }
        }
        page2.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page2);
    }
}

