package com.ejianc.business.sq.keyan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.sq.keyan.bean.KeyanWorkSureUserEntity;
/**
 * 工时确认
 * 
 * @author generator
 * 
 */
 @TableName("ejc_keyan_work_sure")
public class KeyanWorkSureEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="unit_id")
    private Long unitId; // 所属单位id
    @TableField(value="unit_name")
    private String unitName; // 所属单位名称
    @TableField(value="fill_user_id")
    private Long fillUserId; // 填报人id
    @TableField(value="fill_user_name")
    private String fillUserName; // 填报人
    @TableField(value="fill_date")
    private Date fillDate; // 填报时间
    @TableField(value="remarks")
    private String remarks; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="keyanWorkSureUserService", pidName="pid")
    private List<KeyanWorkSureUserEntity> userList = new ArrayList<>(); // 工时明细人员
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Long getFillUserId() {
        return fillUserId;
    }

    public void setFillUserId(Long fillUserId) {
        this.fillUserId = fillUserId;
    }
    public String getFillUserName() {
        return fillUserName;
    }

    public void setFillUserName(String fillUserName) {
        this.fillUserName = fillUserName;
    }
    public Date getFillDate() {
        return fillDate;
    }

    public void setFillDate(Date fillDate) {
        this.fillDate = fillDate;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<KeyanWorkSureUserEntity> getUserList() {
        return userList;
    }

    public void setUserList(List<KeyanWorkSureUserEntity> userList) {
        this.userList = userList;
    }
}
