package com.ejianc.business.sq.keyan.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.sq.keyan.vo.KeyanProjectDetailChangeVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 在研项目立项变更
 * 
 * @author generator
 * 
 */
public class KeyanProjectChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long bearUnitId; // 承担单位id
    private String bearUnitName; // 承担单位名称
    private String projectName; // 项目名称
    private String belongingSector; // 所属板块
    private String projectApprovalUnit; // 立项单位
    private String projectLevel; // 项目级别
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectStartDate; // 项目开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectEndDate; // 项目结束时间
    private String whetherAppropriation; // 是否拨款
    private BigDecimal budgetAmount; // 预算总额（万元）
    private BigDecimal fundingAmount; // 拨款金额（万元）
    private Long projectLeaderId; // 负责人
    private String projectLeaderName; // 负责人名称
    private String projectLeaderPhone; // 负责人联系电话
    private String projectStatus; // 项目状态
    private String mainContent; // 主要内容
    private String innovationPoint; // 创新点
    private String remarks; // 备注
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date approvalTime; // 申请立项时间
    private Long contactPersonId; // 立项联系人id
    private String contactPersonName; // 立项联系人
    private String contactPersonPhone; // 立项联系人电话
    private Long oldMainId; // 原主键id
    
    private List<KeyanProjectDetailChangeVO> detailList = new ArrayList<>(); // 在研项目立项-里程碑-变更
    private Integer changeVersion;

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getBearUnitId() {
        return bearUnitId;
    }

    @ReferDeserialTransfer
    public void setBearUnitId(Long bearUnitId) {
        this.bearUnitId = bearUnitId;
    }
    public String getBearUnitName() {
        return bearUnitName;
    }

    public void setBearUnitName(String bearUnitName) {
        this.bearUnitName = bearUnitName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBelongingSector() {
        return belongingSector;
    }

    public void setBelongingSector(String belongingSector) {
        this.belongingSector = belongingSector;
    }
    public String getProjectApprovalUnit() {
        return projectApprovalUnit;
    }

    public void setProjectApprovalUnit(String projectApprovalUnit) {
        this.projectApprovalUnit = projectApprovalUnit;
    }
    public String getProjectLevel() {
        return projectLevel;
    }

    public void setProjectLevel(String projectLevel) {
        this.projectLevel = projectLevel;
    }
    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }
    public Date getProjectEndDate() {
        return projectEndDate;
    }

    public void setProjectEndDate(Date projectEndDate) {
        this.projectEndDate = projectEndDate;
    }
    public String getWhetherAppropriation() {
        return whetherAppropriation;
    }

    public void setWhetherAppropriation(String whetherAppropriation) {
        this.whetherAppropriation = whetherAppropriation;
    }
    public BigDecimal getBudgetAmount() {
        return budgetAmount;
    }

    public void setBudgetAmount(BigDecimal budgetAmount) {
        this.budgetAmount = budgetAmount;
    }
    public BigDecimal getFundingAmount() {
        return fundingAmount;
    }

    public void setFundingAmount(BigDecimal fundingAmount) {
        this.fundingAmount = fundingAmount;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectLeaderId() {
        return projectLeaderId;
    }

    @ReferDeserialTransfer
    public void setProjectLeaderId(Long projectLeaderId) {
        this.projectLeaderId = projectLeaderId;
    }
    public String getProjectLeaderName() {
        return projectLeaderName;
    }

    public void setProjectLeaderName(String projectLeaderName) {
        this.projectLeaderName = projectLeaderName;
    }
    public String getProjectLeaderPhone() {
        return projectLeaderPhone;
    }

    public void setProjectLeaderPhone(String projectLeaderPhone) {
        this.projectLeaderPhone = projectLeaderPhone;
    }
    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getMainContent() {
        return mainContent;
    }

    public void setMainContent(String mainContent) {
        this.mainContent = mainContent;
    }
    public String getInnovationPoint() {
        return innovationPoint;
    }

    public void setInnovationPoint(String innovationPoint) {
        this.innovationPoint = innovationPoint;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Date getApprovalTime() {
        return approvalTime;
    }

    public void setApprovalTime(Date approvalTime) {
        this.approvalTime = approvalTime;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getContactPersonId() {
        return contactPersonId;
    }

    @ReferDeserialTransfer
    public void setContactPersonId(Long contactPersonId) {
        this.contactPersonId = contactPersonId;
    }
    public String getContactPersonName() {
        return contactPersonName;
    }

    public void setContactPersonName(String contactPersonName) {
        this.contactPersonName = contactPersonName;
    }
    public String getContactPersonPhone() {
        return contactPersonPhone;
    }

    public void setContactPersonPhone(String contactPersonPhone) {
        this.contactPersonPhone = contactPersonPhone;
    }
    public Long getOldMainId() {
        return oldMainId;
    }

    public void setOldMainId(Long oldMainId) {
        this.oldMainId = oldMainId;
    }

    public List<KeyanProjectDetailChangeVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<KeyanProjectDetailChangeVO> detailList) {
        this.detailList = detailList;
    }
}
