package com.ejianc.business.safe.vo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.safe.bean.SafeProjectCheckDetailEntity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 安全生产协议表
 * 
 * @author generator
 * 
 */
public class SafeProduceProtocolVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据审批状态
    private String code; // 单据编码
    private Long projectId; // 项目名称
    private String projectName; // 项目名称
    private Long orgId; // 所属单位
    private String orgName; // 所属单位
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private Long processor; // 经办人
    private String processorName; // 经办人
    private String memo; // 备注
    private String belongProject; // 是否属于项目
    private Long protocolType; // 协议类型
    private String protocolTypeName; // 协议类型


    public String getBelongProject() {
        return belongProject;
    }

    public void setBelongProject(String belongProject) {
        this.belongProject = belongProject;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProtocolType() {
        return protocolType;
    }
    @ReferDeserialTransfer
    public void setProtocolType(Long protocolType) {
        this.protocolType = protocolType;
    }

    public String getProtocolTypeName() {
        return protocolTypeName;
    }

    public void setProtocolTypeName(String protocolTypeName) {
        this.protocolTypeName = protocolTypeName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    @ReferSerialTransfer(referCode="idm-employee,idm-user")
    public Long getProcessor() {
        return processor;
    }
    @ReferDeserialTransfer
    public void setProcessor(Long processor) {
        this.processor = processor;
    }
    public String getProcessorName() {
        return processorName;
    }

    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
