package com.ejianc.business.sq.keyan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 在研项目立项
 * 
 * @author generator
 * 
 */
 @TableName("ejc_keyan_project")
public class KeyanProjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bear_unit_id")
    private Long bearUnitId; // 承担单位id
    @TableField(value="bear_unit_name")
    private String bearUnitName; // 承担单位名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="belonging_sector")
    private String belongingSector; // 所属板块
    @TableField(value="project_approval_unit")
    private String projectApprovalUnit; // 立项单位
    @TableField(value="project_level")
    private String projectLevel; // 项目级别
    @TableField(value="project_start_date")
    private Date projectStartDate; // 项目开始时间
    @TableField(value="project_end_date")
    private Date projectEndDate; // 项目结束时间
    @TableField(value="whether_appropriation")
    private String whetherAppropriation; // 是否拨款
    @TableField(value="budget_amount")
    private BigDecimal budgetAmount; // 预算总额（万元）
    @TableField(value="funding_amount")
    private BigDecimal fundingAmount; // 拨款金额（万元）
    @TableField(value="project_leader_id")
    private Long projectLeaderId; // 负责人
    @TableField(value="project_leader_name")
    private String projectLeaderName; // 负责人
    @TableField(value="project_leader_phone")
    private String projectLeaderPhone; // 负责人联系电话
    @TableField(value="project_status")
    private String projectStatus; // 项目状态
    @TableField(value="main_content")
    private String mainContent; // 主要内容
    @TableField(value="innovation_point")
    private String innovationPoint; // 创新点
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="approval_time")
    private Date approvalTime; // 申请立项时间
    @TableField(value="contact_person_id")
    private Long contactPersonId; // 立项联系人
    @TableField(value="contact_person_name")
    private String contactPersonName; // 立项联系人
    @TableField(value="contact_person_phone")
    private String contactPersonPhone; // 立项联系人电话
    @TableField(exist=false)
    @SubEntity(serviceName="keyanProjectDetailService", pidName="pid")
    private List<KeyanProjectDetailEntity> detailList = new ArrayList<>(); // 里程碑子表

    /**
     * 合同变更状态：1-未变更，2-变更中，3-已变更
     */
    @TableField(value = "change_state")
    private Integer changeState;
    /**
     * 变更单主键Id
     */
    @TableField(value = "change_id")
    private Long changeId;
    @TableField("change_version")
    private Integer changeVersion;
    @TableField("change_code")
    private String changeCode;

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public List<KeyanProjectDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<KeyanProjectDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getBearUnitId() {
        return bearUnitId;
    }

    public void setBearUnitId(Long bearUnitId) {
        this.bearUnitId = bearUnitId;
    }
    public String getBearUnitName() {
        return bearUnitName;
    }

    public void setBearUnitName(String bearUnitName) {
        this.bearUnitName = bearUnitName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBelongingSector() {
        return belongingSector;
    }

    public void setBelongingSector(String belongingSector) {
        this.belongingSector = belongingSector;
    }
    public String getProjectApprovalUnit() {
        return projectApprovalUnit;
    }

    public void setProjectApprovalUnit(String projectApprovalUnit) {
        this.projectApprovalUnit = projectApprovalUnit;
    }
    public String getProjectLevel() {
        return projectLevel;
    }

    public void setProjectLevel(String projectLevel) {
        this.projectLevel = projectLevel;
    }

    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    public Date getProjectEndDate() {
        return projectEndDate;
    }

    public void setProjectEndDate(Date projectEndDate) {
        this.projectEndDate = projectEndDate;
    }
    public String getWhetherAppropriation() {
        return whetherAppropriation;
    }

    public void setWhetherAppropriation(String whetherAppropriation) {
        this.whetherAppropriation = whetherAppropriation;
    }
    public BigDecimal getBudgetAmount() {
        return budgetAmount;
    }

    public void setBudgetAmount(BigDecimal budgetAmount) {
        this.budgetAmount = budgetAmount;
    }
    public BigDecimal getFundingAmount() {
        return fundingAmount;
    }

    public void setFundingAmount(BigDecimal fundingAmount) {
        this.fundingAmount = fundingAmount;
    }

    public Long getProjectLeaderId() {
        return projectLeaderId;
    }

    public void setProjectLeaderId(Long projectLeaderId) {
        this.projectLeaderId = projectLeaderId;
    }

    public String getProjectLeaderName() {
        return projectLeaderName;
    }

    public void setProjectLeaderName(String projectLeaderName) {
        this.projectLeaderName = projectLeaderName;
    }

    public String getProjectLeaderPhone() {
        return projectLeaderPhone;
    }

    public void setProjectLeaderPhone(String projectLeaderPhone) {
        this.projectLeaderPhone = projectLeaderPhone;
    }
    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getMainContent() {
        return mainContent;
    }

    public void setMainContent(String mainContent) {
        this.mainContent = mainContent;
    }
    public String getInnovationPoint() {
        return innovationPoint;
    }

    public void setInnovationPoint(String innovationPoint) {
        this.innovationPoint = innovationPoint;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Date getApprovalTime() {
        return approvalTime;
    }

    public void setApprovalTime(Date approvalTime) {
        this.approvalTime = approvalTime;
    }

    public Long getContactPersonId() {
        return contactPersonId;
    }

    public void setContactPersonId(Long contactPersonId) {
        this.contactPersonId = contactPersonId;
    }

    public String getContactPersonName() {
        return contactPersonName;
    }

    public void setContactPersonName(String contactPersonName) {
        this.contactPersonName = contactPersonName;
    }

    public String getContactPersonPhone() {
        return contactPersonPhone;
    }

    public void setContactPersonPhone(String contactPersonPhone) {
        this.contactPersonPhone = contactPersonPhone;
    }
    
}
