/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sq.keyan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sq.keyan.bean.KeyanIntellectualPropertyEntity;
import com.ejianc.business.sq.keyan.service.IKeyanIntellectualPropertyService;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;
import com.ejianc.business.sq.keyan.vo.KeyanIntellectualPropertyVO;
import com.ejianc.business.util.ImportCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sq/keyan/intellectualProperty"})
public class KeyanIntellectualPropertyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    private static final String BILL_CODE = "zydxKeyanIntellectualProperty";
    @Autowired
    private IKeyanIntellectualPropertyService service;
    @Autowired
    private IKeyanProjectService keyanProjectService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<KeyanIntellectualPropertyVO> saveOrUpdate(@RequestBody KeyanIntellectualPropertyVO saveOrUpdateVO) {
        KeyanIntellectualPropertyEntity entity = (KeyanIntellectualPropertyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KeyanIntellectualPropertyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        KeyanIntellectualPropertyVO vo = (KeyanIntellectualPropertyVO)((Object)BeanMapper.map((Object)((Object)entity), KeyanIntellectualPropertyVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KeyanIntellectualPropertyVO> queryDetail(Long id) {
        KeyanIntellectualPropertyEntity entity = (KeyanIntellectualPropertyEntity)((Object)this.service.selectById(id));
        KeyanIntellectualPropertyVO vo = (KeyanIntellectualPropertyVO)((Object)BeanMapper.map((Object)((Object)entity), KeyanIntellectualPropertyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KeyanIntellectualPropertyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<KeyanIntellectualPropertyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("contactUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("unitId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KeyanIntellectualPropertyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/downTemplateUrl"})
    @ResponseBody
    public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"sq/keyanIntellectualProperty-import.xlsx", (String)"\u5176\u4ed6\u6a21\u677f");
    }

    @RequestMapping(value={"/importCheckData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> importCheckData(HttpServletRequest request, HttpServletResponse response) {
        ImportCommonUtil importUtil = new ImportCommonUtil();
        importUtil.setDataStartLine(2);
        LinkedList<String> fileds = new LinkedList<String>();
        fileds.addAll(Arrays.asList("unitName", "applicationDate", "contactUserName", "intellectualPropertyType", "domain", "content"));
        importUtil.setFileds(fileds);
        LinkedList<String> filedsName = new LinkedList<String>();
        filedsName.addAll(Arrays.asList("\u7533\u8bf7\u5355\u4f4d", "\u7533\u8bf7\u65e5\u671f", "\u8054\u7cfb\u4eba", "\u77e5\u8bc6\u4ea7\u6743\u7c7b\u578b", "\u6240\u5c5e\u9886\u57df", "\u7533\u8bf7\u5185\u5bb9\u7b80\u4ecb"));
        importUtil.setFiledsName(filedsName);
        importUtil.setRequest(request);
        HashMap<String, JSONObject> filedsConfig = new HashMap<String, JSONObject>();
        JSONObject unitNameConfig = new JSONObject();
        unitNameConfig.put("org", (Object)"org");
        JSONObject unitNameMath = new JSONObject();
        unitNameMath.put("unitId", (Object)"id");
        unitNameConfig.put("fieldMath", (Object)unitNameMath);
        filedsConfig.put("unitName", unitNameConfig);
        JSONObject projectNameConfig = new JSONObject();
        projectNameConfig.put("keyanProject", (Object)"keyanProject");
        JSONObject projectNameMath = new JSONObject();
        projectNameMath.put("projectId", (Object)"id");
        projectNameConfig.put("fieldMath", (Object)projectNameMath);
        filedsConfig.put("projectName", projectNameConfig);
        JSONObject contactUserNameConfig = new JSONObject();
        contactUserNameConfig.put("user", (Object)"user");
        JSONObject contactUserNameMath = new JSONObject();
        contactUserNameMath.put("contactUserId", (Object)"id");
        contactUserNameMath.put("contactUserPhone", (Object)"mobilePhone");
        contactUserNameConfig.put("fieldMath", (Object)contactUserNameMath);
        filedsConfig.put("contactUserName", contactUserNameConfig);
        importUtil.setFiledsConfig(filedsConfig);
        importUtil.setFiledsConfig(filedsConfig);
        importUtil.setVoName("com.ejianc.business.sq.keyan.vo.KeyanIntellectualPropertyVO");
        importUtil.setServiceName("keyanIntellectualPropertyService");
        ArrayList<String> requiredFields = new ArrayList<String>();
        requiredFields.addAll(Arrays.asList("unitName", "applicationDate", "contactUserName", "intellectualPropertyType", "domain"));
        importUtil.setRequiredFields(requiredFields);
        importUtil.setEmployeeApi(this.employeeApi);
        importUtil.setiOrgApi(this.iOrgApi);
        JSONObject json = importUtil.importCheckData();
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/importDataSave"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> importDataSave(@RequestBody List<KeyanIntellectualPropertyVO> vos) {
        ArrayList<KeyanIntellectualPropertyEntity> entitys;
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid(), vos.size());
        if (billCode.isSuccess() && ((List)billCode.getData()).size() == vos.size()) {
            entitys = new ArrayList<KeyanIntellectualPropertyEntity>();
            for (int i = 0; i < vos.size(); ++i) {
                KeyanIntellectualPropertyEntity entity = (KeyanIntellectualPropertyEntity)((Object)BeanMapper.map((Object)((Object)vos.get(i)), KeyanIntellectualPropertyEntity.class));
                entity.setBillCode((String)((List)billCode.getData()).get(i));
                entitys.add(entity);
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdateBatch(entitys, entitys.size(), false);
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("contactUserName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("unitId", new Parameter("in", commonOrgIds));
        }
        List list = this.service.queryList(param);
        List result = new ArrayList();
        if (list != null && list.size() > 0) {
            result = BeanMapper.mapList((Iterable)list, KeyanIntellectualPropertyVO.class);
        }
        HashMap beans = new HashMap();
        beans.put("records", result);
        ExcelExport.getInstance().exportWithTrans("sq/keyanIntellectualProperty-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refKeyanIntellectualPropertyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<KeyanIntellectualPropertyVO>> refKeyanIntellectualPropertyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KeyanIntellectualPropertyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

