package com.ejianc.business.zjkjcost.optimization.service;

import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zjkjcost.optimization.bean.OptimizationTopicEntity;

import java.util.List;

/**
 * 项目优化-项目优化立项申报
 *
 * @author generator
 */
public interface IOptimizationTopicService extends IBaseService<OptimizationTopicEntity> {

    /**
     * 根据项目立项id修改占用标志
     *
     * @param topicId 项目立项id
     * @param occupyFlag  占用标志
     * @param occupyType  占用类型
     */
    void updateOccupyFlagByTopicId(Long topicId, Integer occupyFlag, Integer occupyType);

    /**
     * 根据项目立项id批量修改占用标志
     *
     * @param topicIdList 项目立项id列表
     * @param occupyFlag  占用标志
     * @param occupyType  占用类型
     */
    void updateOccupyFlagByTopicIds(List<Long> topicIdList, Integer occupyFlag, Integer occupyType);
}
