package com.ejianc.business.zjkjcost.optimization.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zjkjcost.optimization.enums.OccupyTypeEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.optimization.mapper.OptimizationTopicMapper;
import com.ejianc.business.zjkjcost.optimization.bean.OptimizationTopicEntity;
import com.ejianc.business.zjkjcost.optimization.service.IOptimizationTopicService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 项目优化-项目优化立项申报
 *
 * @author generator
 */
@Service("optimizationTopicService")
public class OptimizationTopicServiceImpl extends BaseServiceImpl<OptimizationTopicMapper, OptimizationTopicEntity> implements IOptimizationTopicService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据项目立项id修改占用标志
     *
     * @param topicId    项目立项id
     * @param occupyFlag 占用标志
     * @param occupyType 占用类型
     */
    @Override
    public void updateOccupyFlagByTopicId(Long topicId, Integer occupyFlag, Integer occupyType) {
        this.updateOccupyFlagByTopicIds(Collections.singletonList(topicId), occupyFlag, occupyType);
    }

    /**
     * 根据项目立项id批量修改占用标志
     *
     * @param topicIdList 项目立项id列表
     * @param occupyFlag  占用标志
     * @param occupyType  占用类型
     */
    @Override
    public void updateOccupyFlagByTopicIds(List<Long> topicIdList, Integer occupyFlag, Integer occupyType) {
        logger.info("修改占用标志参数： 项目立项申报id：{}，占用标志：{}，占用类型：{}",
                JSONObject.toJSONString(topicIdList), occupyFlag, occupyType);
        if (CollectionUtils.isEmpty(topicIdList)) {
            return;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, topicIdList));
        List<OptimizationTopicEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(list)) {
            logger.info("未查询到项目优化立项申报信息");
            return;
        }
        for (OptimizationTopicEntity entity : list) {
            if (OccupyTypeEnum.项目优化效益计算.getCode().equals(occupyType)) {
                entity.setCalculationOccupyFlag(occupyFlag);
            }
            else if(OccupyTypeEnum.项目优化奖励申请.getCode().equals(occupyType)){
                entity.setRewardOccupyFlag(occupyFlag);
            }
        }
        super.saveOrUpdateBatch(list);
    }


}
