package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.order.vo.SupRentOrderDetailVO;
import com.ejianc.business.zjkjcost.reserve.bean.*;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeTypeEnum;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateChangeDetailVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.reserve.mapper.AllocateChangeMapper;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateChangeService;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 风险预留金-项目部人员风险金预留分配变更表
 * 
 * @author generator
 * 
 */
@Service("allocateChangeService")
public class AllocateChangeServiceImpl extends BaseServiceImpl<AllocateChangeMapper, AllocateChangeEntity> implements IAllocateChangeService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IAllocateService allocateService;

    @Autowired
    private IAllocateHistoryService allocateHistoryService;

    private static final String BILL_CODE = "FXYLJFPBG_CODE";//此处需要根据实际修改



    @Override
    public AllocateChangeVO saveOrUpdate(AllocateChangeVO saveOrUpdateVO) {
        AllocateChangeEntity entity = BeanMapper.map(saveOrUpdateVO, AllocateChangeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(entity.getBillCode()+ entity.getChangeVersion());
        }

        //变更只能存在一条未生效的
        //查询语句，主id一致，且变更id不同，单据状态不为已通过或已提交的
        LambdaQueryWrapper<AllocateChangeEntity> lambdachange = Wrappers.<AllocateChangeEntity>lambdaQuery();
        lambdachange.eq(AllocateChangeEntity::getTargetId,entity.getTargetId());
        if(entity.getId() != null) {
            lambdachange.ne(AllocateChangeEntity::getId,entity.getId());
        }
        lambdachange.notIn(AllocateChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("存在未生效的变更单!");
        }

        super.saveOrUpdate(entity, false);
        //回显原单据信息
        saveWriteAllocate(entity);
        AllocateChangeVO vo = BeanMapper.map(entity, AllocateChangeVO.class);
        return vo;
    }


    @Override
    public void delete(Long changId) {
        delWriteAllocate(changId);
        super.removeById(changId);
    }

    /**
     * 保存回写单据信息
     * @param changeEntity
     */
    private void saveWriteAllocate(AllocateChangeEntity changeEntity){
        LambdaUpdateWrapper<AllocateEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(AllocateEntity::getChangeId, changeEntity.getId());
        updateWrapper.set(AllocateEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(AllocateEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(AllocateEntity::getChangeState, ChangeStateEnum.变更中.getCode());
        updateWrapper.set(AllocateEntity::getChangeTime, changeEntity.getChangeTime());
        updateWrapper.eq(AllocateEntity::getId, changeEntity.getTargetId());
        allocateService.update(allocateService.selectById(changeEntity.getTargetId()), updateWrapper, false);
    }

    /**
     * 删除回写单据信息
     * @param
     */
    private void delWriteAllocate(Long changeId){
        AllocateChangeEntity changeEntity = super.selectById(changeId);
        LambdaQueryWrapper<AllocateChangeEntity> lambdachange = Wrappers.<AllocateChangeEntity>lambdaQuery();
        lambdachange.eq(AllocateChangeEntity::getTargetId,changeEntity.getTargetId());
        lambdachange.eq(AllocateChangeEntity::getDr, BaseVO.DR_UNDELETE);
        lambdachange.ne(AllocateChangeEntity::getId,changeEntity.getId());
        int count = super.count(lambdachange);
        AllocateEntity allocateEntity = allocateService.selectById(changeEntity.getTargetId());
        allocateEntity.setChangeCode(null);
        allocateEntity.setChangeId(null);
        allocateEntity.setChangeState(count > 0 ? ChangeStateEnum.已变更.getCode() : ChangeStateEnum.未变更.getCode());
        allocateEntity.setChangeTime(null);
        allocateEntity.setChangeVersion(allocateEntity.getChangeVersion()==1?null:allocateEntity.getChangeVersion()-1);
        allocateService.update(allocateEntity, new QueryWrapper<AllocateEntity>().eq("id",allocateEntity.getId()), false);
    }

    /**
     * @Author yangst
     * @Description  新增根据原单据主键查询变更需要的字段
     * @param targetId
     */
    @Override
    public AllocateChangeVO addConvertByConId(Long targetId) {
        AllocateEntity allocateEntity = allocateService.selectById(targetId);
        AllocateChangeVO allocateChangeVO = BeanMapper.map(allocateEntity, AllocateChangeVO.class);
        //设置变更前金额
        allocateChangeVO.setBeforeShouldReserveMny(allocateChangeVO.getShouldReserveMny());
        allocateChangeVO.setBeforeActualReserveMny(allocateChangeVO.getActualReserveMny());
        allocateChangeVO.setBeforeReserveRatio(allocateChangeVO.getReserveRatio());
        allocateChangeVO.setBillState(null);
        allocateChangeVO.setTargetId(targetId);
        allocateChangeVO.setChangeVersion(allocateEntity.getChangeVersion() == null ? 1 : allocateEntity.getChangeVersion()+ 1);
        allocateChangeVO.setCreateUserCode(null);
        allocateChangeVO.setCreateTime(null);
        allocateChangeVO.setUpdateUserCode(null);
        allocateChangeVO.setUpdateTime(null);
        allocateChangeVO.setChangeTime(new Date());
        allocateChangeVO.setId(null);
        //设置明细表字段
        List<AllocateChangeDetailVO> allocateChangeDetailList = allocateChangeVO.getDetailList();
        if(CollectionUtils.isNotEmpty(allocateChangeDetailList)){
            for (AllocateChangeDetailVO allocateChangeDetailVO : allocateChangeDetailList) {
                allocateChangeDetailVO.setTargetDetailId(allocateChangeDetailVO.getId());
                allocateChangeDetailVO.setBeforeDetailRatio(allocateChangeDetailVO.getDetailRatio());
                allocateChangeDetailVO.setBeforeActualDetailMny(allocateChangeDetailVO.getActualDetailMny());
                allocateChangeDetailVO.setBeforeShouldDetailMny(allocateChangeDetailVO.getShouldDetailMny());
                allocateChangeDetailVO.setChangeType(ChangeTypeEnum.未变更.getCode());
                allocateChangeDetailVO.setRowState("add");
                allocateChangeDetailVO.setCreateUserCode(null);
                allocateChangeDetailVO.setCreateTime(null);
                allocateChangeDetailVO.setUpdateUserCode(null);
                allocateChangeDetailVO.setUpdateTime(null);
                allocateChangeDetailVO.setId(null);
            }
        }
        return allocateChangeVO;
    }

    /**
     * 变更单据生效创建记录文件并回写主合同
     * @param changeId
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeId, String billTypeCode) {
        CommonResponse<String> resp = null;
        /**更新变更*/
        AllocateChangeEntity changeEntity = super.selectById(changeId);
        changeEntity.setEffectiveTime(new Date());
        super.saveOrUpdate(changeEntity,false);
        logger.info("进入变更终审！变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));

        /**复制合同表数据到记录表 begin */
        AllocateEntity allocateEntity = allocateService.selectById(changeEntity.getTargetId());
        AllocateHistoryEntity historyEntity = BeanMapper.map(allocateEntity, AllocateHistoryEntity.class);
        historyEntity.setId(null);
        Map<Long, Integer> contIdVersionMap =  new HashMap<>();

        logger.info("变更前主数据: {}", JSONObject.toJSONString(allocateEntity));
        logger.info("变更前主子表detail数据: {}", JSONObject.toJSONString(allocateEntity.getDetailList()));
        logger.info("记录表从主表复制的数据: {}", JSONObject.toJSONString(historyEntity));
        logger.info("记录表从主表复制的数据的子表detail数据: {}", JSONObject.toJSONString(historyEntity.getDetailList()));

        if(CollectionUtils.isNotEmpty(historyEntity.getDetailList())){
            historyEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setTargetDetailId(vo.getId());
                vo.setId(null);
            });
        }
        logger.info("记录表从主合同表复制的子表detail数据，设置id后的值: {}", JSONObject.toJSONString(historyEntity.getDetailList()));
        allocateHistoryService.saveOrUpdate(historyEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");
//        String srcBillCode = LABORSUB_Bill_CODE;
//        String targetBillCode = LABORSUB_RECORD_Bill_CODE;
//        //原合同附件、起草附件同步到记录单据中
//        resp = copyFile(contractVO.getId().toString(), srcBillCode,
//                recordEntity.getId().toString(), targetBillCode, CONTRACT_ATTACH_SOURCE_TYPE, true);
//        if(resp != null) {
//            logger.error("同步原附件到记录单据失败，失败原因：{}", JSONObject.toJSONString(resp));
//        }
        /**复制主单据数据到记录表 end */

        /**更新变更表主表数据到原单据 begin */
        logger.info("更新变更数据到主数据表,主数据---------------->: {}", JSONObject.toJSONString(allocateEntity));
        logger.info("更新变更数据到主数据表,变更数据---------------->: {}", JSONObject.toJSONString(changeEntity));
        //基本信息
        allocateEntity.setEmployeeId(changeEntity.getEmployeeId());
        allocateEntity.setEmployeeName(changeEntity.getEmployeeName());
        allocateEntity.setEmployeeTime(changeEntity.getEmployeeTime());
        allocateEntity.setBaseReserveRatio(changeEntity.getBaseReserveRatio());
        allocateEntity.setBaseActualReserveMny(changeEntity.getBaseActualReserveMny());
        allocateEntity.setBaseShouldReserveMny(changeEntity.getBaseShouldReserveMny());
        allocateEntity.setReserveRatio(changeEntity.getReserveRatio());
        allocateEntity.setActualReserveMny(changeEntity.getActualReserveMny());
        allocateEntity.setShouldReserveMny(changeEntity.getShouldReserveMny());
        allocateEntity.setChangeState(ChangeStateEnum.已变更.getCode());
//        //同步变更单附件（不包含变更变更附件）到原合同
//        resp = copyFile(changeBillId.toString(), billTypeCode, contractEntity.getId().toString(), srcBillCode, "subChangeContractFile", false);
//        if(resp != null) {
//            logger.error("同步变更附件到原合同失败，失败原因：{}", JSONObject.toJSONString(resp));
//        }
        List<AllocateDetailEntity>  saveDetailList= new ArrayList<>();//新增更新子表
        List<AllocateDetailEntity>  delDetailList= new ArrayList<>();//删除子表
        List<AllocateDetailEntity> detailList = allocateEntity.getDetailList();
        List<AllocateChangeDetailEntity>  detailChangeList= changeEntity.getDetailList();
        //变更单变更子表
        Map<Long, AllocateChangeDetailEntity> mapBGChang = detailChangeList.stream().filter(t->t.getTargetDetailId()!=null).collect(Collectors.toMap(AllocateChangeDetailEntity::getTargetDetailId, Function.identity()));
        //变更单新增子表
        Map<Long, AllocateChangeDetailEntity> mapADDChang = detailChangeList.stream().filter(t -> t.getTargetDetailId() == null).collect(Collectors.toMap(AllocateChangeDetailEntity::getTargetDetailId, Function.identity()));
        if(CollectionUtils.isNotEmpty(detailList)){
            for (AllocateDetailEntity detailEntity : detailList) {
                AllocateChangeDetailEntity entity = mapBGChang.get(detailEntity.getId());
                if(null==entity){
                    delDetailList.add(detailEntity);
                }else {
                    AllocateDetailEntity map = BeanMapper.map(entity, AllocateDetailEntity.class);
                    map.setId(map.getTargetDetailId());
                    map.setVersion(detailEntity.getVersion());
                    map.setChangeType(null);
                    map.setAllocateId(allocateEntity.getId());
                    saveDetailList.add(map);
                }
            }
        }
        if(CollectionUtils.isNotEmpty(mapADDChang.values())){
            List<AllocateChangeDetailEntity> values = (List<AllocateChangeDetailEntity>) mapADDChang.values();
            for (AllocateChangeDetailEntity value : values) {
                AllocateDetailEntity map = BeanMapper.map(value, AllocateDetailEntity.class);
                map.setId(null);
                map.setChangeType(null);
                map.setRowState("add");
                map.setAllocateId(allocateEntity.getId());
                saveDetailList.add(map);
            }
        }
        allocateEntity.setDetailList(saveDetailList);
        allocateService.saveOrUpdate(allocateEntity,false);
        logger.info("更新变更表合同状态和数据,---------->： {}", JSONObject.toJSONString(changeEntity));
        /**更新变更表主表数据到单据 end */
        logger.info("更新主表数据成功,---------->: {}", JSONObject.toJSONString(allocateEntity));
        /**更新变更子表数据到原合同子表 end */
        return CommonResponse.success("变更单生效，回写合同成功！");
    }

//    /**
//     * 文件复制
//     *
//     * @param srcBillId 源单据Id
//     * @param srcBillTypeCode 源单据类型
//     * @param targetBillId 目标单据Id
//     * @param targetBillTypeCode 目标单据类型
//     * @param srcAttachSourceType 源单据附件业务类型
//     * @return
//     */
//    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {
//
//        //同步合同附件列表
//        CommonResponse copyContractAttachResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode,
//                srcAttachSourceType, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE);
//        if (!copyContractAttachResp.isSuccess()){
//            logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
//                    ,srcBillId, srcBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, copyContractAttachResp.getMsg());
//            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}", copyContractAttachResp.getMsg());
//            return CommonResponse.error("审批失败，同步附件失败，错误信息：" + copyContractAttachResp.getMsg());
//        }
//
//        if(copyContractFile) {
//            //同步合同文件
//            CommonResponse copyContractFileResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE,
//                    targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE);
//            if (!copyContractFileResp.isSuccess()){
//                logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
//                        ,srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, copyContractFileResp.getMsg());
//                return CommonResponse.error("审批失败，同步合同文件失败，错误信息：" + copyContractFileResp.getMsg());
//            }
//        }
//
//        return null;
//    }
}
