package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateDetailVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.reserve.mapper.AllocateMapper;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 风险预留金-项目部人员风险金预留分配表
 * 
 * @author generator
 * 
 */
@Service("allocateService")
public class AllocateServiceImpl extends BaseServiceImpl<AllocateMapper, AllocateEntity> implements IAllocateService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FXYLJFP_CODE";//此处需要根据实际修改
    @Override
    public AllocateVO saveOrUpdate(AllocateVO saveOrUpdateVO) {
        AllocateEntity entity = BeanMapper.map(saveOrUpdateVO, AllocateEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //设置初始金额
        entity.setBaseShouldReserveMny(entity.getShouldReserveMny());
        entity.setBaseActualReserveMny(entity.getActualReserveMny());
        entity.setBaseReserveRatio(entity.getReserveRatio());
        entity.setChangeState(ChangeStateEnum.未变更.getCode());
        super.saveOrUpdate(entity, false);
        AllocateVO vo = BeanMapper.map(entity, AllocateVO.class);
        return vo;
    }

    @Override
    public Map<String,Object> getProjectUser(Long projectId, Long orgId, Long id) {
        Map<String,Object> map = new HashMap<>();
        Boolean flag = false; //代表项目下没数据
        List<AllocateEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<AllocateEntity> lambda = Wrappers.<AllocateEntity>lambdaQuery();
        lambda.eq(AllocateEntity::getProjectId, projectId);
        if(null!=id){
            lambda.ne(AllocateEntity::getId,id);
        }
        entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            flag = true;  //代表项目下有数据
        }
        map.put("flag",flag);
        return null;
    }
}
