/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.optimization.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zjkjcost.optimization.bean.OptimizationTopicEntity;
import com.ejianc.business.zjkjcost.optimization.enums.OccupyTypeEnum;
import com.ejianc.business.zjkjcost.optimization.mapper.OptimizationTopicMapper;
import com.ejianc.business.zjkjcost.optimization.service.IOptimizationTopicService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="optimizationTopicService")
public class OptimizationTopicServiceImpl
extends BaseServiceImpl<OptimizationTopicMapper, OptimizationTopicEntity>
implements IOptimizationTopicService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void updateOccupyFlagByTopicId(Long topicId, Integer occupyFlag, Integer occupyType) {
        this.updateOccupyFlagByTopicIds(Collections.singletonList(topicId), occupyFlag, occupyType);
    }

    @Override
    public void updateOccupyFlagByTopicIds(List<Long> topicIdList, Integer occupyFlag, Integer occupyType) {
        this.logger.info("\u4fee\u6539\u5360\u7528\u6807\u5fd7\u53c2\u6570\uff1a \u9879\u76ee\u7acb\u9879\u7533\u62a5id\uff1a{}\uff0c\u5360\u7528\u6807\u5fd7\uff1a{}\uff0c\u5360\u7528\u7c7b\u578b\uff1a{}", new Object[]{JSONObject.toJSONString(topicIdList), occupyFlag, occupyType});
        if (CollectionUtils.isEmpty(topicIdList)) {
            return;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", topicIdList));
        List list = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4f18\u5316\u7acb\u9879\u7533\u62a5\u4fe1\u606f");
            return;
        }
        for (OptimizationTopicEntity entity : list) {
            if (OccupyTypeEnum.\u9879\u76ee\u4f18\u5316\u6548\u76ca\u8ba1\u7b97.getCode().equals(occupyType)) {
                entity.setCalculationOccupyFlag(occupyFlag);
                continue;
            }
            if (!OccupyTypeEnum.\u9879\u76ee\u4f18\u5316\u5956\u52b1\u7533\u8bf7.getCode().equals(occupyType)) continue;
            entity.setRewardOccupyFlag(occupyFlag);
        }
        super.saveOrUpdateBatch((Collection)list);
    }
}

