package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateChangeEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateHistoryEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryService;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateDetailVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateHistoryVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateVO;
import com.ejianc.business.zjkjcost.reserve.vo.PersonalApproveVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.reserve.mapper.AllocateMapper;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 风险预留金-项目部人员风险金预留分配表
 * 
 * @author generator
 * 
 */
@Service("allocateService")
public class AllocateServiceImpl extends BaseServiceImpl<AllocateMapper, AllocateEntity> implements IAllocateService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IPersonalApproveService personalApproveService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAllocateHistoryService allocateHistoryService;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FXYLJFP_CODE";//此处需要根据实际修改
    @Override
    public AllocateVO saveOrUpdate(AllocateVO saveOrUpdateVO) {
        AllocateEntity entity = BeanMapper.map(saveOrUpdateVO, AllocateEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //设置初始金额
        entity.setBaseShouldReserveMny(entity.getShouldReserveMny());
        entity.setBaseActualReserveMny(entity.getActualReserveMny());
        entity.setBaseReserveRatio(entity.getReserveRatio());
        entity.setChangeState(ChangeStateEnum.未变更.getCode());
        super.saveOrUpdate(entity, false);
        AllocateVO vo = BeanMapper.map(entity, AllocateVO.class);
        return vo;
    }

    @Override
    public Map<String,Object> getProjectUser(Long projectId, Long orgId, Long id) {
        Map<String,Object> map = new HashMap<>();
        Boolean flag = false; //代表项目下没数据
        List<AllocateEntity> entities = new ArrayList<>();
        LambdaQueryWrapper<AllocateEntity> lambda = Wrappers.<AllocateEntity>lambdaQuery();
        lambda.eq(AllocateEntity::getProjectId, projectId);
        if(null!=id){
            lambda.ne(AllocateEntity::getId,id);
        }
        entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            flag = true;  //代表项目下有数据
        }
        map.put("flag",flag);
        CommonResponse<List<Map<String, Object>>> employeeList = userApi.getEmployeeList(orgId);
        ArrayList<AllocateDetailVO> detailVOS = new ArrayList<>();
        if(employeeList.isSuccess()){
            List<Map<String, Object>> data = employeeList.getData();
                if(null!=data && CollectionUtils.isNotEmpty(data)){
                    for (Map<String, Object> datum : data) {
                        if(!datum.isEmpty()){
                            AllocateDetailVO detailVO = new AllocateDetailVO();
                            if(null!=datum.get("userId")){
                                detailVO.setPersonnelId(Long.valueOf(String.valueOf(datum.get("userId"))));
                                detailVO.setPersonnelName(String.valueOf(datum.get("userName")));
                                detailVOS.add(detailVO);
                            }
                        }
                    }
                }
        }else {
            throw new BusinessException("查询项目部人员失败，原因："+employeeList.getMsg());
        }
        if(CollectionUtils.isNotEmpty(detailVOS)){
            List<Long> collect = detailVOS.stream().map(t -> t.getPersonnelId()).collect(Collectors.toList());
            LambdaQueryWrapper<PersonalApproveEntity> lambdachange = Wrappers.<PersonalApproveEntity>lambdaQuery();
            lambdachange.in(PersonalApproveEntity::getApplicantId, collect);
            lambdachange.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
            lambdachange.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            List<PersonalApproveEntity> list = personalApproveService.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list, PersonalApproveVO.class);
                for (AllocateDetailVO detailVO : detailVOS) {
                    for (PersonalApproveVO approve : approveVOS) {
                        if(detailVO.getPersonnelId().equals(approve.getApplicantId())){
                            if(StringUtils.isNotBlank(detailVO.getFhzdltIds())){
                                detailVO.setFhzdltIds(detailVO.getFhzdltIds()+","+approve.getId());
                            }else {
                                detailVO.setFhzdltIds(String.valueOf(approve.getId()));
                            }
                            List<PersonalApproveVO> personalApproveVOS = detailVO.getPersonalApproveVOS();
                            personalApproveVOS.add(approve);
                        }
                    }
                }
            }
        }
        map.put("detailVOS",detailVOS);
        return map;
    }

    @Override
    public AllocateVO queryDetail(Long id) {
        AllocateEntity entity = super.selectById(id);
        AllocateVO vo = BeanMapper.map(entity, AllocateVO.class);
        LambdaQueryWrapper<AllocateHistoryEntity> lambdachange = Wrappers.<AllocateHistoryEntity>lambdaQuery();
        lambdachange.eq(AllocateHistoryEntity::getTargetId,vo.getId());
        lambdachange.eq(AllocateHistoryEntity::getDr, BaseVO.DR_UNDELETE);
        lambdachange.orderByDesc(AllocateHistoryEntity::getCreateTime);
        List<AllocateHistoryEntity> list = allocateHistoryService.list(lambdachange);
        vo.setHistoryList(BeanMapper.mapList(list,AllocateHistoryVO.class));
        List<AllocateDetailVO> detailVOS = vo.getDetailList();
        if(CollectionUtils.isNotEmpty(detailVOS)){
            List<String> collect = detailVOS.stream().filter(t->StringUtils.isNotBlank(t.getFhzdltIds())).map(t -> t.getFhzdltIds()).collect(Collectors.toList());
            List<Long> longs = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(collect))
            for (String s : collect) {
                String[] split = s.split(",");
                List<Long> collect1 = Arrays.stream(split).map(t -> Long.parseLong(t.trim())).collect(Collectors.toList());
                longs.addAll(collect1);
            }
            if(CollectionUtils.isNotEmpty(longs)){
                LambdaQueryWrapper<PersonalApproveEntity> lambda = Wrappers.<PersonalApproveEntity>lambdaQuery();
                lambda.in(PersonalApproveEntity::getId, longs);
                lambda.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
                lambda.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
                List<PersonalApproveEntity> list2 = personalApproveService.list(lambda);
                if(CollectionUtils.isNotEmpty(list2)){
                    List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list2, PersonalApproveVO.class);
                    for (AllocateDetailVO detailVO : detailVOS) {
                        for (PersonalApproveVO approve : approveVOS) {
                            if(detailVO.getPersonnelId().equals(approve.getApplicantId())){
                                List<PersonalApproveVO> personalApproveVOS = detailVO.getPersonalApproveVOS();
                                personalApproveVOS.add(approve);
                            }
                        }
                    }
                }
            }
        }
        return vo;
    }

    @Override
    public Map<String, Object> queryDetailFHZD(Long personnelId) {
        Map<String, Object> map = new HashMap<>();
        String fhzdltIds = null;
        List<PersonalApproveVO> personalApproveVOS = new ArrayList<>();
        LambdaQueryWrapper<PersonalApproveEntity> lambdachange = Wrappers.<PersonalApproveEntity>lambdaQuery();
        lambdachange.eq(PersonalApproveEntity::getApplicantId, personnelId);
        lambdachange.eq(PersonalApproveEntity::getDr, BaseVO.DR_UNDELETE);
        lambdachange.in(PersonalApproveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<PersonalApproveEntity> list = personalApproveService.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            List<PersonalApproveVO> approveVOS = BeanMapper.mapList(list, PersonalApproveVO.class);
            for (PersonalApproveVO approve : approveVOS) {
                    if(null==fhzdltIds){
                        fhzdltIds=fhzdltIds+","+approve.getId();
                    }else {
                        fhzdltIds=String.valueOf(approve.getId());
                    }
                    personalApproveVOS.add(approve);
            }
        }
        map.put("personnelId",personnelId);
        map.put("fhzdltIds",fhzdltIds);
        map.put("personalApproveVOS",personalApproveVOS);
        return map;
    }
}
